/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.internal.core;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xwt.IDataBindingInfo;
import org.eclipse.xwt.IDataProvider;
import org.eclipse.xwt.IMultiValueConverter;
import org.eclipse.xwt.IValidationRule;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.converters.StringMultiValueConerter;
import org.eclipse.xwt.core.IDynamicBinding;
import org.eclipse.xwt.databinding.AggregateObservableValue;
import org.eclipse.xwt.databinding.IBindingContext;
import org.eclipse.xwt.internal.core.Binding;
import org.eclipse.xwt.internal.core.BindingExpressionPath;
import org.eclipse.xwt.internal.core.BindingGate;
import org.eclipse.xwt.internal.core.DynamicBinding;
import org.eclipse.xwt.internal.core.ScopeManager;
import org.eclipse.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.xwt.internal.utils.LoggerManager;
import org.eclipse.xwt.internal.utils.UserData;

public class MultiBinding
extends DynamicBinding
implements IDataBindingInfo {
    private Binding[] bindings = Binding.EMPTY_ARRAY;
    private IMultiValueConverter valueConverter;
    private IValidationRule[] valueValidators = IValidationRule.EMPTY_ARRAY;
    private AggregateObservableValue observableValue;
    private IObservableValue observableWidget;
    private BindingExpressionPath targetPropertySegments;
    private UpdateSourceTrigger updateSourceTrigger = UpdateSourceTrigger.Default;
    private BindingGate bindingGate;

    public UpdateSourceTrigger getUpdateSourceTrigger() {
        return this.updateSourceTrigger;
    }

    public void setUpdateSourceTrigger(UpdateSourceTrigger updateSourceTrigger) {
        this.updateSourceTrigger = updateSourceTrigger;
    }

    public Binding[] getBindings() {
        return this.bindings;
    }

    public void setBindings(Binding[] bindings) {
        this.bindings = bindings;
    }

    @Override
    public IMultiValueConverter getConverter() {
        if (this.valueConverter == null) {
            this.valueConverter = new StringMultiValueConerter();
        }
        return this.valueConverter;
    }

    public void setConverter(IMultiValueConverter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public boolean isSourcePropertyReadOnly() {
        Binding[] bindingArray = this.bindings;
        int n = this.bindings.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            if (binding.isSourcePropertyReadOnly()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object getValue(Class<?> targetType) {
        if (this.observableValue == null) {
            IObservableValue[] values = new IObservableValue[this.bindings.length];
            int i = 0;
            while (i < values.length) {
                this.bindings[i].getValue(targetType);
                IObservable observable = this.bindings[i].getObservableSource();
                if (!(observable instanceof IObservableValue)) {
                    LoggerManager.log("Binding expression has a problem with " + this.bindings[i].getPath());
                    return null;
                }
                values[i] = (IObservableValue)observable;
                ++i;
            }
            this.observableValue = new AggregateObservableValue(values, this.getConverter());
        }
        IObservableValue observableWidget = this.getObservableWidget();
        IDataProvider dataProvider = this.getDataProvider();
        if (dataProvider != null) {
            BindingGate bindingGate = this.getBindingGate();
            if (bindingGate != null) {
                Object target = this.getControl();
                if (target instanceof Text && this.getType().equalsIgnoreCase("text")) {
                    if (this.isSourcePropertyReadOnly()) {
                        Text text = (Text)target;
                        text.setEditable(false);
                    }
                } else if (target instanceof Button && this.getType().equalsIgnoreCase("selection")) {
                    if (this.isSourcePropertyReadOnly()) {
                        Button button = (Button)target;
                        button.setEnabled(false);
                    }
                } else if ((target instanceof Combo || target instanceof CCombo) && this.getType().equalsIgnoreCase("text")) {
                    if (this.isSourcePropertyReadOnly()) {
                        Control control = (Control)target;
                        control.setEnabled(false);
                    }
                } else if (target instanceof MenuItem && this.getType().equalsIgnoreCase("selection")) {
                    if (this.isSourcePropertyReadOnly()) {
                        MenuItem menuItem = (MenuItem)target;
                        menuItem.setEnabled(false);
                    }
                } else if (target instanceof DateTime && this.getType().equalsIgnoreCase("selection") && this.isSourcePropertyReadOnly()) {
                    DateTime dateTime = (DateTime)target;
                    dateTime.setEnabled(false);
                }
            }
            bindingGate.bind((IObservable)this.observableValue, (IObservable)observableWidget, this);
        }
        if (targetType == null || !targetType.isInstance((Object)this.observableValue)) {
            return this.observableValue.getValue();
        }
        return this.observableValue;
    }

    private BindingGate getBindingGate() {
        if (this.bindingGate == null) {
            IBindingContext dataBindingContext = XWT.getBindingContext(this.getControl());
            this.bindingGate = new BindingGate(dataBindingContext);
        }
        return this.bindingGate;
    }

    public IObservableValue getObservableWidget() {
        if (this.observableWidget == null) {
            Object target = this.getControl();
            Object host = this.getHost();
            try {
                this.observableWidget = ScopeManager.observeValue(target, host, this.getTargettPropertyExpression(), this.getUpdateSourceTrigger());
            }
            catch (XWTException xWTException) {}
        }
        return this.observableWidget;
    }

    @Override
    public Object createBoundSource() {
        Object control = this.getControl();
        Object source = XWT.getDataContext(control);
        Object localDataContext = UserData.getLocalDataContext(control);
        if (localDataContext == this) {
            return source;
        }
        if (source instanceof IDynamicBinding) {
            return ((IDynamicBinding)source).createBoundSource();
        }
        return source;
    }

    @Override
    public boolean isSourceControl() {
        Object source = null;
        Object dataContextHost = this.getDataContextHost();
        if (dataContextHost != null) {
            source = UserData.getLocalDataContext(dataContextHost);
        }
        if (source instanceof IDynamicBinding) {
            return ((IDynamicBinding)source).isSourceControl();
        }
        return false;
    }

    public BindingExpressionPath getTargettPropertyExpression() {
        if (this.targetPropertySegments == null) {
            this.targetPropertySegments = new BindingExpressionPath(this.getType());
        }
        return this.targetPropertySegments;
    }

    @Override
    public IValidationRule[] getValidators() {
        return this.valueValidators;
    }

    public void setValidators(IValidationRule[] valueValidators) {
        this.valueValidators = valueValidators;
    }

    @Override
    public void reset() {
        Binding[] bindingArray = this.bindings;
        int n = this.bindings.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            binding.reset();
            ++n2;
        }
    }
}

