/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.is.core.ui.internal;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.cmake.is.core.IParserPreferences;
import org.eclipse.cdt.cmake.is.core.IParserPreferencesAccess;
import org.eclipse.cdt.cmake.is.core.IParserPreferencesMetadata;
import org.eclipse.cdt.cmake.is.core.ui.internal.Messages;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class IndexerSupportPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text pattern;
    private Button btnVersionsEnabled;
    private Button btnWithConsole;
    private final IParserPreferencesAccess prefsAccess = (IParserPreferencesAccess)EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext()).get(IParserPreferencesAccess.class);

    public IndexerSupportPreferencePage() {
        this.setDescription(Messages.IndexerSupportPreferencePage_description);
    }

    protected Control createContents(Composite parent) {
        IParserPreferencesMetadata prefsMeta = this.prefsAccess.metadata();
        IParserPreferences prefs = this.prefsAccess.getWorkspacePreferences();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.swtDefaults().applyTo((Control)composite);
        Group gr = IndexerSupportPreferencePage.createGroup(composite, 4, 1, Messages.IndexerSupportPreferencePage_label_version_suffix_group, 2);
        this.btnVersionsEnabled = IndexerSupportPreferencePage.createCheckbox((Composite)gr, 1, 2, (PreferenceMetadata<Boolean>)prefsMeta.tryVersionSuffix());
        this.btnVersionsEnabled.setSelection(prefs.getTryVersionSuffix());
        Label label = new Label((Composite)gr, 0);
        label.setText(Messages.IndexerSupportPreferencePage_label_suffix_pattern);
        GridDataFactory.defaultsFor((Control)label).applyTo((Control)label);
        this.pattern = new Text((Composite)gr, 2052);
        GridDataFactory.defaultsFor((Control)this.pattern).applyTo((Control)this.pattern);
        this.pattern.setToolTipText(prefsMeta.versionSuffixPattern().description());
        this.pattern.setEnabled(this.btnVersionsEnabled.getSelection());
        this.pattern.setText(prefs.getVersionSuffixPattern());
        this.pattern.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (IndexerSupportPreferencePage.this.btnVersionsEnabled.getSelection()) {
                    String text = IndexerSupportPreferencePage.this.pattern.getText();
                    try {
                        Pattern.compile(text);
                        IndexerSupportPreferencePage.this.setErrorMessage(null);
                    }
                    catch (PatternSyntaxException ex) {
                        String msg = String.format(Messages.IndexerSupportPreferencePage_errmsg_suffix_regex, ex.getDescription(), ex.getPattern(), ex.getIndex());
                        IndexerSupportPreferencePage.this.setErrorMessage(msg);
                    }
                }
            }
        });
        this.btnVersionsEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean selected = ((Button)event.widget).getSelection();
                IndexerSupportPreferencePage.this.pattern.setEnabled(selected);
                if (!selected) {
                    IndexerSupportPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.btnWithConsole = IndexerSupportPreferencePage.createCheckbox(composite, 1, 1, (PreferenceMetadata<Boolean>)prefsMeta.allocateConsole());
        this.btnWithConsole.setSelection(prefs.getAllocateConsole());
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IParserPreferencesMetadata prefsMeta = this.prefsAccess.metadata();
        this.btnVersionsEnabled.setSelection(((Boolean)prefsMeta.tryVersionSuffix().defaultValue()).booleanValue());
        this.pattern.setText((String)prefsMeta.versionSuffixPattern().defaultValue());
        this.btnWithConsole.setSelection(((Boolean)prefsMeta.allocateConsole().defaultValue()).booleanValue());
        this.setErrorMessage(null);
        super.performDefaults();
    }

    public boolean performOk() {
        IParserPreferences prefs = this.prefsAccess.getWorkspacePreferences();
        prefs.setTryVersionSuffix(this.btnVersionsEnabled.getSelection());
        prefs.setVersionSuffixPattern(this.pattern.getText());
        prefs.setAllocateConsole(this.btnWithConsole.getSelection());
        return true;
    }

    private static Button createCheckbox(Composite parent, int horizontalAlignment, int horizontalSpan, PreferenceMetadata<Boolean> option) {
        Button b = new Button(parent, 32);
        b.setText(option.name());
        b.setToolTipText(option.description());
        GridDataFactory.defaultsFor((Control)b).align(horizontalAlignment, 0x1000000).span(horizontalSpan, 1).grab(true, false).applyTo((Control)b);
        return b;
    }

    private static Group createGroup(Composite parent, int horizontalAlignment, int horizontalSpan, String text, int numColumns) {
        Group gr = new Group(parent, 0);
        gr.setLayout((Layout)new GridLayout(numColumns, false));
        gr.setText(text);
        GridDataFactory.defaultsFor((Control)gr).align(horizontalAlignment, 0x1000000).span(horizontalSpan, 1).grab(true, false).applyTo((Control)gr);
        return gr;
    }
}

