/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.handlers;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.EclEmmaStatus;
import org.eclipse.eclemma.core.ICoverageSession;
import org.eclipse.eclemma.core.ISessionManager;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.eclemma.internal.ui.dialogs.MergeSessionsDialog;
import org.eclipse.eclemma.internal.ui.handlers.AbstractSessionManagerHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSessionsHandler
extends AbstractSessionManagerHandler {
    public MergeSessionsHandler() {
        super(CoverageTools.getSessionManager());
    }

    public boolean isEnabled() {
        return this.sessionManager.getSessions().size() > 1;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell parentShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISessionManager sm = CoverageTools.getSessionManager();
        List sessions = sm.getSessions();
        String descr = UIMessages.MergeSessionsDialogDescriptionDefault_value;
        MergeSessionsDialog d = new MergeSessionsDialog(parentShell, sessions, descr = MessageFormat.format(descr, new Date()));
        if (d.open() == 0) {
            this.createJob(sm, d.getSessions(), d.getDescription()).schedule();
        }
        return null;
    }

    private Job createJob(final ISessionManager sm, final Collection<ICoverageSession> sessions, final String description) {
        Job job = new Job(UIMessages.MergingSessions_task){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    sm.mergeSessions(sessions, description, monitor);
                }
                catch (CoreException e) {
                    return EclEmmaStatus.MERGE_SESSIONS_ERROR.getStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        return job;
    }
}

