/*
 * generated by Xtext 2.17.0
 */
package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.dot.internal.language.fontname.FontnamePackage;
import org.eclipse.gef.dot.internal.language.fontname.GravityOption;
import org.eclipse.gef.dot.internal.language.fontname.PangoFontName;
import org.eclipse.gef.dot.internal.language.fontname.PostScriptFontName;
import org.eclipse.gef.dot.internal.language.fontname.StretchOption;
import org.eclipse.gef.dot.internal.language.fontname.StyleOption;
import org.eclipse.gef.dot.internal.language.fontname.VariantOption;
import org.eclipse.gef.dot.internal.language.fontname.WeightOption;
import org.eclipse.gef.dot.internal.language.services.DotFontNameGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class DotFontNameSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DotFontNameGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == FontnamePackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case FontnamePackage.GRAVITY_OPTION:
				sequence_GravityOption(context, (GravityOption) semanticObject); 
				return; 
			case FontnamePackage.PANGO_FONT_NAME:
				sequence_PangoFontName(context, (PangoFontName) semanticObject); 
				return; 
			case FontnamePackage.POST_SCRIPT_FONT_NAME:
				sequence_PostScriptFontName(context, (PostScriptFontName) semanticObject); 
				return; 
			case FontnamePackage.STRETCH_OPTION:
				sequence_StretchOption(context, (StretchOption) semanticObject); 
				return; 
			case FontnamePackage.STYLE_OPTION:
				sequence_StyleOption(context, (StyleOption) semanticObject); 
				return; 
			case FontnamePackage.VARIANT_OPTION:
				sequence_VariantOption(context, (VariantOption) semanticObject); 
				return; 
			case FontnamePackage.WEIGHT_OPTION:
				sequence_WeightOption(context, (WeightOption) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     StyleOptionsElement returns GravityOption
	 *     GravityOption returns GravityOption
	 *
	 * Constraint:
	 *     gravity=Gravity
	 */
	protected void sequence_GravityOption(ISerializationContext context, GravityOption semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.GRAVITY_OPTION__GRAVITY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.GRAVITY_OPTION__GRAVITY));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getGravityOptionAccess().getGravityGravityParserRuleCall_0(), semanticObject.getGravity());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     FontName returns PangoFontName
	 *     PangoFontName returns PangoFontName
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             families+=PangoFamily+ 
	 *             finalFamily+=PSALIAS? 
	 *             ((finalFamily+=INT | finalFamily+=NAME | finalFamily+=StyleOptionString)? finalFamily+=PSALIAS?)* 
	 *             (finalFamily+=NAME | finalFamily+=PSALIAS)
	 *         ) | 
	 *         (
	 *             (finalFamily+=INT | finalFamily+=NAME | finalFamily+=PSALIAS | finalFamily+=StyleOptionString) 
	 *             finalFamily+=PSALIAS? 
	 *             ((finalFamily+=INT | finalFamily+=NAME | finalFamily+=StyleOptionString)? finalFamily+=PSALIAS?)* 
	 *             (finalFamily+=NAME | finalFamily+=PSALIAS)
	 *         ) | 
	 *         finalFamily+=NAME | 
	 *         (
	 *             families+=PangoFamily* 
	 *             finalFamily+=NAME? 
	 *             ((finalFamily+=INT | finalFamily+=PSALIAS | finalFamily+=StyleOptionString)? finalFamily+=NAME?)* 
	 *             (finalFamily+=INT | finalFamily+=NAME | finalFamily+=PSALIAS) 
	 *             styleOptionsList+=StyleOptionsElement* 
	 *             styleOptionsList+=StyleOptionsElement?
	 *         ) | 
	 *         (families+=PangoFamily* styleOptionsList+=StyleOptionsElement*)
	 *     )?
	 */
	protected void sequence_PangoFontName(ISerializationContext context, PangoFontName semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     FontName returns PostScriptFontName
	 *     PostScriptFontName returns PostScriptFontName
	 *
	 * Constraint:
	 *     alias=PostScriptAlias
	 */
	protected void sequence_PostScriptFontName(ISerializationContext context, PostScriptFontName semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.POST_SCRIPT_FONT_NAME__ALIAS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.POST_SCRIPT_FONT_NAME__ALIAS));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getPostScriptFontNameAccess().getAliasPostScriptAliasParserRuleCall_0(), semanticObject.getAlias());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     StyleOptionsElement returns StretchOption
	 *     StretchOption returns StretchOption
	 *
	 * Constraint:
	 *     stretch=Stretch
	 */
	protected void sequence_StretchOption(ISerializationContext context, StretchOption semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.STRETCH_OPTION__STRETCH) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.STRETCH_OPTION__STRETCH));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getStretchOptionAccess().getStretchStretchParserRuleCall_0(), semanticObject.getStretch());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     StyleOptionsElement returns StyleOption
	 *     StyleOption returns StyleOption
	 *
	 * Constraint:
	 *     style=Style
	 */
	protected void sequence_StyleOption(ISerializationContext context, StyleOption semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.STYLE_OPTION__STYLE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.STYLE_OPTION__STYLE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getStyleOptionAccess().getStyleStyleParserRuleCall_0(), semanticObject.getStyle());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     StyleOptionsElement returns VariantOption
	 *     VariantOption returns VariantOption
	 *
	 * Constraint:
	 *     variant=Variant
	 */
	protected void sequence_VariantOption(ISerializationContext context, VariantOption semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.VARIANT_OPTION__VARIANT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.VARIANT_OPTION__VARIANT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVariantOptionAccess().getVariantVariantParserRuleCall_0(), semanticObject.getVariant());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     StyleOptionsElement returns WeightOption
	 *     WeightOption returns WeightOption
	 *
	 * Constraint:
	 *     weight=Weight
	 */
	protected void sequence_WeightOption(ISerializationContext context, WeightOption semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.WEIGHT_OPTION__WEIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.WEIGHT_OPTION__WEIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getWeightOptionAccess().getWeightWeightParserRuleCall_0(), semanticObject.getWeight());
		feeder.finish();
	}
	
	
}
