/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.businessprocess.ExternalTestDataBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.progress.OperationCanceledUtil;
import org.eclipse.jubula.client.core.errorhandling.ErrorMessagePresenter;
import org.eclipse.jubula.client.core.errorhandling.IErrorMessagePresenter;
import org.eclipse.jubula.client.core.events.AutAgentEvent;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.events.IServerEventListener;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.core.progress.ProgressConsoleRegistry;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.editors.TestResultViewer;
import org.eclipse.jubula.client.ui.rcp.businessprocess.CompletenessBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ImportFileBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ProblemsBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ToolkitBP;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.TestJobEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.DirtyStarListContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.DirtyStarListLabelProvider;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractQuery;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.widgets.StatusLineContributionItem;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.JBFatalException;
import org.eclipse.jubula.tools.internal.exception.JBRuntimeException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plugin
extends AbstractUIPlugin
implements IProgressConsole {
    public static final String PLUGIN_ID = "org.eclipse.jubula.client.ui.rcp";
    public static final String TEST_STYLE_PLUGIN_ID = "org.eclipse.jubula.client.teststyle";
    public static final Map<Image, Image> GENERATED_IMAGES = new HashMap<Image, Image>();
    public static final Map<Image, Image> GRAYED_IMAGES = new HashMap<Image, Image>();
    public static final Image TC_DISABLED_IMAGE = new Image(IconConstants.TC_IMAGE.getDevice(), IconConstants.TC_IMAGE, 2);
    private static final String JB_CONSOLE_NAME = "Console";
    private static Logger log = LoggerFactory.getLogger(Plugin.class);
    private static Plugin plugin;
    private static String statusLineText;
    private static int connectionStatusIcon;
    private static IWorkbenchWindow workbenchWindow;
    private static final String CONNECTION_INFO_STATUSLINE_ITEM = "connectionInfo";
    private static final String AUT_TOOLKIT_STATUSLINE_ITEM = "autToolKitInfo";
    private static final String CONNECTION_CONSOLE_NAME = "Connection:";
    private ClientStatus m_status = ClientStatus.STARTING;
    private ScopedPreferenceStore m_preferenceStore = null;
    private MessageConsole m_console;
    private MessageConsoleStream m_standardMessageStream;
    private MessageConsoleStream m_errorMessageStream;
    private MessageConsoleStream m_warningMessageStream;
    private String m_runningApplicationTitle = null;
    private DataEventDispatcher.IDataChangedListener m_projectLifecycleLister = null;
    private IServerEventListener m_agentCloseListener = new IServerEventListener(){

        public void stateChanged(AutAgentEvent event) {
            if (event.getState() == 2) {
                ProgressConsoleRegistry.INSTANCE.getConsole().closeConsole();
            }
        }
    };

    static {
        statusLineText = Messages.StatusLine_NotConnected;
        connectionStatusIcon = 0;
        GENERATED_IMAGES.put(IconConstants.TC_IMAGE, IconConstants.getImage((String)"testCase_generated.gif"));
        GENERATED_IMAGES.put(IconConstants.TC_REF_IMAGE, IconConstants.getImage((String)"testCaseRef_generated.gif"));
        GENERATED_IMAGES.put(IconConstants.CATEGORY_IMAGE, IconConstants.getImage((String)"category_generated.gif"));
    }

    public void setClientStatus(ClientStatus statust) {
        this.m_status = statust;
    }

    public ClientStatus getClientStatus() {
        return this.m_status;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.m_projectLifecycleLister != null) {
            DataEventDispatcher.getInstance().removeDataChangedListener(this.m_projectLifecycleLister);
        }
        ProgressConsoleRegistry.INSTANCE.deregister();
        ClientTest.instance().removeAutAgentEventListener(this.m_agentCloseListener);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.m_preferenceStore == null) {
            this.m_preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.jubula.client.ui");
        }
        return this.m_preferenceStore;
    }

    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    private static void setStatusLineText(String text) {
        statusLineText = text;
        Plugin.showStatusLine(null);
    }

    public static String getStatusLineText() {
        return statusLineText;
    }

    public static void showStatusLine(final int ampel, final String text) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Plugin.setConnectionStatusIcon(ampel);
                Plugin.setStatusLineText(text);
            }
        });
    }

    public static void showStatusLine(IWorkbenchPart partFocused) {
        IWorkbench workbench = Plugin.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (Plugin.getActivePage() == null && partFocused == null) {
            return;
        }
        IWorkbenchPart part = partFocused != null ? partFocused : Plugin.getActivePart();
        StatusLineManager manager = ((WorkbenchWindow)window).getStatusLineManager();
        if (part instanceof ViewPart) {
            manager = ((ViewPart)part).getViewSite().getActionBars().getStatusLineManager();
        } else if (part instanceof EditorPart) {
            manager = ((EditorPart)part).getEditorSite().getActionBars().getStatusLineManager();
        }
        if (window instanceof WorkbenchWindow) {
            StatusLineContributionItem item = (StatusLineContributionItem)manager.find(CONNECTION_INFO_STATUSLINE_ITEM);
            if (item == null) {
                if (Plugin.getDefault().getWorkbench().getActiveWorkbenchWindow() != null) {
                    Plugin.createStatusLineItems();
                    item = (StatusLineContributionItem)manager.find(CONNECTION_INFO_STATUSLINE_ITEM);
                }
                if (item == null) {
                    return;
                }
            }
            switch (Plugin.isConnectionStatusIcon()) {
                case 0: {
                    item.setMessage(IconConstants.NO_SERVER_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 1: 
                case 2: {
                    item.setMessage(IconConstants.NO_CONNECTION_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 3: {
                    item.setMessage(IconConstants.AUT_RUNNING_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 4: {
                    item.setMessage(IconConstants.CAM_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 7: {
                    item.setMessage(IconConstants.CHECK_CAM_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 5: {
                    item.setMessage(IconConstants.MAP_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 6: {
                    item.setMessage(IconConstants.PAUSE_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                default: {
                    item.setMessage(IconConstants.NO_AUT_IMAGE, Plugin.getStatusLineText());
                }
            }
            manager.update(true);
        }
    }

    public static ViewPart getActiveView() {
        IWorkbenchPart view = Plugin.getActivePart();
        if (view instanceof ViewPart) {
            return (ViewPart)view;
        }
        return null;
    }

    public static IEditorPart getActiveEditor() {
        IEditorReference[] editorReferences;
        IWorkbenchPage activePage = Plugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart editor = activePage.getActiveEditor();
        if (editor != null) {
            return editor;
        }
        IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IJBEditor gdEd;
            IEditorReference edRef = iEditorReferenceArray[n2];
            IEditorPart editorPart = edRef.getEditor(false);
            if (editorPart instanceof IJBEditor && (gdEd = (IJBEditor)editorPart).getEditorHelper().isActive()) {
                return gdEd;
            }
            ++n2;
        }
        return null;
    }

    public static List<IEditorReference> getAllEditors() {
        if (Plugin.getActivePage() == null) {
            return new ArrayList<IEditorReference>();
        }
        IEditorReference[] editors = Plugin.getActivePage().getEditorReferences();
        ArrayList<IEditorReference> editorList = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            if (editor.getId().equals("org.eclipse.jubula.client.ui.rcp.editors.TestCaseEditor") || editor.getId().equals("org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingEditor") || editor.getId().equals("org.eclipse.jubula.client.ui.rcp.editors.TestSuiteEditor")) {
                editorList.add(editor);
            }
            ++n2;
        }
        return editorList;
    }

    public static void clearAllEditorsClipboard() {
        for (IEditorReference editorRef : Plugin.getAllEditors()) {
            IEditorPart editorPart = editorRef.getEditor(true);
            if (!(editorPart instanceof AbstractJBEditor)) continue;
            ((AbstractJBEditor)editorPart).getEditorHelper().getClipboard().clearContents();
        }
        LocalSelectionClipboardTransfer.getInstance().setSelection(null, false);
    }

    public static IWorkbenchPart getActivePart() {
        if (Plugin.getActivePage() != null) {
            return Plugin.getActivePage().getActivePart();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww == null) {
            return null;
        }
        return ww.getActivePage();
    }

    public static IViewPart getView(String id) {
        Validate.notEmpty((String)id, (String)Messages.Missing_ID);
        if (Plugin.getActivePage() != null) {
            IViewPart vp = Plugin.getActivePage().findView(id);
            return vp;
        }
        return null;
    }

    public void writeLineToConsole(String msg, boolean forceActivate) {
        if (PlatformUI.isWorkbenchRunning()) {
            MessageConsoleStream stream = this.getStandardConsoleStream();
            if (forceActivate) {
                stream.getConsole().activate();
            }
            stream.println(msg);
        }
    }

    public void writeLineToConsole(MessageConsole console, String msg, boolean forceActivate) {
        if (PlatformUI.isWorkbenchRunning()) {
            MessageConsoleStream stream = console.newMessageStream();
            if (forceActivate) {
                stream.getConsole().activate();
            }
            stream.println(msg);
        }
    }

    public void writeErrorLineToConsole(String msg, boolean forceActivate) {
        if (PlatformUI.isWorkbenchRunning()) {
            MessageConsoleStream stream = this.getErrorConsoleStream();
            if (forceActivate) {
                stream.getConsole().activate();
            }
            stream.println(msg);
        }
    }

    private synchronized MessageConsoleStream getStandardConsoleStream() {
        if (this.m_standardMessageStream == null) {
            this.m_standardMessageStream = this.getConsole().newMessageStream();
        }
        return this.m_standardMessageStream;
    }

    private synchronized MessageConsoleStream getErrorConsoleStream() {
        if (this.m_errorMessageStream == null) {
            this.m_errorMessageStream = this.getConsole().newMessageStream();
            final Display d = Plugin.getDisplay();
            final MessageConsoleStream stream = this.m_errorMessageStream;
            d.syncExec(new Runnable(){

                @Override
                public void run() {
                    stream.setColor(d.getSystemColor(3));
                }
            });
        }
        return this.m_errorMessageStream;
    }

    private synchronized MessageConsole getConsole() {
        if (this.m_console == null) {
            this.m_console = new MessageConsole(JB_CONSOLE_NAME, null);
            this.m_console.activate();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.m_console});
        }
        return this.m_console;
    }

    private synchronized MessageConsole getConsole(String name) {
        IConsole[] cons;
        IConsole[] iConsoleArray = cons = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = cons.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole c = iConsoleArray[n2];
            if (c.getName().equals(CONNECTION_CONSOLE_NAME + name) && c instanceof MessageConsole) {
                return (MessageConsole)c;
            }
            ++n2;
        }
        MessageConsole console = new MessageConsole(CONNECTION_CONSOLE_NAME + name, null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        return console;
    }

    public static IViewPart showView(String id) {
        return Plugin.showView(id, null, 1);
    }

    public static IViewPart showView(String viewID, String secondaryViewID, int mode) {
        Validate.notEmpty((String)viewID, (String)Messages.Missing_ID);
        if (Plugin.getActivePage() != null) {
            IViewPart vp = null;
            try {
                vp = Plugin.getActivePage().showView(viewID, secondaryViewID, mode);
            }
            catch (PartInitException partInitException) {
                ErrorHandlingUtil.createMessageDialog((JBException)new JBException(NLS.bind((String)(String.valueOf(Messages.PluginCantOpenView) + viewID), (Object)MessageIDs.E_CLASS_NOT_FOUND), null, null));
            }
            return vp;
        }
        return null;
    }

    public static void activate(IWorkbenchPart part) {
        if (Plugin.getActivePage() != null) {
            Plugin.getActivePage().activate(part);
        }
    }

    public static int isConnectionStatusIcon() {
        return connectionStatusIcon;
    }

    private static void setConnectionStatusIcon(int aS) {
        connectionStatusIcon = aS;
        Plugin.showStatusLine(null);
    }

    public static IEditorPart getEditorByTitle(String title) {
        IEditorReference[] editors = Plugin.getActivePage().getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            String edTitle = editors[i].getTitle();
            if (title.equals(edTitle)) {
                return (IEditorPart)editors[i].getPart(false);
            }
            ++i;
        }
        return null;
    }

    public static boolean isViewOpen(String id) {
        return Plugin.getView(id) != null;
    }

    public IEditorPart[] getDirtyEditors() {
        if (Plugin.getActivePage() != null) {
            return Plugin.getActivePage().getDirtyEditors();
        }
        return new IEditorPart[0];
    }

    public AbstractJBEditor getActiveJBEditor() {
        IWorkbenchPage activePage = Plugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart iEditorPart = Plugin.getActiveEditor();
        if (iEditorPart != null && iEditorPart instanceof AbstractJBEditor) {
            return (AbstractJBEditor)iEditorPart;
        }
        return null;
    }

    public AbstractTestCaseEditor getActiveTCEditor() {
        if (this.getActiveJBEditor() instanceof AbstractTestCaseEditor) {
            return (AbstractTestCaseEditor)this.getActiveJBEditor();
        }
        return null;
    }

    public TestJobEditor getActiveTJEditor() {
        IWorkbenchPage activePage = Plugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart iEditorPart = Plugin.getActiveEditor();
        if (iEditorPart != null && iEditorPart instanceof TestJobEditor) {
            return (TestJobEditor)iEditorPart;
        }
        return null;
    }

    public static void closeAllOpenedJubulaEditors(boolean alsoProjectIndependent) {
        IWorkbenchPage activePage = Plugin.getActivePage();
        if (activePage != null) {
            List<IEditorReference> editorParts = Plugin.getAllOpenedJubulaEditors(alsoProjectIndependent);
            activePage.closeEditors(editorParts.toArray(new IEditorReference[editorParts.size()]), false);
        }
    }

    public static Image getGeneratedImage(Image original) {
        Image genImage = GENERATED_IMAGES.get(original);
        if (genImage == null) {
            log.error("'Generated' image does not exist.");
            genImage = original;
        }
        return genImage;
    }

    public static Image getCutImage(Image original) {
        Image cutImage = GRAYED_IMAGES.get(original);
        if (cutImage == null) {
            cutImage = new Image(original.getDevice(), original, 2);
            GRAYED_IMAGES.put(original, cutImage);
        }
        return cutImage;
    }

    private static List<IEditorReference> getAllOpenedJubulaEditors(boolean alsoProjectIndependent) {
        ArrayList<IEditorReference> editorRefs = new ArrayList<IEditorReference>();
        IWorkbenchPage activePage = Plugin.getActivePage();
        if (activePage != null) {
            IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorPart editor = editorRef.getEditor(true);
                if (editor instanceof IJBPart && (alsoProjectIndependent || !(editor instanceof TestResultViewer))) {
                    editorRefs.add(editorRef);
                }
                ++n2;
            }
        }
        return editorRefs;
    }

    public static Shell getActiveWorkbenchWindowShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getShells()[0];
    }

    public boolean anyDirtyStar() {
        return !this.getProjectDependentDirtyEditors().isEmpty();
    }

    private List<IEditorReference> getProjectDependentDirtyEditors() {
        ArrayList<IEditorReference> dirtyEditors = new ArrayList<IEditorReference>();
        for (IEditorReference editorRef : Plugin.getAllOpenedJubulaEditors(false)) {
            if (!editorRef.isDirty()) continue;
            dirtyEditors.add(editorRef);
        }
        return dirtyEditors;
    }

    public boolean showSaveEditorDialog(Shell parentShell) {
        return this.showSaveEditorDialogWithMessage(Messages.SelectEditorsToSave, parentShell);
    }

    public boolean showSaveEditorDialogWithMessage(String msg, Shell parentShell) {
        boolean hasDirtyEditors;
        List<IEditorReference> dirtyEditors = this.getProjectDependentDirtyEditors();
        boolean bl = hasDirtyEditors = !dirtyEditors.isEmpty();
        if (hasDirtyEditors) {
            ListSelectionDialog dialog = new ListSelectionDialog(parentShell, (Object)dirtyEditors.toArray(), (IStructuredContentProvider)new DirtyStarListContentProvider(), (ILabelProvider)new DirtyStarListLabelProvider(), msg);
            dialog.setTitle(Messages.SaveEditorsTitle);
            dialog.setInitialElementSelections(dirtyEditors);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                Object[] editorRefs = dialog.getResult();
                if (editorRefs != null) {
                    Object[] objectArray = editorRefs;
                    int n = editorRefs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object editorObj = objectArray[n2];
                        if (editorObj instanceof IEditorReference) {
                            IEditorReference editorRef = (IEditorReference)editorObj;
                            IEditorPart editorPart = editorRef.getEditor(true);
                            editorPart.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                        ++n2;
                    }
                }
                hasDirtyEditors = !this.getProjectDependentDirtyEditors().isEmpty();
            }
        }
        Plugin.setNormalCursor();
        return !hasDirtyEditors;
    }

    private static void setWaitCursor() {
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Plugin.getActiveWorkbenchWindowShell().setCursor(Plugin.getDisplay().getSystemCursor(1));
            }
        });
    }

    private static void setNormalCursor() {
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Plugin.getActiveWorkbenchWindowShell().setCursor(Plugin.getDisplay().getSystemCursor(0));
            }
        });
    }

    public static IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }

    public Object handleError(final Throwable e) {
        Plugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (e instanceof RuntimeException && OperationCanceledUtil.isOperationCanceled((RuntimeException)((RuntimeException)e))) {
                    return;
                }
                log.error(String.valueOf(Messages.UnhandledThrowable) + " " + ":" + " ", e);
                if (e instanceof JBRuntimeException) {
                    JBRuntimeException gdEx = (JBRuntimeException)e;
                    ErrorHandlingUtil.createMessageDialog((JBRuntimeException)gdEx);
                } else if (e instanceof JBException) {
                    JBException gdEx = (JBException)e;
                    ErrorHandlingUtil.createMessageDialog((JBException)gdEx, null, null);
                } else if (Plugin.isRCPException(e)) {
                    log.error(Messages.InternalRcpError, e);
                } else if (Plugin.isGEFException(e)) {
                    log.error(Messages.InternalGefError, e);
                } else if (e instanceof PersistenceException) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_DATABASE_GENERAL, null, (String[])new String[]{e.getLocalizedMessage()});
                } else {
                    ErrorHandlingUtil.createMessageDialog((JBRuntimeException)new JBFatalException(e, MessageIDs.E_UNEXPECTED_EXCEPTION));
                }
            }
        });
        return null;
    }

    public static boolean isRCPException(Throwable t) {
        Throwable work = t;
        do {
            StackTraceElement[] stack;
            StackTraceElement[] stackTraceElementArray = stack = work.getStackTrace();
            int n = stack.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement el = stackTraceElementArray[n2];
                String className = el.getClassName();
                if (className.indexOf("MarkerAdapter") != -1) {
                    return true;
                }
                if (className.indexOf("EngineResultSection") != -1) {
                    return true;
                }
                if (className.indexOf("ContextHelpPart") != -1) {
                    return true;
                }
                if (className.indexOf("CompositeImageDescriptor") != -1) {
                    return true;
                }
                if (className.indexOf("EditorStateParticipant") != -1) {
                    return true;
                }
                if (className.indexOf("LightweightDecoratorManager") != -1) {
                    return true;
                }
                ++n2;
            }
            String detailMessage = work.getMessage();
            if (detailMessage == null || detailMessage.indexOf("WARNING: Prevented recursive attempt to activate part") == -1) continue;
            return true;
        } while ((work = work.getCause()) != null);
        return false;
    }

    public static boolean isContentAssistException(Throwable t) {
        Throwable work = t;
        do {
            StackTraceElement[] stack;
            if (!(work instanceof NullPointerException)) continue;
            StackTraceElement[] stackTraceElementArray = stack = work.getStackTrace();
            int n = stack.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement el = stackTraceElementArray[n2];
                if (Messages.RecomputeProposals.equals(el.getMethodName())) {
                    return true;
                }
                ++n2;
            }
        } while ((work = work.getCause()) != null);
        return false;
    }

    public static boolean isGEFException(Throwable t) {
        Throwable work = t;
        do {
            StackTraceElement[] stack;
            StackTraceElement[] stackTraceElementArray = stack = work.getStackTrace();
            int n = stack.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement el = stackTraceElementArray[n2];
                if (el.getClassName().indexOf("DragEditPartsTrackerEx") != -1) {
                    return true;
                }
                ++n2;
            }
        } while ((work = work.getCause()) != null);
        return false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ErrorMessagePresenter.setPresenter((IErrorMessagePresenter)new IErrorMessagePresenter(){

            public void showErrorMessage(JBException ex, Object[] params, String[] details) {
                ErrorHandlingUtil.createMessageDialog((JBException)ex, (Object[])params, (String[])details);
            }

            public void showErrorMessage(Integer messageID, Object[] params, String[] details) {
                ErrorHandlingUtil.createMessageDialog((Integer)messageID, (Object[])params, (String[])details);
            }
        });
        new IsAliveThread(new Runnable(){

            @Override
            public void run() {
                Languages.getInstance();
            }
        }).start();
        this.registerPermanentServices();
        this.m_projectLifecycleLister = new DataEventDispatcher.IDataChangedListener(){

            public void handleDataChanged(DataChangedEvent ... events) {
                DataChangedEvent[] dataChangedEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DataChangedEvent event = dataChangedEventArray[n2];
                    if (event.getPo() instanceof IProjectPO && event.getDataState() == DataEventDispatcher.DataState.Deleted) {
                        Utils.clearClient(false);
                        GeneralStorage.getInstance().nullProject();
                    }
                    ++n2;
                }
            }
        };
        DataEventDispatcher.getInstance().addDataChangedListener(this.m_projectLifecycleLister, true);
        ProgressConsoleRegistry.INSTANCE.register((IProgressConsole)this);
        ClientTest.instance().addAutAgentEventListener(this.m_agentCloseListener);
        this.parseCommandLine();
    }

    private void parseCommandLine() {
        String port;
        String[] args = Platform.getCommandLineArgs();
        String ip = EnvironmentUtils.getArgValue((String[])args, (String)"jubClientAddr");
        if (StringUtils.isNotEmpty((String)ip)) {
            System.setProperty("jubClientAddr", ip);
        }
        if (StringUtils.isNotEmpty((String)(port = EnvironmentUtils.getArgValue((String[])args, (String)"jubClientPort")))) {
            System.setProperty("jubClientPort", port);
        }
    }

    private void registerPermanentServices() {
        ProblemsBP.getInstance();
        TestExecutionContributor.getInstance();
        this.propagateDataDir();
        Plugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Plugin.this.propagateDataDir();
            }
        });
        this.registerSearchResultListener();
        ImportFileBP.getInstance();
        CompletenessBP.getInstance();
        ToolkitBP.getInstance();
        try {
            Platform.getBundle((String)TEST_STYLE_PLUGIN_ID).start();
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
    }

    public static void showAutToolKitInfo(String toolkit) {
        IStatusLineManager manager = Plugin.getStatusLineManager();
        StatusLineContributionItem item = (StatusLineContributionItem)manager.find(AUT_TOOLKIT_STATUSLINE_ITEM);
        if (item == null) {
            return;
        }
        item.setText(CompSystemI18n.getString((String)toolkit));
        manager.update(true);
    }

    public static void createStatusLineItems() {
        IStatusLineManager manager = Plugin.getStatusLineManager();
        StatusLineContributionItem connectionItem = new StatusLineContributionItem(CONNECTION_INFO_STATUSLINE_ITEM);
        manager.insertBefore("END_GROUP", (IContributionItem)connectionItem);
        StatusLineContributionItem autToolKitItem = new StatusLineContributionItem(AUT_TOOLKIT_STATUSLINE_ITEM);
        autToolKitItem.setText("");
        manager.insertBefore(CONNECTION_INFO_STATUSLINE_ITEM, (IContributionItem)autToolKitItem);
        manager.update(true);
    }

    public static IStatusLineManager getStatusLineManager() {
        IWorkbench workbench = Plugin.getDefault().getWorkbench();
        workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = Plugin.getShell();
                    while (shell != null) {
                        Object data = shell.getData();
                        if (data instanceof IWorkbenchWindow) {
                            workbenchWindow = (IWorkbenchWindow)data;
                            break;
                        }
                        shell = (Shell)shell.getParent();
                    }
                }
            });
        }
        StatusLineManager manager = ((WorkbenchWindow)workbenchWindow).getStatusLineManager();
        return manager;
    }

    public static void stopLongRunning() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Plugin.getStatusLineManager().setErrorMessage(null);
                Plugin.setNormalCursor();
            }
        });
    }

    public static void startLongRunning(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Plugin.getStatusLineManager().setErrorMessage(IconConstants.LONG_RUNNING_IMAGE, message);
                Plugin.startLongRunning();
            }
        });
    }

    public static void startLongRunning() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Plugin.setWaitCursor();
            }
        });
    }

    public static IComponentNameCache getActiveCompCache() {
        IWorkbenchPart activePart = Plugin.getActivePart();
        if (activePart instanceof IContributedContentsView) {
            activePart = ((IContributedContentsView)activePart).getContributingPart();
        }
        IComponentNameCache cache = null;
        if (activePart != null) {
            cache = (IComponentNameCache)activePart.getAdapter(IComponentNameCache.class);
        }
        if (cache != null) {
            return cache;
        }
        return CompNameManager.getInstance();
    }

    public void writeErrorLine(String line) {
        this.writeErrorLineToConsole(line, true);
    }

    public void writeWarningLine(String line) {
        this.writeWarningLineToConsole(line, true);
    }

    public void writeWarningLineToConsole(String msg, boolean forceActivate) {
        if (PlatformUI.isWorkbenchRunning()) {
            MessageConsoleStream stream = this.getWarningConsoleStream();
            if (forceActivate) {
                stream.getConsole().activate();
            }
            stream.println(msg);
        }
    }

    private synchronized MessageConsoleStream getWarningConsoleStream() {
        if (this.m_warningMessageStream == null) {
            this.m_warningMessageStream = this.getConsole().newMessageStream();
            final Display d = Plugin.getDisplay();
            final MessageConsoleStream stream = this.m_warningMessageStream;
            d.syncExec(new Runnable(){

                @Override
                public void run() {
                    stream.setColor(d.getSystemColor(8));
                }
            });
        }
        return this.m_warningMessageStream;
    }

    public void writeLine(String line) {
        this.writeLineToConsole(line, true);
    }

    public void writeStatus(IStatus status) {
        this.writeStatus(status, null);
    }

    private void printStatus(IStatus status, MessageConsole c, boolean activate) {
        ArrayList<IStatus> statuus = new ArrayList<IStatus>();
        statuus.add(status);
        if (status.isMultiStatus()) {
            statuus.addAll(Arrays.asList(status.getChildren()));
        }
        Iterator iterator = statuus.iterator();
        while (iterator.hasNext()) {
            IStatus cfr_ignored_0 = (IStatus)iterator.next();
            this.writeLineToConsole(c, StringHelper.getStringOf((IStatus)status, (boolean)false), activate);
        }
    }

    public void writeStatus(IStatus status, String id) {
        MessageConsole c = id != null ? this.getConsole(id) : this.getConsole();
        boolean activate = false;
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus s = iStatusArray[n2];
                if (!s.isOK()) {
                    activate = true;
                    break;
                }
                ++n2;
            }
        } else {
            activate = !status.isOK();
        }
        this.printStatus(status, c, activate);
    }

    public void closeConsole() {
        ConsolePlugin consolePlugin = ConsolePlugin.getDefault();
        if (consolePlugin != null && consolePlugin.getConsoleManager() != null) {
            IConsole[] cons = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            ArrayList<IConsole> toRemove = new ArrayList<IConsole>();
            IConsole[] iConsoleArray = cons;
            int n = cons.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole c = iConsoleArray[n2];
                if (c.getName().contains(CONNECTION_CONSOLE_NAME) && c instanceof MessageConsole) {
                    toRemove.add(c);
                }
                ++n2;
            }
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(toRemove.toArray(new IConsole[toRemove.size()]));
        }
    }

    public String getRunningApplicationTitle() {
        if (this.m_runningApplicationTitle == null) {
            this.m_runningApplicationTitle = Plugin.getActiveWorkbenchWindowShell().getText();
        }
        return this.m_runningApplicationTitle;
    }

    private void registerSearchResultListener() {
        NewSearchUI.addQueryListener((IQueryListener)new IQueryListener(){

            public void queryAdded(ISearchQuery query) {
            }

            public void queryFinished(final ISearchQuery query) {
                if (query instanceof AbstractQuery) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            SearchView sv = (SearchView)Plugin.getView("org.eclipse.search.ui.views.SearchView");
                            if (sv != null) {
                                sv.showSearchResult(query.getSearchResult());
                            }
                        }
                    });
                }
            }

            public void queryRemoved(ISearchQuery query) {
            }

            public void queryStarting(ISearchQuery query) {
            }
        });
    }

    private void propagateDataDir() {
        IPreferenceStore preferenceStore = Plugin.getDefault().getPreferenceStore();
        if (!preferenceStore.getBoolean("DATADIR_WS_KEY")) {
            ExternalTestDataBP.setDataDir((File)new File(preferenceStore.getString("DATADIR_PATH_KEY")));
        } else {
            ExternalTestDataBP.setDataDir((File)Platform.getLocation().toFile());
        }
    }

    public static Plugin getDefault() {
        return plugin;
    }

    public static enum ClientStatus {
        RUNNING,
        STARTING,
        STOPPING;

    }
}

