/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.filters;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.ocl.examples.eventmanager.filters.AbstractEventFilter;

public class EventTypeFilter
extends AbstractEventFilter {
    private final int eventType;

    public EventTypeFilter(int eventType, boolean negated) {
        super(negated);
        this.eventType = eventType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventTypeFilter other = (EventTypeFilter)obj;
        if (this.eventType != other.eventType) {
            return false;
        }
        return this.isNegated() == other.isNegated();
    }

    public int getEventType() {
        return this.eventType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.eventType;
        if (this.isNegated()) {
            result *= 31;
        }
        return result;
    }

    public boolean matchesFor(Notification event) {
        return event.getEventType() == this.getEventType();
    }

    public String toString() {
        switch (this.getEventType()) {
            case 0: {
                String string = "filter CREATE";
            }
            case 1: {
                String string = "filter SET";
            }
            case 2: {
                String string = "filter UNSET";
            }
            case 3: {
                String string = "filter ADD";
            }
            case 4: {
                String string = "filter REMOVE";
            }
            case 5: {
                String string = "filter ADD_MANY";
            }
            case 6: {
                String string = "filter REMOVE_MANY";
            }
            case 7: {
                String string = "filter MOVE";
            }
            case 8: {
                String string = "filter REMOVING_ADAPTER";
            }
            case 9: {
                String string = "filter RESOLVE";
            }
        }
        String result = "filter undefined";
        return String.valueOf(this.isNegated() ? "negated " : "") + result;
    }

    public EventTypeFilter clone() {
        return new EventTypeFilter(this.getEventType(), this.isNegated());
    }

    public Object getFilterCriterion() {
        return this.getEventType();
    }
}

