/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTitleAreaDialog;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.navigator.DelegatingLabelProvider;

public abstract class AbstractArraySelectionDialog
extends CustomTitleAreaDialog {
    TableViewer viewer;
    private ISelection selection;

    public AbstractArraySelectionDialog(Shell shell, String contextHelpId) {
        super(shell, contextHelpId);
    }

    protected boolean isResizable() {
        return true;
    }

    protected boolean supportsMultiSelection() {
        return false;
    }

    protected final TableViewer getViewer() {
        return this.viewer;
    }

    protected void createDialogAreaContent(Composite parent) {
        super.createDialogAreaContent(parent);
        this.setDialogTitle(this.getDialogTitle());
        this.setTitle(this.getTitle());
        this.setDefaultMessage(this.getDefaultMessage(), 0);
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        comp.setLayoutData((Object)gd);
        this.createTableAreaContent(comp);
        this.createButtonAreaContent(comp);
    }

    protected int getTableViewerStyle() {
        return (this.supportsMultiSelection() ? 2 : 4) | 0x800 | 0x100 | 0x200;
    }

    protected TableViewer createTableAreaContent(Composite parent) {
        this.viewer = new TableViewer(parent, this.getTableViewerStyle());
        final Table table = this.viewer.getTable();
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tl);
        GridData gd = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gd);
        final TableColumn column = new TableColumn(table, 16384);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                column.setWidth(Math.max(200, table.getBounds().width - table.getBorderWidth() * 2));
            }
        });
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.setLabelProvider(this.getLabelProvider());
        this.configureTableViewer(this.viewer);
        this.viewer.setInput(this.getInput());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractArraySelectionDialog.this.onDoubleClick();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractArraySelectionDialog.this.updateEnablement(AbstractArraySelectionDialog.this.viewer);
            }
        });
        this.viewer.refresh();
        this.updateSelection(this.getSelection());
        return this.viewer;
    }

    protected void onDoubleClick() {
        if (!this.viewer.getSelection().isEmpty()) {
            this.okPressed();
        }
    }

    protected abstract void updateSelection(ISelection var1);

    protected IContentProvider getContentProvider() {
        return new ArrayContentProvider();
    }

    protected IBaseLabelProvider getLabelProvider() {
        DelegatingLabelProvider labelProvider = new DelegatingLabelProvider();
        return new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelProvider);
    }

    protected void refresh() {
        ExecutorsUtil.executeInUI((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractArraySelectionDialog.this.viewer.setInput(AbstractArraySelectionDialog.this.getInput());
                AbstractArraySelectionDialog.this.viewer.refresh();
                AbstractArraySelectionDialog.this.updateEnablement(AbstractArraySelectionDialog.this.viewer);
            }
        });
    }

    protected abstract Object getInput();

    protected abstract void createButtonAreaContent(Composite var1);

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.updateEnablement(this.viewer);
        return buttonBar;
    }

    protected void updateEnablement(TableViewer viewer) {
        Assert.isNotNull((Object)viewer);
        if (viewer.getTable().getSelectionCount() == 0) {
            viewer.getTable().setSelection(0);
        }
        Button okButton = this.getButton(0);
        int selCount = viewer.getTable().getSelectionCount();
        boolean selOk = this.supportsMultiSelection() ? selCount > 0 : selCount == 1;
        SWTControlUtil.setEnabled((Control)okButton, (viewer.getTable().getItems().length > 0 && selOk ? 1 : 0) != 0);
    }

    protected void configureTableViewer(TableViewer viewer) {
        Assert.isNotNull((Object)viewer);
        viewer.setSorter((ViewerSorter)new org.eclipse.tcf.te.tcf.ui.navigator.ViewerSorter());
    }

    protected abstract String getDialogTitle();

    protected abstract String getTitle();

    protected abstract String getDefaultMessage();

    public ISelection getSelection() {
        return this.selection;
    }

    protected void okPressed() {
        this.selection = this.viewer.getSelection();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.selection = null;
        super.cancelPressed();
    }
}

