/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/language-service/src/types", ["require", "exports", "@angular/compiler", "@angular/language-service/src/symbols"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CompletionKind = exports.DirectiveKind = void 0;
    var compiler_1 = require("@angular/compiler");
    Object.defineProperty(exports, "StaticSymbol", { enumerable: true, get: function () { return compiler_1.StaticSymbol; } });
    var symbols_1 = require("@angular/language-service/src/symbols");
    Object.defineProperty(exports, "BuiltinType", { enumerable: true, get: function () { return symbols_1.BuiltinType; } });
    /**
     * The type of Angular directive. Used for QuickInfo in template.
     */
    var DirectiveKind;
    (function (DirectiveKind) {
        DirectiveKind["COMPONENT"] = "component";
        DirectiveKind["DIRECTIVE"] = "directive";
        DirectiveKind["EVENT"] = "event";
    })(DirectiveKind = exports.DirectiveKind || (exports.DirectiveKind = {}));
    /**
     * ScriptElementKind for completion.
     */
    var CompletionKind;
    (function (CompletionKind) {
        CompletionKind["ANGULAR_ELEMENT"] = "angular element";
        CompletionKind["ATTRIBUTE"] = "attribute";
        CompletionKind["COMPONENT"] = "component";
        CompletionKind["ELEMENT"] = "element";
        CompletionKind["ENTITY"] = "entity";
        CompletionKind["HTML_ATTRIBUTE"] = "html attribute";
        CompletionKind["HTML_ELEMENT"] = "html element";
        CompletionKind["KEY"] = "key";
        CompletionKind["METHOD"] = "method";
        CompletionKind["PIPE"] = "pipe";
        CompletionKind["PROPERTY"] = "property";
        CompletionKind["REFERENCE"] = "reference";
        CompletionKind["TYPE"] = "type";
        CompletionKind["VARIABLE"] = "variable";
    })(CompletionKind = exports.CompletionKind || (exports.CompletionKind = {}));
});
//# sourceMappingURL=data:application/json;base64,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