/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.ISwitchStatement;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.CaseStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class SwitchStatement
extends Statement
implements ISwitchStatement {
    public Expression expression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public CaseStatement[] cases;
    public CaseStatement defaultCase;
    public int blockStart;
    public int caseCount;
    Constant[] constants;
    public static final int CASE = 0;
    public static final int FALLTHROUGH = 1;
    public static final int ESCAPING = 2;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            UnconditionalFlowInfo mergedInfo;
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
            SwitchFlowContext switchContext = new SwitchFlowContext(flowContext, this);
            FlowInfo caseInits = FlowInfo.DEAD_END;
            int caseIndex = 0;
            if (this.statements != null) {
                boolean didAlreadyComplain = false;
                int fallThroughState = 0;
                int i = 0;
                int max = this.statements.length;
                while (i < max) {
                    Statement statement = this.statements[i];
                    if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                        this.scope.enclosingCase = this.cases[caseIndex];
                        ++caseIndex;
                        if (fallThroughState == 1 && (statement.bits & 0x20000000) == 0) {
                            this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                        }
                        caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.unconditionalInits());
                        didAlreadyComplain = false;
                        fallThroughState = 0;
                    } else if (statement == this.defaultCase) {
                        this.scope.enclosingCase = this.defaultCase;
                        if (fallThroughState == 1 && (statement.bits & 0x20000000) == 0) {
                            this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                        }
                        caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.unconditionalInits());
                        didAlreadyComplain = false;
                        fallThroughState = 0;
                    } else {
                        fallThroughState = 1;
                    }
                    if (!statement.complainIfUnreachable(caseInits, this.scope, didAlreadyComplain)) {
                        if ((caseInits = statement.analyseCode(this.scope, switchContext, caseInits)) == FlowInfo.DEAD_END) {
                            fallThroughState = 2;
                        }
                    } else {
                        didAlreadyComplain = true;
                    }
                    ++i;
                }
            }
            TypeBinding cfr_ignored_0 = this.expression.resolvedType;
            if (this.defaultCase == null) {
                flowInfo.addPotentialInitializationsFrom(((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak));
                FlowInfo flowInfo2 = flowInfo;
                return flowInfo2;
            }
            UnconditionalFlowInfo unconditionalFlowInfo = mergedInfo = ((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak);
            return unconditionalFlowInfo;
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    @Override
    public StringBuffer printStatement(int indent, StringBuffer output) {
        SwitchStatement.printIndent(indent, output).append("switch (");
        this.expression.printExpression(0, output).append(") {");
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                output.append('\n');
                if (this.statements[i] instanceof CaseStatement) {
                    this.statements[i].printStatement(indent, output);
                } else {
                    this.statements[i].printStatement(indent + 2, output);
                }
                ++i;
            }
        }
        output.append("\n");
        return SwitchStatement.printIndent(indent, output).append('}');
    }

    @Override
    public void resolve(BlockScope upperScope) {
        try {
            TypeBinding expressionType = this.expression.resolveType(upperScope);
            if (this.statements != null) {
                this.scope = upperScope;
                int length = this.statements.length;
                this.cases = new CaseStatement[length];
                this.caseCount = 0;
                this.constants = new Constant[length];
                CaseStatement[] duplicateCaseStatements = null;
                int duplicateCaseStatementsCounter = 0;
                int counter = 0;
                int i = 0;
                while (i < length) {
                    Statement statement = this.statements[i];
                    Constant constant = statement.resolveCase(this.scope, expressionType, this);
                    if (constant == Constant.NotAConstant && statement instanceof CaseStatement) {
                        CaseStatement cs = (CaseStatement)statement;
                        if (cs.constantExpression != null && cs.constantExpression.constant != null) {
                            constant = cs.constantExpression.constant;
                        }
                    }
                    if (constant != Constant.NotAConstant) {
                        Constant key = constant;
                        if (constant != null) {
                            int j = 0;
                            while (j < counter) {
                                if (this.constants[j].equals(key)) {
                                    CaseStatement currentCaseStatement = (CaseStatement)statement;
                                    if (duplicateCaseStatements == null) {
                                        this.scope.problemReporter().duplicateCase(this.cases[j]);
                                        this.scope.problemReporter().duplicateCase(currentCaseStatement);
                                        duplicateCaseStatements = new CaseStatement[length];
                                        duplicateCaseStatements[duplicateCaseStatementsCounter++] = this.cases[j];
                                        duplicateCaseStatements[duplicateCaseStatementsCounter++] = currentCaseStatement;
                                    } else {
                                        boolean found = false;
                                        int k = 2;
                                        while (k < duplicateCaseStatementsCounter) {
                                            if (duplicateCaseStatements[k] == statement) {
                                                found = true;
                                                break;
                                            }
                                            ++k;
                                        }
                                        if (!found) {
                                            this.scope.problemReporter().duplicateCase(currentCaseStatement);
                                            duplicateCaseStatements[duplicateCaseStatementsCounter++] = currentCaseStatement;
                                        }
                                    }
                                }
                                ++j;
                            }
                            this.constants[counter++] = key;
                        }
                    }
                    ++i;
                }
                if (length != counter) {
                    this.constants = new Constant[counter];
                    System.arraycopy(this.constants, 0, this.constants, 0, counter);
                }
            } else if ((this.bits & 8) != 0) {
                upperScope.problemReporter().undocumentedEmptyBlock(this.blockStart, this.sourceEnd);
            }
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            if (this.scope == null) {
                this.scope = blockScope;
            }
            this.expression.traverse(visitor, this.scope);
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                int i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 102;
    }
}

