/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.liqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.eclipse.embedcdt.core.liqp.ParseSettings;
import org.eclipse.embedcdt.core.liqp.ProtectionSettings;
import org.eclipse.embedcdt.core.liqp.RenderSettings;
import org.eclipse.embedcdt.core.liqp.TemplateContext;
import org.eclipse.embedcdt.core.liqp.filters.Filter;
import org.eclipse.embedcdt.core.liqp.nodes.LNode;
import org.eclipse.embedcdt.core.liqp.nodes.LiquidWalker;
import org.eclipse.embedcdt.core.liqp.parser.Flavor;
import org.eclipse.embedcdt.core.liqp.parser.LiquidLexer;
import org.eclipse.embedcdt.core.liqp.parser.LiquidParser;
import org.eclipse.embedcdt.core.liqp.tags.Tag;

public class Template {
    private final CommonTree root;
    private final Map<String, Tag> tags;
    private final Map<String, Filter> filters;
    private final long templateSize;
    private ProtectionSettings protectionSettings = new ProtectionSettings.Builder().build();
    private RenderSettings renderSettings = new RenderSettings.Builder().build();
    private final ParseSettings parseSettings;

    private Template(String input, Map<String, Tag> tags, Map<String, Filter> filters, ParseSettings settings) {
        this.tags = tags;
        this.filters = filters;
        this.parseSettings = settings;
        ANTLRStringStream stream = new ANTLRStringStream(input);
        this.templateSize = stream.size();
        LiquidLexer lexer = new LiquidLexer(this.parseSettings.stripSpacesAroundTags, (CharStream)stream);
        LiquidParser parser = new LiquidParser(this.parseSettings.flavor, (TokenStream)new CommonTokenStream((TokenSource)lexer));
        try {
            this.root = parser.parse().getTree();
        }
        catch (RecognitionException e) {
            throw new RuntimeException("could not parse input: " + input, e);
        }
    }

    private Template(File file, Map<String, Tag> tags, Map<String, Filter> filters, ParseSettings parseSettings) throws IOException {
        this.tags = tags;
        this.filters = filters;
        this.parseSettings = parseSettings;
        try {
            ANTLRFileStream stream = new ANTLRFileStream(file.getAbsolutePath());
            this.templateSize = stream.size();
            LiquidLexer lexer = new LiquidLexer(parseSettings.stripSpacesAroundTags, (CharStream)stream);
            LiquidParser parser = new LiquidParser(parseSettings.flavor, (TokenStream)new CommonTokenStream((TokenSource)lexer));
            this.root = parser.parse().getTree();
        }
        catch (RecognitionException e) {
            throw new RuntimeException("could not parse input from " + file, e);
        }
    }

    public CommonTree getAST() {
        return this.root;
    }

    public static Template parse(String input) {
        return new Template(input, Tag.getTags(), Filter.getFilters(), new ParseSettings.Builder().build());
    }

    public static Template parse(File file) throws IOException {
        return new Template(file, Tag.getTags(), Filter.getFilters(), new ParseSettings.Builder().build());
    }

    public static Template parse(File file, ParseSettings settings) throws IOException {
        return new Template(file, Tag.getTags(), Filter.getFilters(), settings);
    }

    public static Template parse(String input, ParseSettings settings) {
        return new Template(input, Tag.getTags(), Filter.getFilters(), settings);
    }

    @Deprecated
    public static Template parse(File file, Flavor flavor) throws IOException {
        ParseSettings settings = new ParseSettings.Builder().withFlavor(flavor).build();
        return Template.parse(file, settings);
    }

    @Deprecated
    public static Template parse(String input, Flavor flavor) throws IOException {
        ParseSettings settings = new ParseSettings.Builder().withFlavor(flavor).build();
        return Template.parse(input, settings);
    }

    public Template with(Tag tag) {
        this.tags.put(tag.name, tag);
        return this;
    }

    public Template with(Filter filter) {
        this.filters.put(filter.name, filter);
        return this;
    }

    public Template withProtectionSettings(ProtectionSettings protectionSettings) {
        this.protectionSettings = protectionSettings;
        return this;
    }

    public Template withRenderSettings(RenderSettings renderSettings) {
        this.renderSettings = renderSettings;
        return this;
    }

    public String render(String jsonMap) {
        Map map;
        try {
            map = (Map)new ObjectMapper().readValue(jsonMap, HashMap.class);
        }
        catch (Exception e) {
            throw new RuntimeException("invalid json map: '" + jsonMap + "'", e);
        }
        return this.render(map);
    }

    public String render() {
        return this.render(new HashMap<String, Object>());
    }

    public String render(Object key, Object value, Object ... keyValues) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.putStringKey(key, value, map);
        int i = 0;
        while (i < keyValues.length - 1) {
            key = String.valueOf(keyValues[i]);
            value = keyValues[i + 1];
            this.putStringKey(key, value, map);
            i += 2;
        }
        return this.render(map);
    }

    public String render(final Map<String, Object> variables) {
        if (this.templateSize > this.protectionSettings.maxTemplateSizeBytes) {
            throw new RuntimeException("template exceeds " + this.protectionSettings.maxTemplateSizeBytes + " bytes");
        }
        final LiquidWalker walker = new LiquidWalker((TreeNodeStream)new CommonTreeNodeStream((Object)this.root), this.tags, this.filters, this.parseSettings.flavor);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    LNode node = walker.walk();
                    Object rendered = node.render(new TemplateContext(Template.this.protectionSettings, Template.this.renderSettings, Template.this.parseSettings.flavor, variables));
                    return rendered == null ? "" : String.valueOf(rendered);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Future<String> future = executorService.submit(task);
        try {
            String string = future.get(this.protectionSettings.maxRenderTimeMillis, TimeUnit.MILLISECONDS);
            return string;
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException("exceeded the max amount of time (" + this.protectionSettings.maxRenderTimeMillis + " ms.)");
        }
        catch (Throwable t) {
            throw new RuntimeException("Oops, something unexpected happened: ", t);
        }
        finally {
            executorService.shutdown();
        }
    }

    public String toStringAST() {
        StringBuilder builder = new StringBuilder();
        this.walk(this.root, builder);
        return builder.toString();
    }

    private void walk(CommonTree tree, StringBuilder builder) {
        ArrayList<CommonTree> firstStack = new ArrayList<CommonTree>();
        firstStack.add(tree);
        ArrayList childListStack = new ArrayList();
        childListStack.add(firstStack);
        while (!childListStack.isEmpty()) {
            List childStack = (List)childListStack.get(childListStack.size() - 1);
            if (childStack.isEmpty()) {
                childListStack.remove(childListStack.size() - 1);
                continue;
            }
            tree = (CommonTree)childStack.remove(0);
            String indent = "";
            int i = 0;
            while (i < childListStack.size() - 1) {
                indent = String.valueOf(indent) + (((List)childListStack.get(i)).size() > 0 ? "|  " : "   ");
                ++i;
            }
            String tokenName = LiquidParser.tokenNames[tree.getType()];
            String tokenText = tree.getText().replaceAll("\\s+", " ").trim();
            builder.append(indent).append(childStack.isEmpty() ? "'- " : "|- ").append(tokenName).append(!tokenName.equals(tokenText) ? "='" + tokenText + "'" : "").append("\n");
            if (tree.getChildCount() <= 0) continue;
            childListStack.add(new ArrayList(tree.getChildren()));
        }
    }

    private void putStringKey(Object key, Object value, Map<String, Object> map) {
        if (key == null || key.getClass() != String.class) {
            throw new RuntimeException("invalid key: " + key);
        }
        map.put((String)key, value);
    }
}

