/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.internal.FacetedProjectFrameworkJavaPlugin;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderActionType;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperation;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LibraryProviderFrameworkImpl;
import org.eclipse.jst.common.project.facet.core.libprov.internal.PropertiesHost;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.util.internal.ProgressMonitorUtil;

public final class LibraryUninstallDelegate
extends PropertiesHost {
    private final IFacetedProjectBase fproj;
    private IProjectFacetVersion fv;
    private ILibraryProvider oldProvider = null;
    private LibraryProviderOperationConfig oldProviderUninstallOpConfig = null;

    public LibraryUninstallDelegate(IFacetedProjectBase fproj, IProjectFacetVersion fv) {
        this.fproj = fproj;
        this.fv = fv;
        this.oldProvider = LibraryProviderFramework.getCurrentProvider(fproj.getProject(), fv.getProjectFacet());
        if (this.oldProvider == null) {
            this.oldProviderUninstallOpConfig = null;
        } else {
            LibraryProvider prov = (LibraryProvider)this.oldProvider;
            this.oldProviderUninstallOpConfig = prov.createOperationConfig(fproj, fv, LibraryProviderActionType.UNINSTALL);
            this.oldProviderUninstallOpConfig.addListener(new IPropertyChangeListener(){

                public void propertyChanged(String property, Object oldValue, Object newValue) {
                    LibraryUninstallDelegate.this.notifyListeners(property, oldValue, newValue);
                }
            }, new String[0]);
        }
    }

    public IFacetedProjectBase getFacetedProject() {
        return this.fproj;
    }

    public IProjectFacet getProjectFacet() {
        return this.fv.getProjectFacet();
    }

    public IProjectFacetVersion getProjectFacetVersion() {
        return this.fv;
    }

    public ILibraryProvider getLibraryProvider() {
        return this.oldProvider;
    }

    public LibraryProviderOperationConfig getUninstallOperationConfig() {
        return this.oldProviderUninstallOpConfig;
    }

    public IStatus validate() {
        IStatus st = Status.OK_STATUS;
        st = this.oldProviderUninstallOpConfig.validate();
        return st;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)10);
        try {
            IFacetedProjectBase fproj = this.getFacetedProject();
            IProjectFacetVersion fv = this.getProjectFacetVersion();
            LibraryProvider provider = (LibraryProvider)this.getLibraryProvider();
            LibraryProviderOperation libraryUninstallOp = provider.createOperation(LibraryProviderActionType.UNINSTALL);
            LibraryProviderOperationConfig libraryUninstallOpConfig = this.getUninstallOperationConfig();
            libraryUninstallOp.execute(libraryUninstallOpConfig, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)9));
            LibraryProviderFrameworkImpl.get().setCurrentProvider(fproj.getProject(), fv.getProjectFacet(), null);
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    public void dispose() {
        try {
            this.oldProviderUninstallOpConfig.dispose();
        }
        catch (Exception e) {
            FacetedProjectFrameworkJavaPlugin.log(e);
        }
    }
}

