/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester.adapter;

import java.util.Dictionary;
import javax.swing.JLabel;
import javax.swing.JSlider;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ISliderComponent;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.swing.tester.adapter.JComponentAdapter;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class JSliderAdapter
extends JComponentAdapter
implements ISliderComponent {
    private JSlider m_slider;

    public JSliderAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_slider = (JSlider)objectToAdapt;
    }

    public String getPosition(final String units) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getPosition", (IRunnable)new IRunnable<String>(){

            public String run() {
                double value;
                int absValue = JSliderAdapter.this.m_slider.getValue();
                if (units.equalsIgnoreCase(ValueSets.Measure.percent.rcValue())) {
                    value = 100 * absValue / (JSliderAdapter.this.m_slider.getMaximum() - JSliderAdapter.this.m_slider.getMinimum());
                } else {
                    Object obj;
                    Dictionary labelFormatter = JSliderAdapter.this.m_slider.getLabelTable();
                    if (labelFormatter != null && (obj = labelFormatter.get(absValue)) != null && obj instanceof JLabel) {
                        return ((JLabel)obj).getText();
                    }
                    value = absValue;
                }
                return String.valueOf(value);
            }
        });
    }

    public void setPosition(final String position, final String operator, final String units) {
        this.getEventThreadQueuer().invokeAndWait("setPosition", (IRunnable)new IRunnable<Void>(){

            public Void run() {
                if (!JSliderAdapter.this.m_slider.isEnabled()) {
                    throw new StepExecutionException("The slider is not enabled", EventFactory.createActionError((String)"The slider is not enabled"));
                }
                Integer value = null;
                Dictionary labelTable = JSliderAdapter.this.m_slider.getLabelTable();
                String prefPos = JSliderAdapter.this.getPreferredPosition(position, units);
                String possiblePos = JSliderAdapter.this.getPossiblePosition(prefPos);
                int min = JSliderAdapter.this.m_slider.getMinimum();
                int max = JSliderAdapter.this.m_slider.getMaximum();
                int incr = JSliderAdapter.this.getSliderIncrement();
                MatchUtil matcher = MatchUtil.getInstance();
                int val = min;
                while (val <= max) {
                    Object label;
                    if (labelTable != null && (label = labelTable.get(val)) != null && label instanceof JLabel && matcher.match(((JLabel)label).getText(), possiblePos, operator)) {
                        value = val;
                        break;
                    }
                    if (matcher.match(String.valueOf(val), possiblePos, operator)) {
                        value = val;
                        break;
                    }
                    val += incr;
                }
                if (value == null) {
                    throw new StepExecutionException("Value not found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                }
                JSliderAdapter.this.m_slider.setValue(value);
                return null;
            }
        });
    }

    private int getSliderIncrement() {
        int minorTickSpacing;
        int incr = this.m_slider.getSnapToTicks() ? ((minorTickSpacing = this.m_slider.getMinorTickSpacing()) != 0 ? minorTickSpacing : this.m_slider.getMajorTickSpacing()) : 1;
        return incr;
    }

    private String getPossiblePosition(String prefPos) {
        try {
            int valueToSet;
            Integer pos = Integer.valueOf(prefPos);
            if (this.m_slider.getSnapToTicks()) {
                int val = this.m_slider.getMinimum();
                int minorTickSpacing = this.m_slider.getMinorTickSpacing();
                int incr = minorTickSpacing > 0 ? minorTickSpacing : this.m_slider.getMajorTickSpacing();
                while (val < pos) {
                    val += incr;
                }
                valueToSet = val - pos <= pos - (val - incr) ? val : val - incr;
            } else {
                valueToSet = pos;
            }
            return String.valueOf(valueToSet);
        }
        catch (NumberFormatException numberFormatException) {
            return prefPos;
        }
    }

    private String getPreferredPosition(String position, String units) {
        String returnVal = position;
        if (ValueSets.Measure.percent.rcValue().equals(units)) {
            try {
                Double pos = Double.valueOf(position);
                if (pos < 0.0 || 100.0 < pos) {
                    this.throwInvalidInputMessage();
                }
                returnVal = String.valueOf(Math.round((double)this.m_slider.getMinimum() + pos * 0.01 * (double)(this.m_slider.getMaximum() - this.m_slider.getMinimum())));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return returnVal;
    }

    private void throwInvalidInputMessage() {
        throw new StepExecutionException("Invalid input for slider", EventFactory.createActionError((String)"TestErrorEvent.InvalidInput"));
    }
}

