/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.describer.HprofContentDescriber;
import org.eclipse.mat.hprof.describer.Version;
import org.eclipse.mat.hprof.ui.HprofPreferences;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.IStackFrame;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SilentProgressListener;

@CommandName(value="export_hprof")
@Icon(value="/icons/export_hprof.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/exportdump.html")
public class ExportHprof
implements IQuery {
    private static final int UNKNOWN_STACK_TRACE_SERIAL = 1;
    private static final int UNKNOWN_STACK_FRAME_SERIAL = -1;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    @Argument
    public ISnapshot snapshot;
    @Argument(advice=Argument.Advice.SAVE)
    public File output;
    @Argument(isMandatory=false)
    public boolean compress;
    @Argument(isMandatory=false)
    public RedactType redact = RedactType.NONE;
    @Argument(isMandatory=false, advice=Argument.Advice.SAVE, flag="map")
    public File mapFile;
    @Argument(isMandatory=false, advice=Argument.Advice.CLASS_NAME_PATTERN, flag="skip")
    public Pattern skipPattern = Pattern.compile("java\\..*|boolean|byte|char|short|int|long|float|double|void");
    @Argument(isMandatory=false, advice=Argument.Advice.CLASS_NAME_PATTERN, flag="avoid")
    public Pattern avoidPattern = Pattern.compile(Messages.ExportHprof_AvoidExample);
    @Argument(isMandatory=false)
    public boolean undo;
    @Argument(flag="none", isMandatory=false)
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false, flag="classInstance")
    public boolean classesAsInstances = false;
    @Argument(isMandatory=false)
    public long segsize = 0xFFFFFFFFL;
    HashMap<String, Integer> stringToID = new HashMap();
    int nextStringID = 1;
    HashMap<Integer, Integer> threadToSerial = new HashMap();
    HashMap<Integer, Integer> threadToStack = new HashMap();
    BitField include;
    int totalClasses;
    int totalObjects;
    int totalRoots;
    int totalClassloaders;
    long totalBytes;
    SetInt classloaders = new SetInt();
    int idsize = 8;
    private static final int WORK_OBJECT = 3;
    private final boolean NEWCLASSSIZE = HprofPreferences.useAdditionalClassReferences();
    Remap remap;

    public IResult execute(IProgressListener listener) throws Exception {
        long startTime;
        int ct = this.snapshot.getSnapshotInfo().getNumberOfClasses();
        int ct2 = this.initObjs();
        if (ct2 <= 0) {
            ct2 = ct;
        }
        int totalWork = 3 * ct + 6 * ct2;
        listener.beginTask(MessageUtil.format((String)Messages.ExportHprof_ExportTo, (Object[])new Object[]{this.output.getName()}), totalWork);
        this.remap = new Remap(this.skipPattern, this.avoidPattern, this.redact == RedactType.NAMES, this.undo || this.mapFile == null);
        this.remap.loadMapping(this.mapFile, this.undo);
        FilterOutputStream outstream = new BufferedOutputStream(new FileOutputStream(this.output), 65536);
        if (this.compress) {
            outstream = new GZIPOutputStream(outstream);
        }
        try (DataOutputStream3 os = new DataOutputStream3(outstream);){
            os.writeBytes(String.valueOf(Version.JDK6.getLabel()) + "\u0000");
            this.idsize = this.snapshot.getSnapshotInfo().getIdentifierSize();
            os.writeInt(this.idsize);
            startTime = System.currentTimeMillis();
            os.writeLong(startTime);
            DataOutputStream3 os2 = new DataOutputStream3(new NullStream());
            this.loadClasses(os, os2, startTime, listener);
            int firstId = this.nextStringID;
            long mark1 = os2.size();
            listener.subTask(Messages.ExportHprof_PrepareClasses);
            this.dumpClasses(os2, listener);
            listener.subTask(Messages.ExportHprof_PrepareGCRoots);
            this.gcRoots(os2);
            this.dumpThreadRoots(os2);
            long mark2 = os2.size();
            long sizeseg1 = mark2 - mark1;
            listener.subTask(Messages.ExportHprof_PrepareThreadStacks);
            this.dumpThreadStacks(os2, startTime);
            listener.subTask(Messages.ExportHprof_DumpStrings);
            for (Map.Entry<String, Integer> e : this.stringToID.entrySet()) {
                String ss = e.getKey();
                int id = e.getValue();
                if (id < firstId) continue;
                this.writeStringUTF(os, os2, startTime, ss, id);
            }
            listener.subTask(Messages.ExportHprof_DumpThreadStacks);
            this.dumpThreadStacks(os, startTime);
            int segnum = 1;
            long seg1Start = os.size();
            os.writeByte(28);
            os.writeInt((int)(System.currentTimeMillis() - startTime));
            os.writeInt((int)sizeseg1);
            long markseg1a = os.size();
            listener.subTask(MessageUtil.format((String)Messages.ExportHprof_DumpClasses, (Object[])new Object[]{segnum}));
            this.dumpClasses(os, listener);
            listener.subTask(MessageUtil.format((String)Messages.ExportHprof_DumpGCRoots, (Object[])new Object[]{segnum}));
            this.gcRoots(os);
            this.dumpThreadRoots(os);
            long markseg1b = os.size();
            long sizeseg1_a = markseg1b - markseg1a;
            if (sizeseg1_a != sizeseg1) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.ExportHprof_SegmentSizeMismatch, (Object[])new Object[]{segnum, sizeseg1, sizeseg1_a, Long.toHexString(seg1Start)}), null);
            }
            int maxObjects = Integer.MAX_VALUE;
            int st = 0;
            do {
                os2 = new DataOutputStream3(new NullStream());
                DataOutputStream3 os3 = new DataOutputStream3(new NullStream());
                long m1 = os2.size();
                listener.subTask(MessageUtil.format((String)Messages.ExportHprof_PrepareObjects, (Object[])new Object[]{++segnum}));
                int end = this.dumpObjects(os2, os3, st, maxObjects, true, listener);
                long m2 = os2.size();
                long s2 = m2 - m1;
                os3.close();
                long sizel = s2;
                long segStart = os.size();
                if (sizel > 0xFFFFFFFFL || sizel > this.segsize) {
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.ExportHprof_SegmentTooLong, (Object[])new Object[]{segnum, Long.toHexString(segStart), sizel}), null);
                }
                os.writeByte(28);
                os.writeInt((int)(System.currentTimeMillis() - startTime));
                os.writeInt((int)sizel);
                long checkmark1 = os.size();
                listener.subTask(MessageUtil.format((String)Messages.ExportHprof_DumpObjects, (Object[])new Object[]{segnum}));
                st = this.dumpObjects(os, os2, st, end, false, listener);
                long checkmark2 = os.size();
                long size2 = checkmark2 - checkmark1;
                if (size2 == sizel) continue;
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.ExportHprof_SegmentSizeMismatch, (Object[])new Object[]{segnum, sizel, size2, Long.toHexString(segStart)}), null);
            } while (st > 0 && st < maxObjects);
            os.writeByte(44);
            os.writeInt((int)(System.currentTimeMillis() - startTime));
            os.writeInt(0);
            os2.close();
        }
        String comments = MessageUtil.format((String)Messages.ExportHprof_RemapProperties, (Object[])new Object[]{this.output.getName(), new File(this.snapshot.getSnapshotInfo().getPath()).getName()});
        this.remap.saveMapping(this.mapFile, this.undo, comments);
        listener.done();
        int nclasses = this.totalClasses >>> 1;
        int nobjects = this.totalObjects >>> 1;
        int nroots = this.totalRoots >>> 1;
        int nclassloaders = this.totalClassloaders >>> 1;
        long nused = this.totalBytes >>> 1;
        SnapshotQuery sq = SnapshotQuery.lookup((String)"heap_dump_overview", (ISnapshot)this.snapshot);
        String name = this.output.getName();
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            name = name.substring(0, dot);
        }
        String prefix = new File(this.output.getParentFile(), name).getPath();
        SnapshotInfo si = new SnapshotInfo(this.output.getAbsolutePath(), prefix, null, this.idsize, new Date(startTime), nobjects, nroots, nclasses, nclassloaders, nused);
        String format = new HprofContentDescriber().getSupportedOptions()[0].getLocalName();
        si.setProperty("$heapFormat", (Serializable)((Object)format));
        if (Boolean.TRUE.equals(this.snapshot.getSnapshotInfo().getProperty("$useCompressedOops"))) {
            si.setProperty("$useCompressedOops", (Serializable)Boolean.valueOf(true));
        }
        sq.setArgument("info", (Object)si);
        IResult ret = sq.execute((IProgressListener)new SilentProgressListener(listener));
        return ret;
    }

    boolean includeObject(int obj) {
        return this.include == null || this.include.get(obj);
    }

    int initObjs() {
        int n = 0;
        if (this.objects != null) {
            this.include = new BitField(this.snapshot.getSnapshotInfo().getNumberOfObjects());
            for (int[] ia : this.objects) {
                ++n;
                int[] nArray = ia;
                int n2 = ia.length;
                int n3 = 0;
                while (n3 < n2) {
                    int i = nArray[n3];
                    this.include.set(i);
                    ++n3;
                }
            }
        }
        return n;
    }

    private int dummyStackTrace(DataOutput os, int dummyThread, long startTime) throws IOException {
        os.writeByte(5);
        os.writeInt((int)(System.currentTimeMillis() - startTime));
        os.writeInt(12);
        os.writeInt(1);
        os.writeInt(dummyThread);
        os.writeInt(0);
        return 1;
    }

    private void gcRoots(DataOutput os) throws SnapshotException, IOException {
        int nextThreadSerial = 1;
        ++nextThreadSerial;
        int[] nArray = this.snapshot.getGCRoots();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            int roots = 0;
            if (this.includeObject(i)) {
                GCRootInfo[] gi;
                GCRootInfo[] gCRootInfoArray = gi = this.snapshot.getGCRootInfo(i);
                int n3 = gi.length;
                int n4 = 0;
                while (n4 < n3) {
                    GCRootInfo gri = gCRootInfoArray[n4];
                    switch (gri.getType()) {
                        case 32: {
                            int tp = 7;
                            os.writeByte(tp);
                            this.writeID(os, gri.getObjectAddress());
                            ++roots;
                            break;
                        }
                        case 256: {
                            int tp = 8;
                            os.writeByte(tp);
                            this.writeID(os, gri.getObjectAddress());
                            os.writeInt(nextThreadSerial);
                            this.threadToSerial.put(gri.getObjectId(), nextThreadSerial);
                            ++nextThreadSerial;
                            Integer stackserial = this.threadToStack.get(gri.getObjectId());
                            if (stackserial == null) {
                                stackserial = 1;
                            }
                            os.writeInt(stackserial);
                            ++roots;
                            break;
                        }
                        case 64: {
                            long contextAddr = gri.getContextAddress();
                            if (contextAddr != 0L) break;
                            int tp = 3;
                            os.writeByte(tp);
                            this.writeID(os, gri.getObjectAddress());
                            os.writeInt(0);
                            os.writeInt(-1);
                            ++roots;
                            break;
                        }
                        case 4: 
                        case 8: 
                        case 128: {
                            long contextAddr = gri.getContextAddress();
                            if (contextAddr != 0L && contextAddr != gri.getObjectAddress()) break;
                            int tp = 1;
                            os.writeByte(tp);
                            this.writeID(os, gri.getObjectAddress());
                            this.writeID(os, 0L);
                            ++roots;
                            break;
                        }
                        case 2: {
                            int tp = 5;
                            os.writeByte(tp);
                            this.writeID(os, gri.getObjectAddress());
                            ++roots;
                            break;
                        }
                        case 16: {
                            long contextAddr = gri.getContextAddress();
                            if (contextAddr != 0L) break;
                            int tp = 6;
                            os.writeByte(tp);
                            this.writeID(os, gri.getObjectAddress());
                            os.writeInt(0);
                            ++roots;
                            break;
                        }
                        default: {
                            int tp = 255;
                            os.writeByte(tp);
                            this.writeID(os, gri.getObjectAddress());
                            ++roots;
                        }
                    }
                    ++n4;
                }
                if (roots > 0) {
                    ++this.totalRoots;
                }
            }
            ++n2;
        }
    }

    private void dumpThreadStacks(DataOutput os, long startTime) throws SnapshotException, IOException {
        this.dummyStackTrace(os, 1, 1L);
        int frameid = 1;
        int serialid = 2;
        int[] nArray = this.snapshot.getGCRoots();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (this.includeObject(i)) {
                GCRootInfo[] gCRootInfoArray = this.snapshot.getGCRootInfo(i);
                int n3 = gCRootInfoArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IThreadStack its;
                    GCRootInfo gr = gCRootInfoArray[n4];
                    if (gr.getType() == 256 && (its = this.snapshot.getThreadStack(i)) != null) {
                        int firstframeid = frameid;
                        IStackFrame[] iStackFrameArray = its.getStackFrames();
                        int n5 = iStackFrameArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            int clsid;
                            IStackFrame isf = iStackFrameArray[n6];
                            String frametext = isf.getText();
                            Frame f = Frame.parse(frametext);
                            String classname = f.clazz;
                            String method = f.method;
                            String sig = f.signature;
                            String sourcefile = f.sourceFile;
                            method = this.remap.renameMethodName(classname, method, false);
                            sig = this.remap.renameSignature(sig);
                            sourcefile = this.remap.renameFileName(classname, sourcefile);
                            int linenum = f.lineNumber;
                            Collection cls = this.snapshot.getClassesByName(classname, false);
                            if (cls == null || cls.isEmpty()) {
                                clsid = 0;
                            } else {
                                IClass cls1 = (IClass)cls.iterator().next();
                                clsid = cls1.getObjectId();
                            }
                            os.writeByte(4);
                            os.writeInt((int)(System.currentTimeMillis() - startTime));
                            os.writeInt(4 * this.idsize + 8);
                            this.writeID(os, frameid);
                            this.writeString(os, method);
                            this.writeString(os, sig);
                            this.writeString(os, sourcefile);
                            os.writeInt(clsid);
                            os.writeInt(linenum);
                            ++frameid;
                            ++n6;
                        }
                        os.writeByte(5);
                        os.writeInt((int)(System.currentTimeMillis() - startTime));
                        os.writeInt(12 + (frameid - firstframeid) * this.idsize);
                        os.writeInt(serialid);
                        Integer prev = this.threadToStack.put(i, serialid);
                        ++serialid;
                        os.writeInt(this.threadToSerial.get(i));
                        os.writeInt(frameid - firstframeid);
                        int j = firstframeid;
                        while (j < frameid) {
                            this.writeID(os, j);
                            ++j;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void loadClassBody(DataOutput os, long startTime, IClass cls) throws IOException {
        os.writeInt(cls.getObjectId());
        this.writeID(os, cls.getObjectAddress());
        os.writeInt(1);
        String classname = cls.getName();
        classname = this.remap.renameClassName(classname);
        this.writeString(os, classname);
    }

    private void loadClass(DataOutput os, DataOutputStream3 os2, long startTime, IClass cls) throws IOException {
        int str = this.nextStringID;
        long mark = os2.size();
        this.loadClassBody(os2, startTime, cls);
        long end = os2.size();
        if (this.nextStringID != str) {
            String classname = cls.getName();
            classname = this.remap.renameClassName(classname);
            this.writeStringUTF(os, os2, startTime, classname, str);
        }
        this.loadClass(os, cls, startTime, (int)(end - mark));
    }

    private void loadClasses(DataOutput os, DataOutputStream3 os2, long startTime, IProgressListener listener) throws IOException, SnapshotException {
        for (IClass cls : this.snapshot.getClasses()) {
            if (this.includeObject(cls.getObjectId())) {
                this.loadClass(os, os2, startTime, cls);
            }
            listener.worked(1);
            if (!listener.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    private void writeStringUTF(DataOutput os, DataOutputStream3 os2, long startTime, String ss, int id) throws IOException {
        os.writeByte(1);
        os.writeInt((int)(System.currentTimeMillis() - startTime));
        long mark = os2.size();
        this.writeID(os2, id);
        byte[] utf = ss.getBytes(UTF8);
        os2.write(utf);
        long reclen = os2.size() - mark;
        os.writeInt((int)reclen);
        this.writeID(os, id);
        os.write(utf);
    }

    private void dumpClasses(DataOutput os, IProgressListener listener) throws IOException, SnapshotException {
        for (IClass cls : this.snapshot.getClasses()) {
            if (this.includeObject(cls.getObjectId())) {
                this.dumpClass(os, cls);
                ++this.totalClasses;
            }
            listener.worked(1);
            if (!listener.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        Collection loaders = this.snapshot.getClassesByName("java.lang.ClassLoader", true);
        if (loaders != null) {
            for (IClass cls : loaders) {
                int[] nArray = cls.getObjectIds();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    this.classloaders.add(i);
                    ++n2;
                }
            }
        }
    }

    private void loadClass(DataOutput os, IClass cls, long startTime, int len) throws IOException {
        os.writeByte(2);
        os.writeInt((int)(System.currentTimeMillis() - startTime));
        os.writeInt(len);
        this.loadClassBody(os, startTime, cls);
    }

    private void dumpClass(DataOutput os, IClass cls) throws IOException {
        os.writeByte(32);
        this.writeID(os, cls.getObjectAddress());
        os.writeInt(1);
        IClass sup = cls.getSuperClass();
        this.writeID(os, sup != null ? sup.getObjectAddress() : 0L);
        this.writeID(os, cls.getClassLoaderAddress());
        this.classloaders.add(cls.getClassLoaderId());
        List statics = cls.getStaticFields();
        boolean[] skip = new boolean[statics.size()];
        long signersId = 0L;
        long protectionDomainId = 0L;
        long reserved1Id = 0L;
        long reserved2Id = 0L;
        int skipfields = 0;
        int cpsize = 0;
        Pattern cpName = Pattern.compile("constant pool\\[(\\d+)\\]");
        int idx = 0;
        for (Field fld : statics) {
            String fieldName = fld.getName();
            if (this.NEWCLASSSIZE && cpName.matcher(fieldName).matches()) {
                ++cpsize;
                ++skipfields;
                skip[idx] = true;
            }
            if (this.NEWCLASSSIZE && fld.getType() == 2) {
                if (fieldName.equals("<signers>")) {
                    ++skipfields;
                    skip[idx] = true;
                    if (fld.getValue() instanceof IObject) {
                        signersId = ((IObject)fld.getValue()).getObjectAddress();
                    }
                }
                if (fieldName.equals("<protectionDomain>")) {
                    ++skipfields;
                    skip[idx] = true;
                    if (fld.getValue() instanceof IObject) {
                        protectionDomainId = ((IObject)fld.getValue()).getObjectAddress();
                    }
                }
                if (fieldName.equals("<reserved1>")) {
                    ++skipfields;
                    skip[idx] = true;
                    if (fld.getValue() instanceof IObject) {
                        reserved1Id = ((IObject)fld.getValue()).getObjectAddress();
                    }
                }
                if (fieldName.equals("<reserved2>")) {
                    ++skipfields;
                    skip[idx] = true;
                    if (fld.getValue() instanceof IObject) {
                        reserved2Id = ((IObject)fld.getValue()).getObjectAddress();
                    }
                }
            }
            ++idx;
        }
        if (this.classesAsInstances) {
            IClass cls1 = cls.getClazz();
            while (cls1 != null) {
                block13: for (FieldDescriptor fd : cls1.getFieldDescriptors()) {
                    int idx2 = 0;
                    for (Field fld : cls.getStaticFields()) {
                        if (!skip[idx2] && fd.getType() == fld.getType() && fld.getName().equals("<" + fd.getName() + ">")) {
                            ++skipfields;
                            skip[idx2] = true;
                            continue block13;
                        }
                        ++idx2;
                    }
                }
                cls1 = cls1.getSuperClass();
            }
        }
        this.writeID(os, signersId);
        this.writeID(os, protectionDomainId);
        this.writeID(os, reserved1Id);
        this.writeID(os, reserved2Id);
        int hprofInstanceSize = 0;
        IClass cls1 = cls;
        while (cls1 != null) {
            for (Object fld : cls1.getFieldDescriptors()) {
                int type = fld.getType();
                if (type == 2) {
                    hprofInstanceSize += this.idsize;
                    continue;
                }
                hprofInstanceSize += IPrimitiveArray.ELEMENT_SIZE[type];
            }
            cls1 = cls1.getSuperClass();
        }
        os.writeInt(hprofInstanceSize);
        os.writeShort(cpsize);
        for (Field fld : statics) {
            String fieldName = fld.getName();
            Matcher matcher = cpName.matcher(fieldName);
            if (!this.NEWCLASSSIZE || !matcher.matches()) continue;
            String id = matcher.group(1);
            int cpidx = Integer.parseInt(id);
            os.writeShort((short)cpidx);
            this.writeField(os, fld, true);
        }
        os.writeShort((short)(statics.size() - skipfields));
        idx = 0;
        for (Field fld : statics) {
            String fieldName = fld.getName();
            if (skip[idx++]) continue;
            fieldName = this.remap.renameMethodName(cls.getName(), fieldName, true);
            this.writeString(os, fieldName);
            this.writeField(os, fld, true);
        }
        List fields = cls.getFieldDescriptors();
        os.writeShort((short)fields.size());
        for (Object fld : fields) {
            String fieldName = fld.getName();
            fieldName = this.remap.renameMethodName(cls.getName(), fieldName, false);
            this.writeString(os, fieldName);
            int ty = fld.getType();
            switch (ty) {
                case 4: {
                    os.writeByte(4);
                    break;
                }
                case 8: {
                    os.writeByte(8);
                    break;
                }
                case 5: {
                    os.writeByte(5);
                    break;
                }
                case 9: {
                    os.writeByte(9);
                    break;
                }
                case 10: {
                    os.writeByte(10);
                    break;
                }
                case 6: {
                    os.writeByte(6);
                    break;
                }
                case 11: {
                    os.writeByte(11);
                    break;
                }
                case 7: {
                    os.writeByte(7);
                    break;
                }
                case 2: {
                    os.writeByte(2);
                    break;
                }
            }
        }
        this.totalBytes += cls.getUsedHeapSize();
    }

    private void writeField(DataOutput os, Field fld, boolean addType) throws IOException {
        int ty = fld.getType();
        switch (ty) {
            case 4: {
                if (addType) {
                    os.writeByte(4);
                }
                int booleanValue = this.redact == RedactType.FULL ? 0 : ((Boolean)fld.getValue() != false ? 1 : 0);
                os.writeByte(booleanValue);
                break;
            }
            case 8: {
                if (addType) {
                    os.writeByte(8);
                }
                byte byteValue = this.redact != RedactType.NONE && this.redact != RedactType.NAMES ? (byte)0 : (Byte)fld.getValue();
                os.writeByte(byteValue);
                break;
            }
            case 5: {
                if (addType) {
                    os.writeByte(5);
                }
                char charValue = this.redact != RedactType.NONE && this.redact != RedactType.NAMES ? (char)'\u0000' : ((Character)fld.getValue()).charValue();
                os.writeChar(charValue);
                break;
            }
            case 9: {
                if (addType) {
                    os.writeByte(9);
                }
                short shortValue = this.redact == RedactType.FULL ? (short)0 : (Short)fld.getValue();
                os.writeShort(shortValue);
                break;
            }
            case 10: {
                if (addType) {
                    os.writeByte(10);
                }
                int intValue = this.redact == RedactType.FULL ? 0 : (Integer)fld.getValue();
                os.writeInt(intValue);
                break;
            }
            case 6: {
                if (addType) {
                    os.writeByte(6);
                }
                float floatValue = this.redact == RedactType.FULL ? 0.0f : ((Float)fld.getValue()).floatValue();
                os.writeFloat(floatValue);
                break;
            }
            case 11: {
                if (addType) {
                    os.writeByte(11);
                }
                long longValue = this.redact == RedactType.FULL ? 0L : (Long)fld.getValue();
                os.writeLong(longValue);
                break;
            }
            case 7: {
                if (addType) {
                    os.writeByte(7);
                }
                double doubleValue = this.redact == RedactType.FULL ? 0.0 : (Double)fld.getValue();
                os.writeDouble(doubleValue);
                break;
            }
            case 2: {
                ObjectReference value;
                if (addType) {
                    os.writeByte(2);
                }
                if ((value = (ObjectReference)fld.getValue()) != null) {
                    this.writeID(os, value.getObjectAddress());
                    break;
                }
                this.writeID(os, 0L);
                break;
            }
        }
    }

    private void dumpThreadRoots(DataOutput os) throws IOException, SnapshotException {
        for (IClass cls : this.snapshot.getClasses()) {
            this.dumpThreadRoots(os, cls);
        }
    }

    private int dumpObjects(DataOutputStream3 os, DataOutputStream3 os2, int start, int end, boolean check, IProgressListener listener) throws IOException, SnapshotException {
        int i = 0;
        if (this.objects != null) {
            for (int[] objs : this.objects) {
                i = this.dumpObjects(os, os2, start, end, i, objs, check, listener);
                if (end >= 0 && i >= end) {
                    return i;
                }
                if (i < 0) {
                    return -i;
                }
                if (!listener.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        } else {
            for (IClass cls : this.snapshot.getClasses()) {
                int[] objs = cls.getObjectIds();
                i = this.dumpObjects(os, os2, start, end, i, objs, check, listener);
                if (end >= 0 && i >= end) {
                    return i;
                }
                if (i < 0) {
                    return -i;
                }
                if (!listener.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        return -i;
    }

    private int dumpObjects(DataOutputStream3 os, DataOutputStream3 os2, int start, int end, int i, int[] objs, boolean check, IProgressListener listener) throws SnapshotException, IOException {
        int numberOfObjects = objs.length;
        if (i + numberOfObjects <= start) {
            if ((i += numberOfObjects) == start && numberOfObjects == 0) {
                listener.worked(3);
            }
        } else {
            int j = 0;
            int[] nArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                int o = nArray[n2];
                if (i < start) {
                    ++i;
                } else if (this.dumpObject(os, os2, this.snapshot.getObject(o), check && i > start)) {
                    ++this.totalObjects;
                    this.progress(numberOfObjects, ++j, listener);
                    if (end >= 0 && ++i >= end) {
                        return i;
                    }
                } else {
                    return -i;
                }
                ++n2;
            }
            if (numberOfObjects == 0) {
                listener.worked(3);
            }
        }
        return i;
    }

    private void progress(int numberOfObjects, int j, IProgressListener listener) {
        int k = 1;
        while (k <= 3) {
            if (j == (k * numberOfObjects + 3 - 1) / 3) {
                listener.worked(1);
            }
            ++k;
        }
        if (listener.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public int findID(int id, int[][] objid) {
        int i = 0;
        while (i < objid.length) {
            int j = 0;
            while (j < objid[i].length) {
                if (objid[i][j] == id) {
                    objid[i][j] = -1;
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    private void processRoot(DataOutput os, GCRootInfo g, int[][] objs) throws IOException {
        if (!this.includeObject(g.getObjectId())) {
            return;
        }
        switch (g.getType()) {
            case 4: {
                Integer serial = this.threadToSerial.get(g.getContextId());
                if (serial == null) break;
                os.writeByte(2);
                this.writeID(os, g.getObjectAddress());
                os.writeInt(serial);
                os.writeInt(this.findID(g.getObjectId(), objs));
                break;
            }
            case 64: {
                Integer serial = this.threadToSerial.get(g.getContextId());
                if (serial == null) break;
                os.writeByte(3);
                this.writeID(os, g.getObjectAddress());
                os.writeInt(serial);
                os.writeInt(this.findID(g.getObjectId(), objs));
                break;
            }
            case 128: {
                Integer serial = this.threadToSerial.get(g.getContextId());
                if (serial == null) break;
                os.writeByte(4);
                this.writeID(os, g.getObjectAddress());
                os.writeInt(serial);
                break;
            }
            case 16: {
                Integer serial = this.threadToSerial.get(g.getContextId());
                if (serial == null) break;
                os.writeByte(6);
                this.writeID(os, g.getObjectAddress());
                os.writeInt(serial);
                break;
            }
            case 4096: {
                Integer serial = this.threadToSerial.get(g.getContextId());
                if (serial == null) break;
                os.writeByte(3);
                this.writeID(os, g.getObjectAddress());
                os.writeInt(serial);
                os.writeInt(this.findID(g.getObjectId(), objs));
                break;
            }
        }
    }

    public void dumpThreadRoots(DataOutput os, IClass cls) throws SnapshotException, IOException {
        int[] nArray = cls.getObjectIds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            GCRootInfo[] gp;
            int oid = nArray[n2];
            if (this.includeObject(cls.getObjectId()) && (gp = this.snapshot.getGCRootInfo(oid)) != null) {
                GCRootInfo[] gCRootInfoArray = gp;
                int n3 = gp.length;
                int n4 = 0;
                while (n4 < n3) {
                    GCRootInfo g = gCRootInfoArray[n4];
                    switch (g.getType()) {
                        case 256: {
                            Object objs;
                            IObject io = this.snapshot.getObject(oid);
                            IThreadStack its = this.snapshot.getThreadStack(oid);
                            if (its != null) {
                                IStackFrame[] fms = its.getStackFrames();
                                objs = new int[fms.length][];
                                int i = 0;
                                while (i < fms.length) {
                                    objs[i] = (int[])fms[i].getLocalObjectsIds().clone();
                                    ++i;
                                }
                            } else {
                                objs = new int[0][0];
                            }
                            this.processThreadLocalRefs(os, io, (int[][])objs);
                            break;
                        }
                        default: {
                            this.processRoot(os, g, new int[0][0]);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void processThreadLocalRefs(DataOutput os, IObject io, int[][] objs) throws IOException, SnapshotException {
        for (NamedReference nr : io.getOutboundReferences()) {
            if (!(nr instanceof ThreadToLocalReference)) continue;
            ThreadToLocalReference tlr = (ThreadToLocalReference)nr;
            GCRootInfo[] gCRootInfoArray = tlr.getGcRootInfo();
            int n = gCRootInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                GCRootInfo g2 = gCRootInfoArray[n2];
                this.processRoot(os, g2, objs);
                if (g2.getType() == 4096) {
                    this.processThreadLocalRefs(os, tlr.getObject(), objs);
                }
                ++n2;
            }
        }
    }

    private boolean dumpObject(DataOutputStream3 os, DataOutputStream3 os2, IObject io, boolean check) throws IOException, SnapshotException {
        if (io instanceof IInstance) {
            return this.dumpInstance(os, os2, (IInstance)io, check);
        }
        if (io instanceof IPrimitiveArray) {
            return this.dumpPrimitiveArray(os, (IPrimitiveArray)io, check);
        }
        if (io instanceof IObjectArray) {
            return this.dumpObjectArray(os, (IObjectArray)io, check);
        }
        if (io instanceof IClass) {
            return this.dumpClassObject(os, (IClass)io, check);
        }
        return true;
    }

    private boolean dumpClassObject(DataOutputStream3 os, IClass io, boolean check) throws IOException {
        if (!this.classesAsInstances) {
            return true;
        }
        IClass cls = io.getClazz();
        int size = (int)cls.getHeapSizePerInstance();
        int size2 = 0;
        IClass cls2 = cls;
        while (cls2 != null) {
            for (FieldDescriptor fd : cls2.getFieldDescriptors()) {
                int se;
                switch (fd.getType()) {
                    case 2: {
                        se = this.idsize;
                        break;
                    }
                    default: {
                        se = IPrimitiveArray.ELEMENT_SIZE[fd.getType()];
                    }
                }
                size2 += se;
            }
            cls2 = cls2.getSuperClass();
        }
        size = size2;
        if (check && os.size() + 1L + (long)this.idsize + 4L + (long)this.idsize + 4L + (long)size > this.segsize) {
            return false;
        }
        os.writeByte(33);
        this.writeID(os, io.getObjectAddress());
        os.writeInt(1);
        this.writeID(os, cls.getObjectAddress());
        os.writeInt(size);
        Field[] ss = cls.getStaticFields().toArray(new Field[0]);
        IClass cls22 = cls;
        while (cls22 != null) {
            for (FieldDescriptor fd : cls22.getFieldDescriptors()) {
                int se;
                int fix = 0;
                fix = 0;
                while (fix < ss.length) {
                    Field fs = ss[fix];
                    if (fs != null && fs.getType() == fd.getType() && fs.getName().equals("<" + fd.getName() + ">")) {
                        this.writeField(os, fs, false);
                        ss[fix] = null;
                        break;
                    }
                    ++fix;
                }
                if (fix < ss.length) continue;
                switch (fd.getType()) {
                    case 2: {
                        se = this.idsize;
                        break;
                    }
                    default: {
                        se = IPrimitiveArray.ELEMENT_SIZE[fd.getType()];
                    }
                }
                os.write(new byte[se]);
            }
            cls22 = cls22.getSuperClass();
        }
        return true;
    }

    private boolean dumpObjectArray(DataOutputStream3 os, IObjectArray ii, boolean check) throws IOException {
        if (check && os.size() + 1L + (long)this.idsize + 4L + 4L + (long)this.idsize + (long)(ii.getLength() * this.idsize) > this.segsize) {
            return false;
        }
        os.writeByte(34);
        this.writeID(os, ii.getObjectAddress());
        os.writeInt(1);
        os.writeInt(ii.getLength());
        this.writeID(os, ii.getClazz().getObjectAddress());
        long[] l = ii.getReferenceArray();
        int i = 0;
        while (i < ii.getLength()) {
            this.writeID(os, l[i]);
            ++i;
        }
        this.totalBytes += ii.getUsedHeapSize();
        return true;
    }

    private boolean dumpPrimitiveArray(DataOutputStream3 os, IPrimitiveArray ii, boolean check) throws IOException {
        Object a;
        if (check && os.size() + 1L + (long)this.idsize + 4L + 4L + 1L + (long)ii.getLength() * (1L << (ii.getType() & 3)) > this.segsize) {
            return false;
        }
        os.writeByte(35);
        this.writeID(os, ii.getObjectAddress());
        os.writeInt(1);
        os.writeInt(ii.getLength());
        os.writeByte(ii.getType());
        Object object = a = this.redact == RedactType.FULL ? null : ii.getValueArray();
        if (ii.getType() == 4) {
            int i = 0;
            while (i < ii.getLength()) {
                int booleanValue = this.redact == RedactType.FULL ? 0 : (((boolean[])a)[i] ? 1 : 0);
                os.writeByte(booleanValue);
                ++i;
            }
        } else if (ii.getType() == 8) {
            if (this.redact == RedactType.NAMES) {
                String s = new String((byte[])a, UTF8);
                String newstr = this.remap.mapClass(s);
                if (newstr == null) {
                    newstr = this.remap.mapField(s);
                }
                if (newstr == null) {
                    newstr = this.remap.mapSignature(s);
                }
                if (newstr != null) {
                    byte[] b = newstr.getBytes(UTF8);
                    if (b.length == ii.getLength()) {
                        a = b;
                    } else {
                        byte[] b2 = new byte[ii.getLength()];
                        System.arraycopy(b, 0, b2, 0, Math.min(b.length, ii.getLength()));
                        a = b2;
                    }
                }
            } else if (this.redact != RedactType.NONE) {
                a = new byte[ii.getLength()];
            }
            os.write((byte[])a);
        } else if (ii.getType() == 9) {
            int i = 0;
            while (i < ii.getLength()) {
                short shortValue = this.redact == RedactType.FULL ? (short)0 : ((short[])a)[i];
                os.writeShort(shortValue);
                ++i;
            }
        } else if (ii.getType() == 5) {
            if (this.redact == RedactType.NAMES) {
                String s = new String((char[])a);
                String newstr = this.remap.mapClass(s);
                if (newstr == null) {
                    newstr = this.remap.mapField(s);
                }
                if (newstr == null) {
                    newstr = this.remap.mapSignature(s);
                }
                if (newstr != null) {
                    char[] b = newstr.toCharArray();
                    if (b.length == ii.getLength()) {
                        a = b;
                    } else {
                        char[] b2 = new char[ii.getLength()];
                        System.arraycopy(b, 0, b2, 0, Math.min(b.length, ii.getLength()));
                        a = b2;
                    }
                }
            }
            int i = 0;
            while (i < ii.getLength()) {
                char shortValue = this.redact != RedactType.NONE && this.redact != RedactType.NAMES ? (char)'\u0000' : ((char[])a)[i];
                os.writeChar(shortValue);
                ++i;
            }
        } else if (ii.getType() == 10) {
            int i = 0;
            while (i < ii.getLength()) {
                int intValue = this.redact != RedactType.NONE && this.redact != RedactType.NAMES ? 0 : ((int[])a)[i];
                os.writeInt(intValue);
                ++i;
            }
        } else if (ii.getType() == 11) {
            int i = 0;
            while (i < ii.getLength()) {
                long longValue = this.redact == RedactType.FULL ? 0L : ((long[])a)[i];
                os.writeLong(longValue);
                ++i;
            }
        } else if (ii.getType() == 6) {
            int i = 0;
            while (i < ii.getLength()) {
                float floatValue = this.redact == RedactType.FULL ? 0.0f : ((float[])a)[i];
                os.writeFloat(floatValue);
                ++i;
            }
        } else if (ii.getType() == 7) {
            int i = 0;
            while (i < ii.getLength()) {
                double doubleValue = this.redact == RedactType.FULL ? 0.0 : ((double[])a)[i];
                os.writeDouble(doubleValue);
                ++i;
            }
        }
        this.totalBytes += ii.getUsedHeapSize();
        return true;
    }

    private boolean dumpInstance(DataOutputStream3 os, DataOutputStream3 os2, IInstance ii, boolean check) throws IOException {
        if (ii.getObjectAddress() == 0L) {
            if (this.classloaders.contains(ii.getObjectId())) {
                ++this.totalClassloaders;
            }
            return true;
        }
        IClass cls = ii.getClazz();
        long mark1 = os2.size();
        this.dumpInstanceFields(os2, cls, ii);
        long mark2 = os2.size();
        long size = mark2 - mark1;
        if (check && os.size() + 1L + (long)this.idsize + 4L + (long)this.idsize + 4L + size > this.segsize) {
            return false;
        }
        os.writeByte(33);
        this.writeID(os, ii.getObjectAddress());
        os.writeInt(1);
        this.writeID(os, cls.getObjectAddress());
        os.writeInt((int)size);
        this.dumpInstanceFields(os, cls, ii);
        if (this.classloaders.contains(ii.getObjectId())) {
            ++this.totalClassloaders;
        }
        this.totalBytes += cls.getHeapSizePerInstance();
        return true;
    }

    private void dumpInstanceFields(DataOutputStream3 os, IClass cls, IInstance ii) throws IOException {
        ArrayList allf = new ArrayList(ii.getFields());
        IClass cls1 = cls;
        while (cls1 != null) {
            for (FieldDescriptor f : cls1.getFieldDescriptors()) {
                boolean found = false;
                ListIterator it = allf.listIterator();
                while (it.hasNext()) {
                    Field fld = (Field)it.next();
                    if (!f.getName().equals(fld.getName())) continue;
                    it.remove();
                    found = true;
                    this.writeField(os, fld, false);
                    break;
                }
                if (found) continue;
                throw new IllegalStateException("missing field value " + f);
            }
            cls1 = cls1.getSuperClass();
        }
    }

    private void writeID(DataOutput os, long addr) throws IOException {
        if (this.idsize == 4) {
            os.writeInt((int)addr);
        } else {
            os.writeLong(addr);
        }
    }

    private void writeString(DataOutput os, String s) throws IOException {
        long id;
        if (this.stringToID.containsKey(s)) {
            id = this.stringToID.get(s).intValue();
        } else {
            id = this.nextStringID++;
            this.stringToID.put(s, (int)id);
        }
        this.writeID(os, id);
    }

    static class DataOutputStream2
    extends DataOutputStream {
        public DataOutputStream2(OutputStream out) {
            super(out);
        }

        public void reset() {
            this.written = 0;
        }
    }

    static class DataOutputStream3
    implements DataOutput,
    Closeable {
        final DataOutputStream2 out;
        protected long written = 0L;

        public DataOutputStream3(OutputStream out) {
            this.out = new DataOutputStream2(out);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
            this.written += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.written += (long)len;
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.out.writeBoolean(v);
            ++this.written;
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.out.writeByte(v);
            ++this.written;
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.out.writeShort(v);
            this.written += 2L;
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.out.writeChar(v);
            this.written += 2L;
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.out.writeInt(v);
            this.written += 4L;
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.out.writeLong(v);
            this.written += 8L;
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.out.writeFloat(v);
            this.written += 4L;
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.out.writeDouble(v);
            this.written += 8L;
        }

        @Override
        public void writeBytes(String s) throws IOException {
            this.out.writeBytes(s);
            this.written += (long)s.length();
        }

        @Override
        public void writeChars(String s) throws IOException {
            this.out.writeChars(s);
            this.written += (long)(2 * s.length());
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.out.reset();
            int m1 = this.out.size();
            this.out.writeUTF(s);
            int m2 = this.out.size();
            this.written += (long)(m2 - m1);
        }

        public long size() {
            return this.written;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    static class Frame {
        String clazz;
        String method;
        String signature;
        String sourceFile;
        int lineNumber;

        public Frame(String clazz, String method, String signature, String sourceFile, int lineNumber) {
            this.clazz = clazz;
            this.method = method;
            this.signature = signature;
            this.sourceFile = sourceFile;
            this.lineNumber = lineNumber;
        }

        public static Frame parse(String frame) {
            String sourcefile;
            int c;
            String[] parts = frame.split("\\s+", 3);
            String mn = parts.length >= 2 ? parts[1] : "";
            String source = parts.length >= 3 ? parts[2] : "";
            int b = mn.indexOf(40);
            if (b < 0) {
                b = mn.length();
            }
            String classname = (c = mn.lastIndexOf(46, b)) >= 0 ? mn.substring(0, c) : "";
            String method = mn.substring(c + 1, b);
            String sig = mn.substring(b);
            if (source.startsWith("(")) {
                source = source.substring(1);
            }
            if (source.endsWith(")")) {
                source = source.substring(0, source.length() - 1);
            }
            int cl = source.indexOf(58);
            int linenum = 0;
            if (cl >= 0) {
                sourcefile = source.substring(0, cl);
                int cn1 = cl + 1;
                while (cn1 < source.length() && source.charAt(cn1) >= '0' && source.charAt(cn1) <= '9') {
                    ++cn1;
                }
                if (cn1 > cl + 1) {
                    linenum = Integer.parseInt(source.substring(cl + 1, cn1));
                }
            } else {
                int br = source.indexOf(40);
                sourcefile = br >= 0 ? source.substring(0, br) : "";
                linenum = source.contains("Compiled Code") ? -2 : (source.contains("Native Method") ? -3 : -1);
            }
            return new Frame(classname, method, sig, sourcefile, linenum);
        }
    }

    static class NullStream
    extends OutputStream {
        NullStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    public static enum RedactType {
        NONE("none"),
        NAMES("names"),
        BASIC("basic"),
        FULL("full");

        String type;

        private RedactType(String s) {
            this.type = s;
        }
    }

    public static class Remap {
        Pattern skipPattern;
        Pattern avoidPattern;
        boolean undo;
        boolean matchFields;
        int remapFail = 0;
        private Random rnd = new Random();
        private Map<String, String> obfuscated = new HashMap<String, String>();
        private Set<String> used = new HashSet<String>();
        private Map<String, String> usedField = new HashMap<String, String>();
        private static final String methodSep = "@";
        private static final String[] names0 = new String[]{"a", "e", "i", "o", "u"};
        private static final String[] names1 = new String[]{"b", "bl", "br", "c", "cl", "cr", "d", "dr", "f", "fl", "fr", "g", "gl", "gr", "h", "j", "k", "kl", "kn", "kr", "kw", "l", "m", "n", "p", "pl", "pr", "qu", "r", "s", "sh", "st", "t", "th", "tr", "v", "w", "wr", "x", "y", "z"};
        private static final String[] names2 = new String[]{"a", "ae", "ai", "e", "ea", "ee", "ei", "eo", "eu", "i", "ia", "ie", "io", "o", "oa", "oe", "oo", "ou", "u", "ua"};
        private static final String[] names3 = new String[]{"b", "ch", "ck", "d", "de", "ff", "g", "gh", "k", "l", "le", "ly", "m", "n", "nd", "ne", "ng", "nk", "p", "r", "rb", "rd", "re", "rf", "rk", "rl", "rm", "rn", "rp", "rt", "ry", "s", "sh", "st", "sy", "t", "te", "th", "ts", "ve", "w", "y", "z"};
        private static final String[] names4 = new String[]{"tihs", "ssip", "kcuf", "tnuc", "kcoc", "stit", "knaw", "ggin"};

        public Remap(Pattern skipPattern, Pattern avoidPattern, boolean matchFields, boolean undo) {
            this.skipPattern = skipPattern;
            this.avoidPattern = avoidPattern;
            this.matchFields = matchFields;
            this.undo = undo;
        }

        public void loadMapping(File mapFile, boolean undo) throws IOException {
            if (mapFile != null && mapFile.canRead()) {
                Properties p = new Properties();
                try (FileInputStream rdr = new FileInputStream(mapFile);){
                    p.load(rdr);
                }
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    String fieldNew;
                    String fieldOld;
                    String key = e.getKey().toString();
                    String value = e.getValue().toString();
                    if (undo) {
                        this.obfuscated.put(value, key);
                        this.used.add(key);
                        fieldOld = this.fieldName(key);
                        fieldNew = this.fieldName(value);
                        this.usedField.put(fieldNew, fieldOld);
                        continue;
                    }
                    this.obfuscated.put(key, value);
                    this.used.add(value);
                    fieldOld = this.fieldName(key);
                    fieldNew = this.fieldName(value);
                    this.usedField.put(fieldOld, fieldNew);
                }
            }
        }

        public void saveMapping(File mapFile, boolean undo, String comments) throws IOException {
            if (!(undo || mapFile == null || !mapFile.canWrite() && mapFile.exists())) {
                SortedProperties p = new SortedProperties();
                for (Map.Entry<String, String> e : this.obfuscated.entrySet()) {
                    p.setProperty(e.getKey(), e.getValue());
                }
                try (FileOutputStream wrt = new FileOutputStream(mapFile);){
                    p.store(wrt, comments);
                }
            }
        }

        public boolean isRemapped(String cn) {
            return !this.undo && (this.skipPattern == null || !this.skipPattern.matcher(cn).matches());
        }

        public String mapClass(String cn) {
            return this.obfuscated.get(cn);
        }

        public String mapField(String cn) {
            return this.usedField.get(cn);
        }

        public String mapSignature(String sig) {
            if (!sig.matches("\\p{Print}*L\\p{Print}+;\\p{Print}*")) {
                return null;
            }
            String[] words = sig.split("[;<\\(\\)\\[\\]+*]+");
            String[] wordsReplace = new String[words.length];
            int found = 0;
            int i = 0;
            while (i < words.length) {
                String w = words[i];
                String w2 = w.replaceFirst("[VZBCIJFD]*", "");
                if (!w2.startsWith("L")) {
                    wordsReplace[i] = w;
                } else if (!this.obfuscated.containsKey(w2 = w2.substring(1))) {
                    String w3 = w2.replace('/', '.');
                    if (!this.obfuscated.containsKey(w3)) {
                        wordsReplace[i] = w;
                    } else {
                        words[i] = "L" + w2;
                        wordsReplace[i] = "L" + this.obfuscated.get(w3).replace('.', '/');
                        ++found;
                    }
                } else {
                    words[i] = "L" + w2;
                    wordsReplace[i] = "L" + this.obfuscated.get(w2);
                    ++found;
                }
                ++i;
            }
            if (found == 0) {
                return null;
            }
            int j = 0;
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < words.length) {
                int k = sig.indexOf(words[i2], j);
                if (k < 0) {
                    return null;
                }
                sb.append(sig.substring(j, k));
                sb.append(wordsReplace[i2]);
                j = k + words[i2].length();
                ++i2;
            }
            sb.append(sig.substring(j));
            return sb.toString();
        }

        private boolean isAvoid(String cn) {
            return this.avoidPattern != null && this.avoidPattern.matcher(cn).matches();
        }

        public String renameFileName(String classname, String filename) {
            String clsnw = this.renameClassName(classname);
            String old = this.baseName(classname);
            String nw = this.baseName(clsnw);
            return filename.replaceFirst(old, nw);
        }

        private String baseName(String classname) {
            int dot = classname.lastIndexOf(46);
            int dol = classname.indexOf(36, dot);
            if (dol < 0) {
                dol = classname.length();
            }
            String fn = classname.substring(dot + 1, dol);
            return fn;
        }

        public String renameSignature(String signature) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < signature.length()) {
                char ch = signature.charAt(i);
                sb.append(ch);
                if (ch == 'L') {
                    int semi = sb.indexOf(";", i);
                    if (semi >= 0) {
                        String cn = signature.substring(i + 1, semi);
                        String newcn = this.renameClassName(cn);
                        sb.append(newcn);
                        sb.append(";");
                        i = semi;
                    } else {
                        sb.append(signature.substring(i + 1));
                        break;
                    }
                }
                ++i;
            }
            return sb.toString();
        }

        public String renameMethodName(String className, String method, boolean upper) {
            String mn = String.valueOf(className) + methodSep + method;
            if (this.obfuscated.containsKey(mn)) {
                String newmn = this.obfuscated.get(mn);
                return newmn.substring(newmn.indexOf(methodSep) + 1);
            }
            if (!this.isRemapped(className)) {
                return method;
            }
            String newcls = this.renameClassName(className);
            String newmn = this.remap(mn, String.valueOf(newcls) + methodSep, method, "", true, upper);
            return newmn.substring(newmn.indexOf(methodSep) + 1);
        }

        private String fieldName(String classField) {
            String[] fns = classField.split(Pattern.quote(methodSep), 2);
            if (fns.length >= 2) {
                return fns[1];
            }
            return "";
        }

        public String renameClassName(String classname) {
            String cn;
            String newpack;
            if (this.obfuscated.containsKey(classname)) {
                return this.obfuscated.get(classname);
            }
            if (classname.endsWith("[]")) {
                String baseclassname = classname.replace("[]", "");
                return String.valueOf(this.renameClassName(baseclassname)) + classname.substring(baseclassname.length());
            }
            if (classname.startsWith("[")) {
                String baseclassname = classname.replace("[", "");
                return String.valueOf(classname.substring(0, classname.length() - baseclassname.length())) + this.renameClassName(baseclassname);
            }
            if (!this.isRemapped(classname)) {
                return classname;
            }
            String last = "";
            if (classname.endsWith(".")) {
                last = ".";
                int i = classname.lastIndexOf(46, classname.length() - 2);
                if (i >= 0) {
                    String pack = classname.substring(0, i + 1);
                    newpack = this.renameClassName(pack);
                    cn = classname.substring(i + 1, classname.length() - 1);
                } else {
                    String pack = "";
                    newpack = "";
                    cn = classname.substring(0, classname.length() - 1);
                }
            } else {
                int i = classname.lastIndexOf(46, classname.length() - 2);
                int j = classname.lastIndexOf(36, classname.length() - 2);
                if (j > i) {
                    String pack = classname.substring(0, j);
                    newpack = String.valueOf(this.renameClassName(pack)) + "$";
                    cn = classname.substring(j + 1);
                } else if (i >= 0) {
                    String pack = classname.substring(0, i + 1);
                    newpack = this.renameClassName(pack);
                    cn = classname.substring(i + 1);
                } else {
                    String pack = "";
                    newpack = "";
                    cn = classname;
                }
            }
            return this.remap(classname, newpack, cn, last, false, false);
        }

        private String remap(String classname, String newpack, String cn, String last, boolean field, boolean upper) {
            int k = 0;
            while (k < 200) {
                String newcn;
                int ln = cn.length();
                String np = k == 0 && cn.matches("[0-9]+") ? cn : (k == 0 && this.matchFields && field && this.usedField.containsKey(cn) ? this.usedField.get(cn) : (k < 50 ? this.randomWordsLen(ln, field && upper) : (k < 100 ? this.randomString(ln) : this.randomString2(ln))));
                if (field) {
                    if (upper) {
                        np = np.toUpperCase(Locale.ENGLISH);
                    }
                } else {
                    np = !last.equals(".") ? this.titleCase(np) : np.toLowerCase(Locale.ENGLISH);
                }
                if (!(this.used.contains(newcn = String.valueOf(newpack) + np + last) || !this.isRemapped(newcn) || k < 150 && this.isAvoid(newcn))) {
                    this.obfuscated.put(classname, newcn);
                    this.used.add(newcn);
                    if (field) {
                        this.usedField.put(cn, np);
                    }
                    return newcn;
                }
                ++k;
            }
            String newcn = String.valueOf(newpack) + cn + last;
            this.obfuscated.put(classname, newcn);
            this.used.add(newcn);
            if (field) {
                this.usedField.put(cn, cn);
            }
            ++this.remapFail;
            return newcn;
        }

        private String titleCase(String np) {
            if (np.length() < 1) {
                return np;
            }
            np = String.valueOf(Character.toTitleCase(np.charAt(0))) + np.substring(1);
            return np;
        }

        private String randomWordsLen(int length, boolean unders) {
            int maxlen;
            int minlen = 5;
            int n = maxlen = unders ? 11 : 15;
            if (length > maxlen) {
                int sp = 5 + this.rnd.nextInt(Math.min(maxlen, length - 5 - (unders ? 1 : 0)) + 1 - 5);
                String w = this.randomWordLen(sp);
                if (unders) {
                    w = String.valueOf(w) + "_" + this.randomWordsLen(length - sp - 1, unders);
                    return w;
                }
                return String.valueOf(w) + this.titleCase(this.randomWordsLen(length - sp, unders));
            }
            return this.randomWordLen(length);
        }

        private String randomWordLen(int length) {
            boolean vowel;
            String ret;
            if (length < 3) {
                return this.randomString(length);
            }
            int p1 = (length - 2) / 4;
            int p2 = (length - 1) / 2;
            do {
                int pt;
                vowel = this.rnd.nextFloat() < 0.15f;
                while ((ret = this.randomWord(pt = p1 + this.rnd.nextInt(p2 - p1 + 1))).length() != (vowel ? length - 1 : length)) {
                }
            } while (this.tryAgain(ret = this.addVowel(ret, vowel)));
            return ret;
        }

        private boolean tryAgain(String tocheck) {
            StringBuilder sb = new StringBuilder(tocheck);
            String rev = sb.reverse().toString().toLowerCase(Locale.ENGLISH);
            String[] stringArray = names4;
            int n = names4.length;
            int n2 = 0;
            while (n2 < n) {
                String ts = stringArray[n2];
                if (rev.indexOf(ts) >= 0) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private String addVowel(String base, boolean add) {
            if (add) {
                base = String.valueOf(names0[this.rnd.nextInt(names0.length)]) + base;
            }
            return base;
        }

        private String randomWord(int parts) {
            StringBuilder sb = new StringBuilder();
            int j = 0;
            while (j < parts) {
                sb.append(names1[this.rnd.nextInt(names1.length)]);
                sb.append(names2[this.rnd.nextInt(names2.length)]);
                ++j;
            }
            sb.append(names3[this.rnd.nextInt(names3.length)]);
            return sb.toString();
        }

        private String randomString(int length) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < length) {
                sb.append((char)(97 + this.rnd.nextInt(26)));
                ++i;
            }
            return sb.toString();
        }

        private String randomString2(int length) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < length) {
                sb.append((char)(97 + this.rnd.nextInt(26) + (this.rnd.nextBoolean() ? -32 : 0)));
                ++i;
            }
            return sb.toString();
        }

        private static class SortedProperties
        extends Properties {
            private static final long serialVersionUID = 1L;

            private SortedProperties() {
            }

            @Override
            public Enumeration<Object> keys() {
                ArrayList<Object> list = Collections.list(super.keys());
                Collections.sort(list, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                return Collections.enumeration(list);
            }
        }
    }
}

