/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lang.linescanner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import org.eclipse.photran.internal.core.lang.linescanner.ILookaheadLineReader;

public final class LookaheadLineReader
implements ILookaheadLineReader<IOException> {
    private final BufferedReader input;
    private final LinkedList<String> lineBuffer;
    private int currentLine;

    public LookaheadLineReader(Reader input) {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        this.lineBuffer = new LinkedList();
        this.currentLine = 0;
    }

    @Override
    public String readNextLine() throws IOException {
        String result;
        if (this.currentLine == this.lineBuffer.size()) {
            this.lineBuffer.add(this.input.readLine());
        }
        if ((result = this.lineBuffer.get(this.currentLine)) == null) {
            return null;
        }
        ++this.currentLine;
        return result;
    }

    @Override
    public String advanceAndRestart(int numChars) {
        this.currentLine = 0;
        StringBuilder result = new StringBuilder(numChars);
        String line = this.lineBuffer.isEmpty() ? null : this.lineBuffer.get(0);
        while (line != null && numChars >= line.length()) {
            result.append(this.lineBuffer.remove(0));
            numChars -= line.length();
            String string = line = this.lineBuffer.isEmpty() ? null : this.lineBuffer.get(0);
        }
        if (line != null && numChars > 0 && numChars < line.length()) {
            result.append(line.substring(0, numChars));
            this.lineBuffer.set(0, line.substring(numChars));
        }
        return result.toString();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

