/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.ui.actions.Q7ExecutionViewAction;
import org.eclipse.rcptt.ui.launching.LaunchUtils;

public class RunFailedAction
extends Q7ExecutionViewAction {
    private List<IExecutable> toExecute = new ArrayList<IExecutable>();

    public RunFailedAction() {
        this.setToolTipText(Messages.RunFailedAction_ToolTip);
        this.setImageDescriptor(Images.getImageDescriptor("icons/launching/run_failed.gif"));
        this.setDisabledImageDescriptor(Images.getImageDescriptor("icons/launching/d_run_failed.gif"));
    }

    @Override
    public void updateEnablement(IExecutionSession session) {
        this.toExecute = new ArrayList<IExecutable>();
        if (session != null) {
            IExecutable[] executables;
            IExecutable[] iExecutableArray = executables = session.getTestCases();
            int n = executables.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutable iExecutable = iExecutableArray[n2];
                if (!iExecutable.getResultStatus().isOK()) {
                    this.toExecute.add(iExecutable);
                }
                ++n2;
            }
        }
        this.setEnabled(this.toExecute.size() > 0 && !session.isRunning());
    }

    public void run() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        HashMap<String, List<List<String>>> variants = new HashMap<String, List<List<String>>>();
        for (IExecutable executable : this.toExecute) {
            IFile file = (IFile)executable.getActualElement().getResource();
            if (file != null && !files.contains(file)) {
                files.add(file);
            }
            this.updateVariant(variants, executable);
        }
        if (files.size() > 0) {
            LaunchUtils.launchContext(files.toArray(new IResource[files.size()]), "run", variants);
        }
    }
}

