/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.AddStructureVisitor;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableFolderSyncInfo;

public class Add
extends Command {
    protected Add() {
    }

    @Override
    protected String getRequestId() {
        return "add";
    }

    @Override
    protected ICVSResource[] sendLocalResourceState(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        ICVSResource[] iCVSResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSResource resource = iCVSResourceArray[n2];
            Assert.isNotNull((Object)resource.getRemoteLocation(session.getLocalRoot()));
            ++n2;
        }
        AddStructureVisitor visitor = new AddStructureVisitor(session, localOptions);
        visitor.visit(session, resources, monitor);
        return resources;
    }

    @Override
    protected IStatus commandFinished(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor, IStatus status) throws CVSException {
        if (status.getCode() == -10) {
            return status;
        }
        ICVSResource[] iCVSResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSResource resource = iCVSResourceArray[n2];
            if (resource.isFolder()) {
                ICVSFolder mFolder = (ICVSFolder)resource;
                FolderSyncInfo info = mFolder.getParent().getFolderSyncInfo();
                if (info == null) {
                    status = this.mergeStatus(status, (IStatus)new CVSStatus(4, NLS.bind((String)CVSMessages.Add_invalidParent, (Object[])new String[]{mFolder.getRelativePath(session.getLocalRoot())})));
                } else {
                    String repository = String.valueOf(info.getRepository()) + "/" + mFolder.getName();
                    MutableFolderSyncInfo newInfo = info.cloneMutable();
                    newInfo.setRepository(repository);
                    mFolder.setFolderSyncInfo(newInfo);
                }
            }
            ++n2;
        }
        return status;
    }

    @Override
    protected ICommandOutputListener getDefaultCommandOutputListener() {
        return new CommandOutputListener(){

            @Override
            public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
                String serverMessage = this.getServerMessage(line, location);
                if (serverMessage != null) {
                    if (serverMessage.contains("cvs commit") && serverMessage.contains("add") && serverMessage.contains("permanently")) {
                        return OK;
                    }
                    if (serverMessage.startsWith("scheduling file") && serverMessage.contains("for addition")) {
                        return OK;
                    }
                }
                return super.errorLine(line, location, commandRoot, monitor);
            }
        };
    }
}

