/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionWizardPage;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ccvs.ui.wizards.ResizableWizard;
import org.eclipse.ui.IWorkbenchPart;

public class UpdateWizard
extends ResizableWizard {
    private ResourceMapping[] mappers;
    private final IWorkbenchPart part;
    private TagSelectionWizardPage tagSelectionPage;

    public UpdateWizard(IWorkbenchPart part, ResourceMapping[] mappers) {
        super("UpdateWizard", CVSUIPlugin.getPlugin().getDialogSettings());
        this.part = part;
        this.mappers = mappers;
        this.setWindowTitle(CVSUIMessages.UpdateWizard_title);
    }

    public static void run(IWorkbenchPart part, ResourceMapping[] mappers) {
        UpdateWizard wizard = new UpdateWizard(part, mappers);
        UpdateWizard.open(part.getSite().getShell(), wizard);
    }

    public void addPages() {
        ImageDescriptor substImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.png");
        this.tagSelectionPage = new TagSelectionWizardPage("tagPage", CVSUIMessages.UpdateWizard_0, substImage, CVSUIMessages.UpdateWizard_1, TagSource.create(this.mappers), 31);
        this.tagSelectionPage.setAllowNoTag(true);
        this.tagSelectionPage.setHelpContxtId("org.eclipse.team.cvs.ui.update_tag_selection_page_context");
        CVSTag tag = this.getInitialSelection();
        if (tag != null) {
            this.tagSelectionPage.setSelection(tag);
        }
        this.addPage((IWizardPage)this.tagSelectionPage);
    }

    private CVSTag getInitialSelection() {
        try {
            ResourceMapping[] resourceMappingArray = this.mappers;
            int n = this.mappers.length;
            int n2 = 0;
            while (n2 < n) {
                IProject[] projects;
                ResourceMapping mapper = resourceMappingArray[n2];
                IProject[] iProjectArray = projects = mapper.getProjects();
                int n3 = projects.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject project = iProjectArray[n4];
                    ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
                    FolderSyncInfo info = folder.getFolderSyncInfo();
                    if (info != null) {
                        return info.getTag();
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e);
        }
        return null;
    }

    @Override
    public boolean performFinish() {
        try {
            new UpdateOperation(this.part, this.mappers, Command.NO_LOCAL_OPTIONS, this.tagSelectionPage.getSelectedTag()).run();
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return super.performFinish();
    }
}

