/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.util.Map;
import java.util.Objects;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.cmake.core.internal.ICMakeExecutionMarkerFactory;
import org.eclipse.cdt.cmake.core.internal.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class CMakeExecutionMarkerFactory
implements ICMakeExecutionMarkerFactory {
    private final IContainer srcFolder;

    public CMakeExecutionMarkerFactory(IContainer srcFolder) {
        this.srcFolder = Objects.requireNonNull(srcFolder);
    }

    @Override
    public final void createMarker(String message, int severity, String filePath, Map<String, Object> mandatoryAttributes) throws CoreException {
        IMarker marker;
        if (filePath == null) {
            marker = this.srcFolder.createMarker(CMAKE_PROBLEM_MARKER_ID);
        } else {
            Path path = new Path(filePath);
            try {
                marker = this.srcFolder.getFile((IPath)path).createMarker(CMAKE_PROBLEM_MARKER_ID);
            }
            catch (CoreException ign) {
                IPath srcLocation = this.srcFolder.getLocation();
                if (srcLocation.isPrefixOf((IPath)path)) {
                    int segmentsToRemove = srcLocation.segmentCount();
                    path = path.removeFirstSegments(segmentsToRemove);
                    marker = this.srcFolder.getFile((IPath)path).createMarker(CMAKE_PROBLEM_MARKER_ID);
                }
                marker = this.srcFolder.createMarker(CMAKE_PROBLEM_MARKER_ID);
                Activator.getPlugin().getLog().log((IStatus)new Status(1, Activator.getId(), String.format(Messages.CMakeErrorParser_NotAWorkspaceResource, filePath)));
            }
        }
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("severity", severity);
        for (Map.Entry<String, Object> elem : mandatoryAttributes.entrySet()) {
            marker.setAttribute(elem.getKey(), elem.getValue());
        }
    }
}

