/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.BinaryPropertySource;
import org.eclipse.cdt.internal.ui.CActionFilter;
import org.eclipse.cdt.internal.ui.CElementPropertySource;
import org.eclipse.cdt.internal.ui.CWorkbenchAdapter;
import org.eclipse.cdt.internal.ui.DeferredCWorkbenchAdapter;
import org.eclipse.cdt.internal.ui.PersistableCElementFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.ResourcePropertySource;

public class CElementAdapterFactory
implements IAdapterFactory {
    private static Class<?>[] PROPERTIES = new Class[]{IPropertySource.class, IResource.class, IWorkbenchAdapter.class, IPersistableElement.class, IDeferredWorkbenchAdapter.class, IActionFilter.class};
    private static CWorkbenchAdapter fgCWorkbenchAdapter;
    private static CActionFilter fgCActionFilter;

    public Class<?>[] getAdapterList() {
        return PROPERTIES;
    }

    public Object getAdapter(Object element, Class key) {
        ICElement celem = (ICElement)element;
        if (IPropertySource.class.equals((Object)key)) {
            return this.getPropertySource(celem);
        }
        if (IResource.class.isAssignableFrom(key)) {
            IResource resource = this.getResource(celem);
            if (resource != null && key.isAssignableFrom(resource.getClass())) {
                return resource;
            }
        } else {
            if (IPersistableElement.class.equals((Object)key)) {
                return new PersistableCElementFactory(celem);
            }
            if (IDeferredWorkbenchAdapter.class.equals((Object)key)) {
                return this.getDeferredWorkbenchAdapter(celem);
            }
            if (IWorkbenchAdapter.class.equals((Object)key)) {
                return this.getWorkbenchAdapter(celem);
            }
            if (IActionFilter.class.equals((Object)key)) {
                return this.getActionFilter(celem);
            }
        }
        return null;
    }

    private IPropertySource getPropertySource(ICElement celement) {
        if (celement instanceof IBinary) {
            return new BinaryPropertySource((IBinary)celement);
        }
        IResource res = celement.getResource();
        if (res != null) {
            if (res instanceof IFile) {
                return new FilePropertySource((IFile)res);
            }
            return new ResourcePropertySource(res);
        }
        return new CElementPropertySource(celement);
    }

    private IResource getResource(ICElement celement) {
        return celement.getResource();
    }

    private IDeferredWorkbenchAdapter getDeferredWorkbenchAdapter(ICElement celement) {
        return new DeferredCWorkbenchAdapter(celement);
    }

    private IWorkbenchAdapter getWorkbenchAdapter(ICElement celement) {
        if (fgCWorkbenchAdapter == null) {
            fgCWorkbenchAdapter = new CWorkbenchAdapter();
        }
        return fgCWorkbenchAdapter;
    }

    private IActionFilter getActionFilter(ICElement celement) {
        if (fgCActionFilter == null) {
            fgCActionFilter = new CActionFilter();
        }
        return fgCActionFilter;
    }
}

