/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.environment;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.environment.Messages;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.osgi.util.NLS;

public class EnvironmentPathUtils {
    public static final String PATH_DELIMITER = ";";
    private static final char SEPARATOR = '/';

    public static IPath getFullPath(IEnvironment env, IPath path) {
        if (EnvironmentPathUtils.isFull(path)) {
            throw new RuntimeException(NLS.bind((String)Messages.EnvironmentPathUtils_invalidPath, (Object)path));
        }
        String device = path.getDevice();
        if (device == null) {
            device = Character.toString(':');
        }
        return path.setDevice(String.valueOf(env.getId()) + '/' + device);
    }

    public static IPath getFullPath(String envId, IPath path) {
        if (EnvironmentPathUtils.isFull(path)) {
            throw new RuntimeException(NLS.bind((String)Messages.EnvironmentPathUtils_invalidPath, (Object)path));
        }
        String device = path.getDevice();
        if (device == null) {
            device = Character.toString(':');
        }
        return path.setDevice(String.valueOf(envId) + '/' + device);
    }

    public static IPath getFullPath(File folder) {
        return EnvironmentPathUtils.getFullPath(LocalEnvironment.getInstance(), (IPath)new Path(folder.getAbsolutePath()));
    }

    public static boolean isFull(IPath path) {
        String device = path.getDevice();
        return device != null && device.indexOf(47) >= 0;
    }

    public static IEnvironment getPathEnvironment(IPath path) {
        if (!EnvironmentPathUtils.isFull(path)) {
            return null;
        }
        String envId = path.getDevice();
        if (envId == null) {
            return null;
        }
        int index = envId.indexOf(47);
        envId = envId.substring(0, index);
        return EnvironmentManager.getEnvironmentById(envId);
    }

    public static IPath getLocalPath(IPath path) {
        if (!EnvironmentPathUtils.isFull(path)) {
            return path;
        }
        String device = path.getDevice();
        int index = device.indexOf(47);
        Assert.isTrue((index >= 0 ? 1 : 0) != 0);
        device = device.substring(index + 1);
        if (device.length() == 1 && device.charAt(0) == ':') {
            device = null;
        }
        return path.setDevice(device);
    }

    public static String getLocalPathString(IPath path) {
        IEnvironment env = EnvironmentPathUtils.getPathEnvironment(path);
        IPath localPath = EnvironmentPathUtils.getLocalPath(path);
        if (env != null) {
            return env.convertPathToString(localPath);
        }
        return localPath.toOSString();
    }

    public static IFileHandle getFile(IPath fullPath) {
        IEnvironment env = EnvironmentPathUtils.getPathEnvironment(fullPath);
        if (env == null) {
            return null;
        }
        IPath path = EnvironmentPathUtils.getLocalPath(fullPath);
        return env.getFile(path);
    }

    public static Map<IEnvironment, String> decodePaths(String concatenatedPaths) {
        HashMap<IEnvironment, String> result = new HashMap<IEnvironment, String>();
        if (concatenatedPaths != null) {
            String[] paths = concatenatedPaths.split(PATH_DELIMITER);
            int i = 0;
            while (i < paths.length) {
                IPath path = Path.fromPortableString((String)paths[i]);
                IEnvironment env = EnvironmentPathUtils.getPathEnvironment(path);
                if (env != null) {
                    String localPath = EnvironmentPathUtils.getLocalPathString(path);
                    result.put(env, localPath);
                }
                ++i;
            }
        }
        return result;
    }

    public static String encodePaths(Map<IEnvironment, String> env2path) {
        StringBuilder concatenatedPaths = new StringBuilder();
        for (Map.Entry<IEnvironment, String> entry : env2path.entrySet()) {
            if (concatenatedPaths.length() != 0) {
                concatenatedPaths.append(PATH_DELIMITER);
            }
            IPath path = EnvironmentPathUtils.getFullPath(entry.getKey(), (IPath)new Path(entry.getValue()));
            concatenatedPaths.append(path.toPortableString());
        }
        return concatenatedPaths.toString();
    }

    public static IFileHandle getFile(IEnvironment environment, IPath path) {
        if (EnvironmentPathUtils.isFull(path)) {
            return EnvironmentPathUtils.getFile(path);
        }
        return environment.getFile(path);
    }

    public static IFileHandle getFile(IResource resource) {
        IEnvironment environment = EnvironmentManager.getEnvironment(resource.getProject());
        if (environment == null) {
            return null;
        }
        if (environment.isLocal()) {
            return environment.getFile(resource.getLocation());
        }
        return environment.getFile(resource.getLocationURI());
    }

    public static IFileHandle getFile(IModelElement element) {
        return EnvironmentPathUtils.getFile(element, true);
    }

    public static IFileHandle getFile(IModelElement element, boolean checkExistance) {
        IEnvironment environment = EnvironmentManager.getEnvironment(element);
        if (environment == null) {
            return null;
        }
        IPath path = element.getPath();
        if (element instanceof ExternalSourceModule) {
            path = ((ExternalSourceModule)element).getFullPath();
        }
        if (environment.isLocal()) {
            IResource res = element.getResource();
            if (res != null) {
                IPath loc = res.getLocation();
                URI uri = res.getLocationURI();
                if (loc != null) {
                    return environment.getFile(loc);
                }
                if (uri != null) {
                    return environment.getFile(uri);
                }
                return null;
            }
            IFileHandle file = environment.getFile(path);
            if (checkExistance) {
                if (file.exists()) {
                    return file;
                }
            } else {
                return file;
            }
            return null;
        }
        IResource res = element.getResource();
        if (res != null) {
            return environment.getFile(res.getLocationURI());
        }
        IFileHandle file = environment.getFile(path);
        if (checkExistance) {
            if (file.exists()) {
                return file;
            }
        } else {
            return file;
        }
        return null;
    }

    public static boolean isLocalEnvironment(IPath fullPath) {
        int pos;
        String device = fullPath.getDevice();
        if (device != null && (pos = device.indexOf(47)) >= 0) {
            return "org.eclipse.dltk.core.environment.localEnvironment".equals(device.substring(0, pos));
        }
        return false;
    }
}

