/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.handlers.AbstractSnapTo;
import org.eclipse.gef.mvc.fx.handlers.ISnapToStrategy;
import org.eclipse.gef.mvc.fx.models.GridModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class SnapToGrid
extends AbstractSnapTo
implements ISnapToStrategy {
    public static final String SOURCE_SNAPPING_LOCATION_PROVIDER = "SnapToGridSourceSnappingLocationProvider";

    protected Node getGridLocalVisual(IViewer viewer) {
        return viewer instanceof InfiniteCanvasViewer ? ((InfiniteCanvasViewer)viewer).getCanvas().getContentGroup() : viewer.getRootPart().getVisual();
    }

    @Override
    public double getMaximumSnappingDistance() {
        return Double.MAX_VALUE;
    }

    @Override
    protected String getTargetLocationProviderRole() {
        return null;
    }

    protected double getSnapToGridGranularityX() {
        return 1.0;
    }

    protected double getSnapToGridGranularityY() {
        return 1.0;
    }

    @Override
    public String getSourceLocationProviderRole() {
        return SOURCE_SNAPPING_LOCATION_PROVIDER;
    }

    @Override
    protected boolean isRelevant(IContentPart<? extends Node> part) {
        return false;
    }

    @Override
    public Dimension snap(Orientation orientation, double positionInScene) {
        if (orientation != Orientation.HORIZONTAL && orientation != Orientation.VERTICAL) {
            throw new IllegalArgumentException("The given Orientation is neither HORIZONTAL nor VERTICAL.");
        }
        IViewer viewer = this.getSnappedPart().getViewer();
        Point snapped = this.snapToGrid(positionInScene, positionInScene, (GridModel)viewer.getAdapter(GridModel.class), this.getSnapToGridGranularityX(), this.getSnapToGridGranularityY(), this.getGridLocalVisual(viewer));
        if (orientation == Orientation.HORIZONTAL) {
            return new Dimension(snapped.x - positionInScene, 0.0);
        }
        return new Dimension(0.0, snapped.y - positionInScene);
    }

    protected Point snapToGrid(double sceneX, double sceneY, GridModel gridModel, double gridCellWidthFraction, double gridCellHeightFraction, Node gridLocalVisual) {
        Point2D gridLocalPosition = gridLocalVisual.sceneToLocal(sceneX, sceneY);
        double gcw = gridCellWidthFraction * gridModel.getGridCellWidth();
        double nearest = gridLocalPosition.getX() > 0.0 ? 0.5 : -0.5;
        int xs = (int)(gridLocalPosition.getX() / gcw + nearest);
        double gch = gridCellHeightFraction * gridModel.getGridCellHeight();
        nearest = gridLocalPosition.getY() > 0.0 ? 0.5 : -0.5;
        int ys = (int)(gridLocalPosition.getY() / gch + nearest);
        double nx = (double)xs * gcw;
        double ny = (double)ys * gch;
        Point2D newPositionInScene = gridLocalVisual.localToScene(nx, ny);
        return new Point(newPositionInScene.getX(), newPositionInScene.getY());
    }
}

