/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.LinkedList;
import java.util.Locale;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.QueryObjectLink;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.internal.AbstractPart;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.report.internal.QueryPart;
import org.eclipse.mat.report.internal.ResultRenderer;
import org.eclipse.mat.util.HTMLUtils;

class PageSnippets {
    private static final String OPENED = "img/opened.gif";
    private static final String CLOSED = "img/closed.gif";
    private static boolean linkToHeading = true;

    PageSnippets() {
    }

    public static void beginPage(AbstractPart part, ResultRenderer.HtmlArtefact artefact, String title, String encoding) {
        String lang = PageSnippets.getLang(part);
        artefact.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        artefact.append("<html").append(lang).append("><head>");
        try {
            encoding = Charset.forName(encoding).name();
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        artefact.append("<meta http-equiv=\"Content-type\" content=\"text/html;charset=" + encoding + "\">");
        artefact.append("<title>").append(HTMLUtils.escapeText(title)).append("</title>");
        artefact.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(artefact.getPathToRoot()).append("styles.css\">");
        artefact.append("<link rel=\"contents\" href=\"").append(artefact.getPathToRoot()).append("toc.html\">");
        artefact.append("<link rel=\"start\" href=\"").append(artefact.getPathToRoot()).append("index.html\">");
        artefact.append("<script src=\"").append(artefact.getPathToRoot()).append("code.js\" type=\"text/javascript\"></script>");
        artefact.append("</head><body onload=\"preparepage();\">");
        artefact.append("<div><input type=\"hidden\" id=\"imageBase\" value=\"").append(artefact.getPathToRoot()).append("img/\" title=\"").append(Messages.PageSnippets_Label_HideUnhide).append("\"></div>");
        artefact.append("<div id=\"header\">");
        artefact.append("<a class=\"sr-only\" href=\"#content\">").append(Messages.PageSnippets_Label_SkipToMainContent).append("</a>");
        artefact.append("<ul>");
        if (part == null) {
            artefact.append("<li>");
            PageSnippets.beginLink(artefact, "index.html");
            artefact.append(Messages.PageSnippets_Label_StartPage);
            PageSnippets.endLink(artefact);
            artefact.append("</li>");
        } else {
            LinkedList<AbstractPart> path = new LinkedList<AbstractPart>();
            AbstractPart tmp = part;
            while (tmp.getParent() != null) {
                AbstractPart parent = tmp.getParent();
                boolean showHeading = parent.params().shallow().getBoolean("html.show_heading", true);
                if (showHeading) {
                    path.addFirst(parent);
                }
                tmp = parent;
            }
            boolean isFirst = true;
            for (AbstractPart p : path) {
                ResultRenderer.HtmlArtefact page = (ResultRenderer.HtmlArtefact)p.getObject("artefact");
                tmp = p;
                while (page == null) {
                    tmp = tmp.getParent();
                    page = (ResultRenderer.HtmlArtefact)tmp.getObject("artefact");
                }
                artefact.append("<li>");
                if (!isFirst) {
                    artefact.append("&raquo; ");
                }
                String targetlang = PageSnippets.getLang(p);
                PageSnippets.link(artefact, String.valueOf(page.getRelativePathName()) + "#" + PageSnippets.id(p), p.spec().getName(), targetlang, targetlang);
                artefact.append("</li>");
                isFirst = false;
            }
            artefact.append("<li>");
            if (!isFirst) {
                artefact.append("&raquo; ");
            }
            String id = "content";
            artefact.append("<a href=\"#" + id + "\">").append(HTMLUtils.escapeText(part.spec().getName())).append("</a></li>");
        }
        artefact.append("</ul></div>\n");
        artefact.append("<div id=\"content\">");
    }

    private static void addCommandLink(AbstractPart part, ResultRenderer.HtmlArtefact artefact) {
        if (part.getCommand() != null) {
            String cmdString = null;
            try {
                cmdString = URLEncoder.encode(part.getCommand(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                cmdString = part.getCommand();
            }
            artefact.append(" <a href=\"").append(QueryObjectLink.forQuery(part.getCommand())).append("\" title=\"").append(Messages.PageSnippets_Label_OpenInMemoryAnalyzer).append(" ").append(cmdString).append("\"><img src=\"").append(artefact.getPathToRoot()).append("img/open.gif\" alt=\"").append("\"></a>");
        }
    }

    public static void endPage(ResultRenderer.HtmlArtefact artefact) {
        artefact.append("<br>");
        artefact.append("</div>");
        artefact.append("<div id=\"footer\" class=\"toc\">");
        PageSnippets.beginLink(artefact, "toc.html");
        artefact.append(Messages.PageSnippets_Label_TableOfContents);
        PageSnippets.endLink(artefact);
        artefact.append("<div class=\"mat\">");
        artefact.append(Messages.PageSnippets_Label_CreatedBy);
        artefact.append("</div>");
        artefact.append("</div>\n");
        artefact.append("</body></html>");
    }

    public static void heading(ResultRenderer.HtmlArtefact artefact, AbstractPart part, int order, boolean isExpandable, boolean forceExpansion) {
        String lang = PageSnippets.getLang(part);
        boolean showHeading = part.params().shallow().getBoolean("html.show_heading", true);
        if (!showHeading) {
            artefact.append("<a").append(lang).append(" id=\"").append(PageSnippets.id(part)).append("\"></a>");
        } else {
            ITestResult.Status status;
            String v = String.valueOf(Math.min(order, 5));
            if (linkToHeading) {
                artefact.append("<h").append(v).append(lang).append(" id=\"").append(PageSnippets.id(part)).append("\">");
            } else {
                artefact.append("<h").append(v).append(lang).append(">");
            }
            if (isExpandable) {
                boolean isExpanded = forceExpansion || !part.params().getBoolean("html.collapsed", false);
                artefact.append("<a href=\"#\" onclick=\"hide(this, '").append(PageSnippets.id("exp", part)).append("'); return false;\" title=\"").append(isExpanded ? Messages.PageSnippets_Label_HideUnhide : Messages.PageSnippets_Label_UnhideHide).append("\"><img src=\"").append(artefact.getPathToRoot()).append(isExpanded ? OPENED : CLOSED).append("\" alt=\"").append("\"></a> ");
            }
            if ((status = PageSnippets.getStatus(part)) != null) {
                artefact.append("<img src=\"").append(artefact.getPathToRoot()).append("img/").append(String.valueOf(status.name().toLowerCase(Locale.ENGLISH)) + ".gif\" alt=\"").append(status.toString()).append("\"> ");
            }
            if (!linkToHeading) {
                artefact.append("<a id=\"").append(PageSnippets.id(part)).append("\">");
            }
            artefact.append(HTMLUtils.escapeText(part.spec().getName()));
            if (!linkToHeading) {
                artefact.append("</a>");
            }
            PageSnippets.addCommandLink(part, artefact);
            artefact.append("</h").append(v).append(">");
        }
    }

    public static void linkedHeading(ResultRenderer.HtmlArtefact artefact, AbstractPart part, int order, String filename) {
        String lang = PageSnippets.getLang(part);
        String v = String.valueOf(order);
        artefact.append("<h").append(v).append(lang).append(" id=\"").append(PageSnippets.id(part)).append("\">");
        ITestResult.Status status = PageSnippets.getStatus(part);
        if (status != null) {
            artefact.append("<img src=\"").append(artefact.getPathToRoot()).append("img/").append(String.valueOf(status.name().toLowerCase(Locale.ENGLISH)) + ".gif\" alt=\"").append(status.toString()).append("\"> ");
        }
        PageSnippets.link(artefact, filename, part.spec().getName());
        PageSnippets.addCommandLink(part, artefact);
        artefact.append("</h").append(v).append(">");
    }

    public static void queryHeading(ResultRenderer.HtmlArtefact artefact, QueryPart query, boolean forceExpansion) {
        String lang = PageSnippets.getLang(query);
        boolean showHeading = query.params().shallow().getBoolean("html.show_heading", true);
        if (!showHeading) {
            artefact.append("<a").append(lang).append(" id=\"").append(PageSnippets.id(query)).append("\"></a>");
        } else {
            if (linkToHeading) {
                artefact.append("<h5").append(lang).append(" id=\"").append(PageSnippets.id(query)).append("\"");
            } else {
                artefact.append("<h5").append(lang);
            }
            boolean isImportant = query.params().shallow().getBoolean("html.is_important", false);
            if (isImportant) {
                artefact.append(" class=\"important\"");
            }
            artefact.append(">");
            boolean isExpanded = forceExpansion || !query.params().getBoolean("html.collapsed", false);
            artefact.append("<a href=\"#\" onclick=\"hide(this, '").append(PageSnippets.id("exp", query)).append("'); return false;\" title=\"").append(isExpanded ? Messages.PageSnippets_Label_HideUnhide : Messages.PageSnippets_Label_UnhideHide).append("\"><img src=\"").append(artefact.getPathToRoot()).append(isExpanded ? OPENED : CLOSED).append("\" alt=\"").append("\"></a> ");
            if (query.getStatus() != null) {
                artefact.append("<img src=\"").append(artefact.getPathToRoot()).append("img/").append(String.valueOf(query.getStatus().name().toLowerCase(Locale.ENGLISH)) + ".gif\" alt=\"").append(query.getStatus().toString()).append("\"> ");
            }
            if (!linkToHeading) {
                artefact.append("<a id=\"").append(PageSnippets.id(query)).append("\">");
            }
            artefact.append(HTMLUtils.escapeText(query.spec().getName()));
            if (!linkToHeading) {
                artefact.append("</a>");
            }
            PageSnippets.addCommandLink(query, artefact);
            artefact.append("</h5>");
        }
    }

    public static void link(ResultRenderer.HtmlArtefact artefact, String target, String label) {
        PageSnippets.link(artefact, target, label, "", "");
    }

    static void link(ResultRenderer.HtmlArtefact artefact, String target, String label, String linklang, String targetlang) {
        PageSnippets.beginLink(artefact, target, linklang, targetlang);
        artefact.append(HTMLUtils.escapeText(label));
        PageSnippets.endLink(artefact);
    }

    public static void beginLink(ResultRenderer.HtmlArtefact artefact, String target) {
        PageSnippets.beginLink(artefact, target, "", "");
    }

    public static void beginLink(ResultRenderer.HtmlArtefact artefact, String target, AbstractPart part) {
        String lang = PageSnippets.getLang(part);
        PageSnippets.beginLink(artefact, String.valueOf(target) + "#" + PageSnippets.id(part), lang, lang);
    }

    static void beginLink(ResultRenderer.HtmlArtefact artefact, String target, String linklang, String targetlang) {
        targetlang = targetlang.replaceFirst("^ lang=", " hreflang=");
        artefact.append("<a").append(linklang).append(targetlang).append(" href=\"").append(artefact.getPathToRoot()).append(target).append("\">");
    }

    public static void endLink(ResultRenderer.HtmlArtefact artefact) {
        artefact.append("</a>");
    }

    public static void beginExpandableDiv(ResultRenderer.HtmlArtefact artefact, AbstractPart part, boolean forceExpanded) {
        String lang = PageSnippets.getLang(part, true);
        artefact.append("<div").append(lang).append(" id=\"").append(PageSnippets.id("exp", part)).append("\"");
        if (!forceExpanded && part.params().getBoolean("html.collapsed", false)) {
            artefact.append(" style=\"display:none\"");
        }
        artefact.append(">");
    }

    public static void endDiv(ResultRenderer.HtmlArtefact artefact) {
        artefact.append("</div>");
    }

    static String getLang(AbstractPart part) {
        return PageSnippets.getLang(part, false);
    }

    static String getLang(AbstractPart part, boolean usePart) {
        String lang;
        if (part == null) {
            return "";
        }
        String string = lang = usePart ? part.params().get("lang") : part.spec().getParams().get("lang");
        if (lang == null) {
            return "";
        }
        AbstractPart parent = part.getParent();
        if (parent != null && part.getDataFile().getUrl().equals(parent.getDataFile().getUrl())) {
            String langp = parent.params().get("lang");
            if (lang.equals(langp)) {
                return "";
            }
            if (langp == null && lang.isEmpty()) {
                return "";
            }
        }
        return " lang=\"" + lang + "\"";
    }

    private static String id(String prefix, AbstractPart part) {
        return String.valueOf(prefix) + part.getId();
    }

    private static String id(AbstractPart part) {
        return PageSnippets.id("i", part);
    }

    private static ITestResult.Status getStatus(AbstractPart part) {
        ITestResult.Status status = part.getStatus();
        Spec s = part.spec();
        if (s instanceof SectionSpec) {
            status = ITestResult.Status.max(status, ((SectionSpec)s).getStatus());
        } else if (s instanceof QuerySpec) {
            IResult result = ((QuerySpec)s).getResult();
            if (result instanceof ITestResult) {
                status = ITestResult.Status.max(status, ((ITestResult)((Object)result)).getStatus());
            }
            if (result instanceof CompositeResult) {
                status = ITestResult.Status.max(status, ((CompositeResult)result).getStatus());
            }
        }
        for (AbstractPart child : part.getChildren()) {
            ITestResult.Status status2 = PageSnippets.getStatus(child);
            status = ITestResult.Status.max(status, status2);
        }
        return status;
    }
}

