/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.stepFilter;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.preferences.stepFilter.PHPResourceSelectionGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PHPResourceSelectionDialog
extends SelectionDialog {
    private static final String EMPTY_STRING = "";
    PHPResourceSelectionGroup group;
    private IContainer initialSelection;
    private boolean allowNewContainerName = true;
    Label statusMessage;
    ISelectionValidator validator;
    private boolean showClosedProjects = true;

    public PHPResourceSelectionDialog(Shell parentShell, IContainer initialRoot, boolean allowNewContainerName, String message) {
        super(parentShell);
        this.setTitle(PHPDebugUIMessages.PHPResourceSelectionDialog_selectResource);
        this.initialSelection = initialRoot;
        this.allowNewContainerName = allowNewContainerName;
        if (message != null) {
            this.setMessage(message);
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.container_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (PHPResourceSelectionDialog.this.statusMessage != null && PHPResourceSelectionDialog.this.validator != null) {
                    String errorMsg = PHPResourceSelectionDialog.this.validator.isValid((Object)PHPResourceSelectionDialog.this.group.getPathForSelectedResource());
                    if (errorMsg == null || errorMsg.equals(PHPResourceSelectionDialog.EMPTY_STRING)) {
                        PHPResourceSelectionDialog.this.statusMessage.setText(PHPResourceSelectionDialog.EMPTY_STRING);
                        PHPResourceSelectionDialog.this.getOkButton().setEnabled(true);
                    } else {
                        PHPResourceSelectionDialog.this.statusMessage.setText(errorMsg);
                        PHPResourceSelectionDialog.this.getOkButton().setEnabled(false);
                    }
                }
            }
        };
        this.group = new PHPResourceSelectionGroup(area, listener, this.allowNewContainerName, this.getMessage(), this.showClosedProjects);
        if (this.initialSelection != null) {
            this.group.setSelectedResource((IResource)this.initialSelection);
        }
        this.statusMessage = new Label(area, 64);
        this.statusMessage.setLayoutData((Object)new GridData(768));
        this.statusMessage.setText(" \n ");
        this.statusMessage.setFont(parent.getFont());
        return this.dialogArea;
    }

    protected void okPressed() {
        ArrayList<Object> chosenResourcesList = new ArrayList<Object>();
        Object selection = ((TreeSelection)this.group.treeViewer.getSelection()).getFirstElement();
        if (selection != null) {
            chosenResourcesList.add(selection);
        }
        this.setResult(chosenResourcesList);
        super.okPressed();
    }

    public void setValidator(ISelectionValidator validator) {
        this.validator = validator;
    }

    public void showClosedProjects(boolean show) {
        this.showClosedProjects = show;
    }
}

