/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionArea;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;

public class TagSelectionDialog
extends TrayDialog
implements IPropertyChangeListener {
    private TagSelectionArea tagSelectionArea;
    public static final int INCLUDE_HEAD_TAG = 1;
    public static final int INCLUDE_BASE_TAG = 2;
    public static final int INCLUDE_BRANCHES = 4;
    public static final int INCLUDE_VERSIONS = 8;
    public static final int INCLUDE_DATES = 16;
    public static final int INCLUDE_ALL_TAGS = 31;
    private Button okButton;
    private String title;
    private boolean recurse = true;
    private static final int SIZING_DIALOG_WIDTH = 90;
    private static final int SIZING_DIALOG_HEIGHT = 25;
    private CVSTag selection;
    private TagSource tagSource;
    private String message;
    private int includeFlags;
    private String helpContext;
    private boolean showRecurse;

    public static CVSTag getTagToCompareWith(Shell shell, TagSource tagSource, int includeFlags) {
        TagSelectionDialog dialog = new TagSelectionDialog(shell, tagSource, CVSUIMessages.CompareWithTagAction_message, CVSUIMessages.TagSelectionDialog_Select_a_Tag_1, includeFlags, false, "org.eclipse.team.cvs.ui.compare_tag_selection_dialog_context");
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 1) {
            return null;
        }
        return dialog.getResult();
    }

    public TagSelectionDialog(Shell parentShell, TagSource tagSource, String title, String message, int includeFlags, boolean showRecurse, String helpContext) {
        super(parentShell);
        this.tagSource = tagSource;
        this.message = message;
        this.includeFlags = includeFlags;
        this.helpContext = helpContext;
        this.showRecurse = showRecurse;
        this.title = title;
        this.setShellStyle(67696);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x = this.convertWidthInCharsToPixels(90);
        size.y = this.convertHeightInCharsToPixels(25);
        return size;
    }

    public void create() {
        super.create();
        this.initialize();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        TagSelectionDialog.applyDialogFont((Control)parent);
        this.initializeDialogUnits((Control)parent);
        Composite top = (Composite)super.createDialogArea(parent);
        this.tagSelectionArea = new TagSelectionArea(this.getShell(), this.tagSource, this.includeFlags, this.helpContext){

            @Override
            protected void createCustomArea(Composite parent) {
                if (TagSelectionDialog.this.showRecurse) {
                    Button recurseCheck = new Button(parent, 32);
                    recurseCheck.setText(CVSUIMessages.TagSelectionDialog_recurseOption);
                    recurseCheck.addListener(13, event -> {
                        boolean bl = TagSelectionDialog.this.recurse = recurseCheck.getSelection();
                    });
                    recurseCheck.setSelection(true);
                }
            }
        };
        if (this.message != null) {
            this.tagSelectionArea.setTagAreaLabel(this.message);
        }
        this.tagSelectionArea.addPropertyChangeListener(this);
        this.tagSelectionArea.createArea(top);
        this.tagSelectionArea.setRunnableContext(this.getRunnableContext());
        Label seperator = new Label(top, 258);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        seperator.setLayoutData((Object)data);
        this.updateEnablement();
        TagSelectionDialog.applyDialogFont((Control)parent);
        return top;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public CVSTag getResult() {
        return this.selection;
    }

    public boolean getRecursive() {
        return this.recurse;
    }

    protected void initialize() {
        this.okButton.setEnabled(false);
        if (CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_auto_refresh_tags_in_tag_selection_dialog")) {
            this.tagSelectionArea.refreshTagList();
        }
    }

    protected void updateEnablement() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.selection != null);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("selectedTag")) {
            this.selection = (CVSTag)event.getNewValue();
            this.updateEnablement();
        } else if (property.equals("openSelectedTag")) {
            this.okPressed();
        }
    }

    private IRunnableContext getRunnableContext() {
        return (fork, cancelable, runnable) -> {
            Job refreshJob = new Job(CVSUIMessages.TagSelectionDialog_7){

                protected IStatus run(IProgressMonitor monitor) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        try {
                            TagSelectionDialog.this.setBusy(true);
                            runnable.run(monitor);
                        }
                        catch (InvocationTargetException e) {
                            CVSStatus cVSStatus = new CVSStatus(4, CVSUIMessages.TagSelectionDialog_8, (Throwable)e);
                            TagSelectionDialog.this.setBusy(false);
                            return cVSStatus;
                        }
                        catch (InterruptedException e) {
                            CVSStatus cVSStatus = new CVSStatus(4, CVSUIMessages.TagSelectionDialog_8, (Throwable)e);
                            TagSelectionDialog.this.setBusy(false);
                            return cVSStatus;
                        }
                    }
                    finally {
                        TagSelectionDialog.this.setBusy(false);
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            refreshJob.setUser(false);
            refreshJob.setPriority(50);
            this.getShell().addDisposeListener(e -> {
                boolean bl = refreshJob.cancel();
            });
            refreshJob.schedule();
        };
    }

    private void setBusy(boolean busy) {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(() -> {
                if (!shell.isDisposed()) {
                    Cursor cursor = null;
                    if (busy) {
                        cursor = shell.getDisplay().getSystemCursor(3);
                    }
                    shell.setCursor(cursor);
                }
            });
        }
    }
}

