/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.single;

import java.util.Collection;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.single.DiscriminatorDispatcherNode;
import org.eclipse.viatra.query.runtime.rete.single.SingleInputNode;

public class DiscriminatorBucketNode
extends SingleInputNode {
    private Object bucketKey;

    public DiscriminatorBucketNode(ReteContainer reteContainer, Object bucketKey) {
        super(reteContainer);
        this.bucketKey = reteContainer.getNetwork().getEngine().getRuntimeContext().wrapElement(bucketKey);
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        if (this.parent != null) {
            this.getDispatcher().pullIntoFiltered(collector, this.bucketKey, flush);
        }
    }

    @Override
    public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
        if (this.parent != null) {
            this.getDispatcher().pullIntoWithTimestampFiltered(collector, this.bucketKey, flush);
        }
    }

    @Override
    public void update(Direction direction, Tuple updateElement, Timestamp timestamp) {
        this.propagateUpdate(direction, updateElement, timestamp);
    }

    public Object getBucketKey() {
        return this.bucketKey;
    }

    @Override
    public void appendParent(Supplier supplier) {
        if (!(supplier instanceof DiscriminatorDispatcherNode)) {
            throw new IllegalArgumentException();
        }
        super.appendParent(supplier);
    }

    public DiscriminatorDispatcherNode getDispatcher() {
        return (DiscriminatorDispatcherNode)this.parent;
    }

    @Override
    protected String toStringCore() {
        return String.format("%s<%s=='%s'>", super.toStringCore(), this.getDispatcher() == null ? "?" : Integer.valueOf(this.getDispatcher().getDiscriminationColumnIndex()), this.bucketKey);
    }
}

