/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.utils.Messages;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImageDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImageInfo;

public final class FileImagePage
extends AbstractImagePage {
    public static final String ID = "FILE";
    private final Map<String, ImageInfo> m_pathToImageInfo = Maps.newTreeMap();
    private final Text m_pathText;

    public FileImagePage(Composite parent, int style, AbstractImageDialog imageDialog) {
        super(parent, style, imageDialog);
        GridLayoutFactory.create((Composite)this).columns(2);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                for (ImageInfo imageInfo : FileImagePage.this.m_pathToImageInfo.values()) {
                    imageInfo.getImage().dispose();
                }
            }
        });
        this.m_pathText = new Text((Composite)this, 2048);
        GridDataFactory.create((Control)this.m_pathText).grabH().hintHC(50).fillH();
        this.m_pathText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FileImagePage.this.updateImageInfo();
            }
        });
        Button button = new Button((Composite)this, 0);
        GridDataFactory.create((Control)button).hintHU(61).fill();
        button.setText(Messages.FileImagePage_browseButton);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog fileDialog = new FileDialog(FileImagePage.this.getShell(), 4096);
                fileDialog.setFilterPath(FileImagePage.this.m_pathText.getText());
                String newPath = fileDialog.open();
                if (newPath != null) {
                    FileImagePage.this.m_pathText.setText(newPath);
                }
            }
        });
    }

    private void updateImageInfo() {
        File file;
        String path = this.m_pathText.getText();
        ImageInfo imageInfo = this.m_pathToImageInfo.get(path);
        if (imageInfo == null && (file = new File(path)).exists() && !file.isDirectory()) {
            Image image;
            try {
                FileInputStream is = new FileInputStream(file);
                try {
                    image = new Image((Device)this.getDisplay(), (InputStream)is);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            catch (Throwable e) {
                this.m_imageDialog.setResultImageInfo(null);
                return;
            }
            imageInfo = new ImageInfo(ID, path, image, file.length());
            this.m_pathToImageInfo.put(path, imageInfo);
        }
        this.m_imageDialog.setResultImageInfo(imageInfo);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getTitle() {
        return Messages.FileImagePage_title;
    }

    @Override
    public void activate() {
        this.updateImageInfo();
    }

    @Override
    public void setInput(Object data) {
        String path = (String)data;
        this.m_pathText.setText(path);
    }
}

