import { BasePathTransformer } from './basePathTransformer';
import { ILaunchRequestArgs, IAttachRequestArgs, IStackTraceResponseBody } from '../debugAdapterInterfaces';
import { DebugProtocol } from 'vscode-debugprotocol';
/**
 * Converts a local path from Code to a path on the target.
 */
export declare class UrlPathTransformer extends BasePathTransformer {
    private _pathMapping;
    private _clientPathToTargetUrl;
    private _targetUrlToClientPath;
    launch(args: ILaunchRequestArgs): Promise<void>;
    attach(args: IAttachRequestArgs): Promise<void>;
    setBreakpoints(source: DebugProtocol.Source): DebugProtocol.Source;
    clearTargetContext(): void;
    scriptParsed(scriptUrl: string): Promise<string>;
    stackTraceResponse(response: IStackTraceResponseBody): Promise<void>;
    fixSource(source: DebugProtocol.Source): Promise<void>;
    getTargetPathFromClientPath(clientPath: string): string;
    getClientPathFromTargetPath(targetPath: string): string;
    /**
     * Overridable for VS to ask Client to resolve path
     */
    protected targetUrlToClientPath(scriptUrl: string): Promise<string>;
}
