"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const settingsHandlers_1 = require("../src/languageserver/handlers/settingsHandlers");
const sinon = require("sinon");
const chai = require("chai");
const sinonChai = require("sinon-chai");
const yamlSettings_1 = require("../src/yamlSettings");
const validationHandlers_1 = require("../src/languageserver/handlers/validationHandlers");
const request = require("request-light");
const expect = chai.expect;
chai.use(sinonChai);
describe('Settings Handlers Tests', () => {
    const sandbox = sinon.createSandbox();
    let connectionStub;
    let languageService;
    let settingsState;
    let validationHandler;
    let xhrStub;
    beforeEach(() => {
        connectionStub = sandbox.mock();
        languageService = sandbox.mock();
        settingsState = new yamlSettings_1.SettingsState();
        validationHandler = sandbox.mock(validationHandlers_1.ValidationHandler);
        xhrStub = sandbox.stub(request, 'xhr');
    });
    afterEach(() => {
        sandbox.restore();
    });
    it('SettingsHandler should modify file match patters', () => __awaiter(void 0, void 0, void 0, function* () {
        xhrStub.resolves({
            responseText: `{"schemas": [
      {
        "name": ".adonisrc.json",
        "description": "AdonisJS configuration file",
        "fileMatch": [
          ".adonisrc.yaml"
        ],
        "url": "https://raw.githubusercontent.com/adonisjs/application/master/adonisrc.schema.json"
      }]}`,
        });
        const settingsHandler = new settingsHandlers_1.SettingsHandler(connectionStub, languageService, settingsState, validationHandler);
        sandbox.stub(settingsHandler, 'updateConfiguration').returns();
        yield settingsHandler.setSchemaStoreSettingsIfNotSet();
        expect(settingsState.schemaStoreSettings).deep.include({
            uri: 'https://raw.githubusercontent.com/adonisjs/application/master/adonisrc.schema.json',
            fileMatch: ['/.adonisrc.yaml'],
        });
    }));
});
//# sourceMappingURL=settingsHandlers.test.js.map