/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.CompoundKey;
import java.sql.Timestamp;

public final class PatchSetApproval {
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected short value;
    @Column(id=3)
    protected Timestamp granted;
    @Column(id=4)
    protected boolean changeOpen;
    @Column(id=5, length=16, notNull=false)
    protected String changeSortKey;

    protected PatchSetApproval() {
    }

    public PatchSetApproval(Key k, short v) {
        this.key = k;
        this.changeOpen = true;
        this.setValue(v);
        this.setGranted();
    }

    public PatchSetApproval(PatchSet.Id psId, PatchSetApproval src) {
        this.key = new Key(psId, src.getAccountId(), src.getCategoryId());
        this.changeOpen = true;
        this.value = src.getValue();
        this.granted = src.granted;
    }

    public Key getKey() {
        return this.key;
    }

    public PatchSet.Id getPatchSetId() {
        return this.key.patchSetId;
    }

    public Account.Id getAccountId() {
        return this.key.accountId;
    }

    public ApprovalCategory.Id getCategoryId() {
        return this.key.categoryId;
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short v) {
        this.value = v;
    }

    public Timestamp getGranted() {
        return this.granted;
    }

    public void setGranted() {
        this.granted = new Timestamp(System.currentTimeMillis());
    }

    public void cache(Change c) {
        this.changeOpen = c.open;
        this.changeSortKey = c.sortKey;
    }

    public static class Key
    extends CompoundKey<PatchSet.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, name="--NONE--")
        protected PatchSet.Id patchSetId;
        @Column(id=2)
        protected Account.Id accountId;
        @Column(id=3)
        protected ApprovalCategory.Id categoryId;

        protected Key() {
            this.patchSetId = new PatchSet.Id();
            this.accountId = new Account.Id();
            this.categoryId = new ApprovalCategory.Id();
        }

        public Key(PatchSet.Id ps, Account.Id a, ApprovalCategory.Id c) {
            this.patchSetId = ps;
            this.accountId = a;
            this.categoryId = c;
        }

        public PatchSet.Id getParentKey() {
            return this.patchSetId;
        }

        public com.google.gwtorm.client.Key<?>[] members() {
            return new com.google.gwtorm.client.Key[]{this.accountId, this.categoryId};
        }
    }
}

