/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.utils;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.eclipse.acceleo.common.utils.Deque;

public final class CircularArrayDeque<E>
extends AbstractList<E>
implements Deque<E>,
Externalizable,
RandomAccess {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final long serialVersionUID = 5259962911151126606L;
    transient E[] data;
    transient int head;
    transient int tail;

    public CircularArrayDeque() {
        this.data = new Object[16];
    }

    public CircularArrayDeque(Collection<? extends E> collection) {
        this.initialize(collection.size());
        this.addAll(collection);
    }

    public CircularArrayDeque(int elementCount) {
        this.initialize(elementCount);
    }

    private static int getNextPowerOfTwo(int number) {
        int pow3 = 8;
        int pow4 = 16;
        int powerOfTwo = number - 1;
        powerOfTwo |= powerOfTwo >> 1;
        powerOfTwo |= powerOfTwo >> 2;
        powerOfTwo |= powerOfTwo >> 4;
        powerOfTwo |= powerOfTwo >> 8;
        powerOfTwo |= powerOfTwo >> 16;
        return ++powerOfTwo;
    }

    @Override
    public boolean add(E element) {
        this.addLast(element);
        return true;
    }

    @Override
    public void add(int index, E element) {
        int size = this.size();
        if (index == 0) {
            this.addFirst(element);
        } else if (index == size) {
            this.addLast(element);
        } else {
            int insertionIndex;
            if (index < 0 || index > size) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            int mask = this.data.length - 1;
            if (index > size / 2) {
                insertionIndex = this.head + index & mask;
                int i = this.tail;
                while (i != insertionIndex) {
                    this.data[i] = this.data[i - 1 & mask];
                    i = i - 1 & mask;
                }
                this.tail = this.tail + 1 & mask;
            } else {
                this.head = this.head - 1 & mask;
                insertionIndex = this.head + index & mask;
                int i = this.head;
                while (i != insertionIndex) {
                    this.data[i] = this.data[i + 1 & mask];
                    i = i + 1 & mask;
                }
            }
            this.data[insertionIndex] = element;
            ++this.modCount;
            if (this.head == this.tail) {
                this.doubleCapacity();
            }
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        for (E element : collection) {
            this.addLast(element);
        }
        return !collection.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        int size = this.size();
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        if (collection.isEmpty()) {
            return false;
        }
        this.ensureCapacity(size + collection.size());
        if (index == 0) {
            Object[] newValues = new Object[collection.size()];
            newValues = collection.toArray(newValues);
            int i = newValues.length - 1;
            while (i >= 0) {
                this.addFirst(newValues[i]);
                --i;
            }
        } else if (index == size) {
            Iterator<E> iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addLast(iterator.next());
            }
        } else {
            int i;
            int insertionIndex;
            int mask = this.data.length - 1;
            if (index > size / 2) {
                insertionIndex = this.head + index & mask;
                i = this.tail = this.tail + collection.size() & mask;
                while (i != (insertionIndex + collection.size() & mask)) {
                    this.data[i - 1 & mask] = this.data[i - 1 - collection.size() & mask];
                    i = i - 1 & mask;
                }
            } else {
                this.head = this.head - collection.size() & mask;
                insertionIndex = this.head + index & mask;
                i = this.head;
                while (i != insertionIndex) {
                    this.data[i] = this.data[i + collection.size() & mask];
                    i = i + 1 & mask;
                }
            }
            Iterator<E> iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.data[insertionIndex] = iterator.next();
                ++this.modCount;
                insertionIndex = insertionIndex + 1 & mask;
            }
        }
        return true;
    }

    @Override
    public void addFirst(E element) {
        this.head = this.head - 1 & this.data.length - 1;
        this.data[this.head] = element;
        ++this.modCount;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    @Override
    public void addLast(E element) {
        this.data[this.tail] = element;
        ++this.modCount;
        this.tail = this.tail + 1 & this.data.length - 1;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        int mask = this.data.length - 1;
        int i = this.head;
        while (i != this.tail) {
            this.data[i] = null;
            i = i + 1 & mask;
        }
        this.head = 0;
        this.tail = 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.data[this.head + index & this.data.length - 1];
    }

    @Override
    public E getFirst() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        return this.data[this.head];
    }

    @Override
    public E getLast() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        return this.data[this.tail - 1 & this.data.length - 1];
    }

    @Override
    public int indexOf(Object o) {
        int result = -1;
        int mask = this.data.length - 1;
        if (o == null) {
            int i = this.head;
            while (i != this.tail) {
                if (this.data[i] == null) {
                    result = i - this.head & mask;
                    break;
                }
                i = i + 1 & mask;
            }
        } else {
            int i = this.head;
            while (i != this.tail) {
                if (o.equals(this.data[i])) {
                    result = i - this.head & mask;
                    break;
                }
                i = i + 1 & mask;
            }
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new DequeIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        int result = -1;
        int mask = this.data.length - 1;
        int start = this.tail - 1 & mask;
        int end = this.head - 1 & mask;
        if (o == null) {
            int i = start;
            while (i != end) {
                if (this.data[i] == null) {
                    result = i - this.head & mask;
                    break;
                }
                i = i - 1 & mask;
            }
        } else {
            int i = start;
            while (i != end) {
                if (o.equals(this.data[i])) {
                    result = i - this.head & mask;
                    break;
                }
                i = i - 1 & mask;
            }
        }
        return result;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new DequeListIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return new DequeListIterator(index);
    }

    @Override
    public boolean offer(E element) {
        this.addLast(element);
        return true;
    }

    @Override
    public void offerAll(Collection<? extends E> collection) {
        this.addAll(collection);
    }

    @Override
    public void offerFirst(E element) {
        this.addFirst(element);
    }

    @Override
    public void offerLast(E element) {
        this.addLast(element);
    }

    @Override
    public E peek() {
        if (this.head == this.tail) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    public E peekFirst() {
        return this.getFirst();
    }

    @Override
    public E peekLast() {
        return this.getLast();
    }

    @Override
    public E poll() {
        if (this.head == this.tail) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    public E pop() {
        return this.removeLast();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.initialize(size);
        this.head = 0;
        this.tail = size;
        int i = 0;
        while (i < size) {
            this.data[i] = in.readObject();
            ++i;
        }
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        int actualIndex = this.head + index & this.data.length - 1;
        E old = this.data[actualIndex];
        this.deleteIndex(actualIndex);
        return old;
    }

    @Override
    public boolean remove(Object element) {
        int mask = this.data.length - 1;
        boolean result = false;
        if (element == null) {
            int i = this.head;
            while (i != this.tail) {
                if (this.data[i] == null) {
                    this.deleteIndex(i);
                    result = true;
                    break;
                }
                i = i + 1 & mask;
            }
        } else {
            int i = this.head;
            while (i != this.tail) {
                if (element.equals(this.data[i])) {
                    this.deleteIndex(i);
                    result = true;
                    break;
                }
                i = i + 1 & mask;
            }
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int mask = this.data.length - 1;
        boolean result = false;
        int[] indices = new int[collection.size()];
        int cursor = 0;
        block0: for (Object element : collection) {
            int i;
            if (element == null) {
                i = this.head;
                while (i != this.tail) {
                    if (this.data[i] == null) {
                        indices[cursor++] = i;
                        continue block0;
                    }
                    i = i + 1 & mask;
                }
                continue;
            }
            i = this.head;
            while (i != this.tail) {
                if (element.equals(this.data[i])) {
                    indices[cursor++] = i;
                    continue block0;
                }
                i = i + 1 & mask;
            }
        }
        if (cursor > 0) {
            result = true;
            if (indices.length == 1) {
                this.deleteIndex(indices[0]);
            } else {
                this.delete(indices);
            }
        }
        return result;
    }

    @Override
    public E removeFirst() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        int mask = this.data.length - 1;
        E result = this.data[this.head];
        this.data[this.head] = null;
        ++this.modCount;
        this.head = this.head + 1 & mask;
        return result;
    }

    @Override
    public E removeLast() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        this.tail = this.tail - 1 & this.data.length - 1;
        E result = this.data[this.tail];
        this.data[this.tail] = null;
        ++this.modCount;
        return result;
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        int actualIndex = this.head + index & this.data.length - 1;
        E old = this.data[actualIndex];
        this.data[actualIndex] = element;
        return old;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.data.length - 1;
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (this.head < this.tail) {
            System.arraycopy(this.data, this.head, result, 0, size);
        } else if (this.head != this.tail) {
            int headLength = this.data.length - this.head;
            System.arraycopy(this.data, this.head, result, 0, headLength);
            System.arraycopy(this.data, 0, result, headLength, this.tail);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        Object[] temp = a.length > size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        if (this.head < this.tail) {
            System.arraycopy(this.data, this.head, temp, 0, size);
        } else if (this.head != this.tail) {
            int headLength = this.data.length - this.head;
            System.arraycopy(this.data, this.head, temp, 0, headLength);
            System.arraycopy(this.data, 0, temp, headLength, this.tail);
        }
        return temp;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int mask = this.data.length - 1;
        out.writeInt(this.size());
        int i = this.head;
        while (i != this.tail) {
            out.writeObject(this.data[i]);
            i = i + 1 & mask;
        }
    }

    private void delete(int[] indices) {
        int mask = this.data.length - 1;
        int cursor = 0;
        while (cursor < indices.length && (this.tail - indices[cursor] & mask) > (indices[cursor] - this.head & mask)) {
            ++cursor;
        }
        int median = cursor;
        if (median > 0) {
            this.deleteRightRotate(median - 1, indices);
        }
        if (median < indices.length) {
            this.deleteLeftRotate(median, indices);
        }
    }

    private void deleteIndex(int index) {
        int mask = this.data.length - 1;
        if (index == this.head) {
            this.removeFirst();
        } else if (index == (this.tail - 1 & mask)) {
            this.removeLast();
        } else {
            int elementsAhead = this.tail - index & mask;
            int elementsBehind = index - this.head & mask;
            if (elementsAhead > elementsBehind) {
                if (this.head < index) {
                    ++this.modCount;
                    System.arraycopy(this.data, this.head, this.data, this.head + 1, elementsBehind);
                    this.data[this.head] = null;
                    ++this.head;
                } else {
                    ++this.modCount;
                    System.arraycopy(this.data, 0, this.data, 1, index);
                    this.data[0] = this.data[mask];
                    System.arraycopy(this.data, this.head, this.data, this.head + 1, mask - this.head);
                    this.data[this.head] = null;
                    this.head = this.head + 1 & mask;
                }
            } else if (index < this.tail) {
                ++this.modCount;
                System.arraycopy(this.data, index + 1, this.data, index, elementsAhead);
                --this.tail;
            } else {
                ++this.modCount;
                System.arraycopy(this.data, index + 1, this.data, index, mask - index);
                this.data[mask] = this.data[0];
                System.arraycopy(this.data, 1, this.data, 0, this.tail);
                this.tail = this.tail - 1 & mask;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void deleteLeftRotate(int startIndex, int[] indices) {
        block6: {
            block5: {
                mask = this.data.length - 1;
                cursor = indices.length - 1;
                while (cursor >= startIndex && indices[cursor] == (this.tail - 1 & mask)) {
                    this.removeLast();
                    --cursor;
                }
                if (cursor != startIndex) break block5;
                ++this.modCount;
                this.tail = this.tail - 1 & mask;
                i = indices[startIndex];
                while (i != this.tail) {
                    this.data[i] = this.data[i + 1 & mask];
                    i = i + 1 & mask;
                }
                this.data[this.tail] = null;
                break block6;
            }
            if (cursor <= startIndex) break block6;
            this.tail = this.tail - 1 & mask;
            gap = 1;
            fence = cursor;
            cursor = startIndex + 1;
            i = indices[startIndex];
            ** GOTO lbl32
            {
                ++cursor;
                ++gap;
                do {
                    if (cursor <= fence && (i + gap & mask) == indices[cursor]) continue block2;
                    this.data[i] = this.data[i + gap & mask];
                    i = i + 1 & mask;
lbl32:
                    // 2 sources

                } while (i != this.tail);
            }
            oldTail = this.tail;
            this.tail = this.tail - (gap - 1) & mask;
            i = oldTail;
            while (i != this.tail) {
                this.data[i] = null;
                ++this.modCount;
                i = i - 1 & mask;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void deleteRightRotate(int startIndex, int[] indices) {
        block6: {
            block5: {
                mask = this.data.length - 1;
                cursor = 0;
                while (cursor <= startIndex && indices[cursor] == this.head) {
                    this.removeFirst();
                    ++cursor;
                }
                if (cursor != startIndex) break block5;
                ++this.modCount;
                i = indices[startIndex];
                while (i != this.head) {
                    this.data[i] = this.data[i - 1 & mask];
                    i = i - 1 & mask;
                }
                this.data[this.head] = null;
                this.head = this.head - 1 & mask;
                break block6;
            }
            if (cursor >= startIndex) break block6;
            gap = 1;
            fence = cursor;
            cursor = startIndex - 1;
            i = indices[startIndex];
            ** GOTO lbl31
            {
                --cursor;
                ++gap;
                do {
                    if (cursor >= fence && (i - gap & mask) == indices[cursor]) continue block2;
                    this.data[i] = this.data[i - gap & mask];
                    i = i - 1 & mask;
lbl31:
                    // 2 sources

                } while (i != this.head);
            }
            oldHead = this.head;
            this.head = this.head + gap & mask;
            i = oldHead;
            while (i != this.head) {
                this.data[i] = null;
                ++this.modCount;
                i = i + 1 & mask;
            }
        }
    }

    private void doubleCapacity() {
        int newCapacity = this.data.length << 1;
        if (newCapacity < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setCapacity(newCapacity);
    }

    private void ensureCapacity(int elementCount) {
        if (elementCount >= this.data.length) {
            int newCapacity = CircularArrayDeque.getNextPowerOfTwo(elementCount);
            if (newCapacity < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.setCapacity(newCapacity);
        }
    }

    private void initialize(int elementCount) {
        int initialCapacity = elementCount <= 1 ? 4 : CircularArrayDeque.getNextPowerOfTwo(elementCount);
        if (initialCapacity < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.data = new Object[initialCapacity];
    }

    private void rangeCheck(int index) throws IndexOutOfBoundsException {
        if (this.head == this.tail || index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
    }

    private void setCapacity(int newCapacity) {
        int newTail = this.head == this.tail ? this.data.length : this.size();
        Object[] temp = new Object[newCapacity];
        int headLength = this.data.length - this.head;
        System.arraycopy(this.data, this.head, temp, 0, headLength);
        System.arraycopy(this.data, 0, temp, headLength, this.head);
        this.data = temp;
        this.head = 0;
        this.tail = newTail;
    }

    private class DequeIterator
    implements Iterator<E> {
        protected int expectedModCount;
        protected int lastReturned;
        protected int next;

        DequeIterator() {
            this.expectedModCount = CircularArrayDeque.this.modCount;
            this.lastReturned = -1;
            this.next = CircularArrayDeque.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.next != CircularArrayDeque.this.tail;
        }

        @Override
        public E next() {
            this.checkComodification();
            if (this.next == CircularArrayDeque.this.tail) {
                throw new NoSuchElementException();
            }
            Object result = CircularArrayDeque.this.data[this.next];
            this.lastReturned = this.next;
            this.next = this.next + 1 & CircularArrayDeque.this.data.length - 1;
            return result;
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.checkComodification();
            boolean increment = this.next == CircularArrayDeque.this.head;
            int deletionIndex = this.lastReturned - CircularArrayDeque.this.head & CircularArrayDeque.this.data.length - 1;
            CircularArrayDeque.this.remove(deletionIndex);
            ++this.expectedModCount;
            int mask = CircularArrayDeque.this.data.length - 1;
            if (increment) {
                this.next = this.next + 1 & mask;
            } else if (deletionIndex >= CircularArrayDeque.this.size() / 2 && CircularArrayDeque.this.size() > 1) {
                this.next = this.next - 1 & mask;
            }
            this.lastReturned = -1;
        }

        protected void checkComodification() throws ConcurrentModificationException {
            if (this.expectedModCount != CircularArrayDeque.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class DequeListIterator
    extends DequeIterator
    implements ListIterator<E> {
        DequeListIterator(int index) {
            this.next = CircularArrayDeque.this.head + index & CircularArrayDeque.this.data.length - 1;
        }

        @Override
        public void add(E element) {
            this.checkComodification();
            boolean increment = this.next != CircularArrayDeque.this.head;
            CircularArrayDeque.this.add(this.next - CircularArrayDeque.this.head & CircularArrayDeque.this.data.length - 1, element);
            ++this.expectedModCount;
            if (increment) {
                this.next = this.next + 1 & CircularArrayDeque.this.data.length - 1;
            }
            this.lastReturned = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.next != CircularArrayDeque.this.head;
        }

        @Override
        public int nextIndex() {
            return this.next - CircularArrayDeque.this.head & CircularArrayDeque.this.data.length - 1;
        }

        @Override
        public E previous() {
            this.checkComodification();
            int mask = CircularArrayDeque.this.data.length - 1;
            if (this.next == CircularArrayDeque.this.head) {
                throw new NoSuchElementException();
            }
            this.next = this.next - 1 & mask;
            Object result = CircularArrayDeque.this.data[this.next];
            this.lastReturned = this.next;
            return result;
        }

        @Override
        public int previousIndex() {
            return (this.next - CircularArrayDeque.this.head & CircularArrayDeque.this.data.length - 1) - 1;
        }

        @Override
        public void set(E element) {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.checkComodification();
            CircularArrayDeque.this.set(this.lastReturned - CircularArrayDeque.this.head & CircularArrayDeque.this.data.length - 1, element);
        }
    }
}

