/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.layouts.AlignedFlowLayout;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.TerminationHandler;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.adapters.ICompensationHandlerHolder;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.adapters.IEventHandlerHolder;
import org.eclipse.bpel.ui.adapters.IFaultHandlerHolder;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.adapters.ITerminationHandlerHolder;
import org.eclipse.bpel.ui.editparts.ActivityEditPart;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.CollapsableEditPart;
import org.eclipse.bpel.ui.editparts.FaultHandlerEditPart;
import org.eclipse.bpel.ui.editparts.borders.DrawerBorder;
import org.eclipse.bpel.ui.editparts.borders.ScopeBorder;
import org.eclipse.bpel.ui.editparts.figures.CollapsableContainerFigure;
import org.eclipse.bpel.ui.editparts.figures.CollapsableScopeContainerFigure;
import org.eclipse.bpel.ui.editparts.policies.BPELOrderedLayoutEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.ContainerHighlightEditPolicy;
import org.eclipse.bpel.ui.figures.CenteredConnectionAnchor;
import org.eclipse.bpel.ui.figures.ScopeHandlerLinker;
import org.eclipse.bpel.ui.util.BPELDragEditPartsTracker;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.marker.BPELEditPartMarkerDecorator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Image;

public class ScopeEditPart
extends CollapsableEditPart {
    public static final int SPACING = 19;
    private boolean showFH = false;
    private boolean showEH = false;
    private boolean showCH = false;
    private boolean showTH = false;
    private Image topImage;
    private Image bottomImage;
    private IFigure parentFigure;
    private AuxiliaryFigure auxilaryFigure;
    private CollapsableScopeContainerFigure contentFigure;
    private ScopeHandlerLinker handlerLinker;
    private Image collapsedImage;
    private Label collapsedNameLabel;
    private Label collapsedImageLabel;

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ContainerHighlightEditPolicy(false, true){

            @Override
            protected int getDrawerInset() {
                return 16;
            }

            @Override
            protected int getNorthInset() {
                return 0;
            }

            @Override
            protected int getSouthInset() {
                return 3;
            }

            @Override
            protected int getEastInset() {
                return 16;
            }

            @Override
            protected int getWestInset() {
                return 16;
            }
        });
        if (ModelHelper.isHorizontalLayout(this.getModel())) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ScopeOrderedHorizontalLayoutEditPolicy());
        } else {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ScopeOrderedLayoutEditPolicy());
        }
    }

    @Override
    protected DrawerBorder getDrawerBorder() {
        Border border = this.getContentPane().getBorder();
        if (border instanceof DrawerBorder) {
            return (DrawerBorder)border;
        }
        return null;
    }

    @Override
    public Label getLabelFigure() {
        return null;
    }

    @Override
    protected IFigure createFigure() {
        this.initializeLabels();
        if (this.collapsedImage == null) {
            ILabeledElement element = BPELUtil.adapt((Object)this.getActivity(), ILabeledElement.class);
            this.collapsedImage = element.getSmallImage(this.getActivity());
        }
        this.collapsedImageLabel = new Label(this.collapsedImage);
        this.collapsedNameLabel = new Label(this.getLabel());
        this.editPartMarkerDecorator = new BPELEditPartMarkerDecorator((EObject)this.getModel(), new CollapsableEditPart.CollapsableDecorationLayout(0));
        this.editPartMarkerDecorator.addMarkerMotionListener(this.getMarkerMotionListener());
        this.parentFigure = new Figure();
        AlignedFlowLayout layout = new AlignedFlowLayout();
        layout.setHorizontal(true);
        layout.setHorizontalSpacing(0);
        layout.setVerticalSpacing(0);
        this.parentFigure.setLayoutManager((LayoutManager)layout);
        this.contentFigure = new CollapsableScopeContainerFigure(this.getModel(), this.getImage(), this.getLabel());
        this.contentFigure.addMouseMotionListener(this.getMouseMotionListener());
        this.contentFigure.setEditPart(this);
        this.contentFigure.setForegroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("COLOR_BLACK"));
        this.parentFigure.add((IFigure)this.contentFigure);
        if (this.isCollapsed()) {
            this.configureCollapsedFigure((IFigure)this.contentFigure);
        } else {
            this.configureExpandedFigure((IFigure)this.contentFigure);
        }
        boolean isHorizontal = ModelHelper.isHorizontalLayout(this.getModel());
        this.auxilaryFigure = new AuxiliaryFigure();
        layout = new AlignedFlowLayout();
        layout.setHorizontal(!isHorizontal);
        this.auxilaryFigure.setLayoutManager((LayoutManager)layout);
        this.contentFigure.addFigureListener(this.auxilaryFigure);
        this.parentFigure.add((IFigure)this.auxilaryFigure);
        ScopeBorder border = this.getScopeBorder();
        border.setShowFault(this.getFaultHandler() != null);
        border.setShowCompensation(this.getCompensationHandler() != null);
        border.setShowTermination(this.getTerminationHandler() != null);
        border.setShowEvent(this.getEventHandler() != null);
        return this.editPartMarkerDecorator.createFigure(this.parentFigure);
    }

    @Override
    protected CollapsableContainerFigure getContentFigure() {
        return this.contentFigure;
    }

    @Override
    protected void unregisterVisuals() {
        super.unregisterVisuals();
        this.editPartMarkerDecorator = null;
        this.topImage = null;
        this.bottomImage = null;
    }

    @Override
    protected List getModelChildren() {
        return this.getModelChildren(!this.isCollapsed());
    }

    @Override
    public void refreshVisuals() {
        this.refreshDrawerImages();
        super.refreshVisuals();
        this.editPartMarkerDecorator.refresh();
        ScopeBorder border = this.getScopeBorder();
        border.setShowFault(this.getFaultHandler() != null);
        border.setShowCompensation(this.getCompensationHandler() != null);
        border.setShowTermination(this.getTerminationHandler() != null);
        border.setShowEvent(this.getEventHandler() != null);
        this.auxilaryFigure.refreshMargin();
        this.getFigure().repaint();
    }

    @Override
    protected String getLabel() {
        ILabeledElement element = BPELUtil.adapt((Object)this.getActivity(), ILabeledElement.class);
        if (element != null) {
            return element.getLabel(this.getActivity());
        }
        return null;
    }

    @Override
    protected void refreshDrawerImages() {
        ScopeBorder border = this.getScopeBorder();
        if (this.topImage != null) {
            this.topImage.dispose();
            this.topImage = null;
        }
        if (this.bottomImage != null) {
            this.bottomImage.dispose();
            this.bottomImage = null;
        }
        IMarkerHolder holder = BPELUtil.adapt((Object)this.getActivity(), IMarkerHolder.class);
        IMarker[] markers = holder.getMarkers(this.getActivity());
        int topMarkerPriority = Integer.MIN_VALUE;
        int bottomMarkerPriority = Integer.MIN_VALUE;
        IMarker topMarker = null;
        IMarker bottomMarker = null;
        int i = 0;
        while (i < markers.length) {
            int priority;
            IMarker marker = markers[i];
            String value = marker.getAttribute("org.eclipse.bpel.common.ui.graphicalMarker.anchorPoint", "");
            if (value.equals("DRAWER_TOP")) {
                if (marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.visible", true) && (priority = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.priority", Integer.MIN_VALUE)) > topMarkerPriority) {
                    topMarkerPriority = priority;
                    this.topImage = BPELUtil.getImage(marker);
                    topMarker = marker;
                }
            } else if (value.equals("DRAWER_BOTTOM") && marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.visible", true) && (priority = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.priority", Integer.MIN_VALUE)) > bottomMarkerPriority) {
                bottomMarkerPriority = priority;
                this.bottomImage = BPELUtil.getImage(marker);
                bottomMarker = marker;
            }
            ++i;
        }
        border.setTopImage(this.topImage);
        border.setBottomImage(this.bottomImage);
        border.setTopMarker(topMarker);
        border.setBottomMarker(bottomMarker);
    }

    protected List<EObject> getModelChildren(boolean includeActivity) {
        EventHandler eventHandler;
        TerminationHandler terminationHandler;
        CompensationHandler compensationHandler;
        FaultHandler faultHandler;
        ArrayList<EObject> children = new ArrayList<EObject>();
        if (includeActivity) {
            IContainer container = BPELUtil.adapt(this.getModel(), IContainer.class);
            for (EObject eObject : container.getChildren(this.getModel())) {
                if (!(eObject instanceof Activity)) continue;
                children.add(eObject);
            }
        }
        if (this.showFH && (faultHandler = this.getFaultHandler()) != null) {
            children.add(children.size(), (EObject)faultHandler);
        }
        if (this.showCH && (compensationHandler = this.getCompensationHandler()) != null) {
            children.add(children.size(), (EObject)compensationHandler);
        }
        if (this.showTH && (terminationHandler = this.getTerminationHandler()) != null) {
            children.add(children.size(), (EObject)terminationHandler);
        }
        if (this.showEH && (eventHandler = this.getEventHandler()) != null) {
            children.add(children.size(), (EObject)eventHandler);
        }
        return children;
    }

    @Override
    public ConnectionAnchor getConnectionAnchor(int location) {
        switch (location) {
            case 4: {
                return new CenteredConnectionAnchor((IFigure)this.contentFigure, location, 8);
            }
            case 2: {
                return new CenteredConnectionAnchor((IFigure)this.contentFigure, 6, 0);
            }
            case 3: {
                return new CenteredConnectionAnchor((IFigure)this.contentFigure, 7, 0);
            }
        }
        return new CenteredConnectionAnchor((IFigure)this.contentFigure, location, 0);
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        IFigure content = this.getContentPane(childEditPart);
        if (content != null) {
            if (childEditPart instanceof ActivityEditPart) {
                content.add(child, index);
            } else {
                content.add(child, this.getIndexForChild(content, childEditPart));
            }
        }
    }

    private int getIndexForChild(IFigure container, EditPart child) {
        int result = 0;
        Object model = child.getModel();
        if (model instanceof TerminationHandler) {
            if (this.showEH) {
                ++result;
            }
        } else if (model instanceof CompensationHandler) {
            if (this.showEH) {
                ++result;
            }
            if (this.showTH) {
                ++result;
            }
        } else if (model instanceof FaultHandler) {
            if (this.showEH) {
                ++result;
            }
            if (this.showTH) {
                ++result;
            }
            if (this.showCH) {
                ++result;
            }
        }
        return result;
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane(childEditPart).remove(child);
    }

    protected void reorderChild(EditPart child, int index) {
        IFigure childFigure = ((GraphicalEditPart)child).getFigure();
        LayoutManager layout = this.getContentPane(child).getLayoutManager();
        Object constraint = null;
        if (layout != null) {
            constraint = layout.getConstraint(childFigure);
        }
        this.removeChildVisual(child);
        List children = this.getChildren();
        children.remove(child);
        children.add(index, child);
        this.addChildVisual(child, index);
        this.setLayoutConstraint(child, childFigure, constraint);
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        this.getContentPane(child).setConstraint(childFigure, constraint);
    }

    @Override
    public IFigure getContentPane() {
        return this.contentFigure;
    }

    protected IFigure getContentPane(EditPart childEditPart) {
        Object model = childEditPart.getModel();
        if (model instanceof FaultHandler) {
            return this.auxilaryFigure;
        }
        if (model instanceof CompensationHandler) {
            return this.auxilaryFigure;
        }
        if (model instanceof TerminationHandler) {
            return this.auxilaryFigure;
        }
        if (model instanceof EventHandler) {
            return this.auxilaryFigure;
        }
        if (model instanceof Activity) {
            return this.contentFigure;
        }
        return this.contentFigure;
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new BPELDragEditPartsTracker((EditPart)this){

            protected boolean handleDoubleClick(int button) {
                ScopeEditPart.this.setCollapsed(!ScopeEditPart.this.isCollapsed());
                return true;
            }

            protected boolean handleButtonDown(int button) {
                Point point = this.getLocation();
                ScopeBorder border = ScopeEditPart.this.getScopeBorder();
                if (border.isPointInFaultImage(point.x, point.y)) {
                    ScopeEditPart.this.setShowFaultHandler(!ScopeEditPart.this.showFH);
                    return true;
                }
                if (border.isPointInCompensationImage(point.x, point.y)) {
                    ScopeEditPart.this.setShowCompensationHandler(!ScopeEditPart.this.showCH);
                    return true;
                }
                if (border.isPointInTerminationImage(point.x, point.y)) {
                    ScopeEditPart.this.setShowTerminationHandler(!ScopeEditPart.this.showTH);
                    return true;
                }
                if (border.isPointInEventImage(point.x, point.y)) {
                    ScopeEditPart.this.setShowEventHandler(!ScopeEditPart.this.showEH);
                    return true;
                }
                if (ScopeEditPart.this.isPointInCollapseIcon(this.getLocation())) {
                    ScopeEditPart.this.setCollapsed(!ScopeEditPart.this.isCollapsed());
                    return true;
                }
                return super.handleButtonDown(button);
            }
        };
    }

    @Override
    protected boolean isPointInCollapseIcon(Point point) {
        return this.getContentFigure().isPointInCollapseImage(point.x, point.y);
    }

    @Override
    public boolean isCollapsed() {
        return this.getContentFigure().isCollapsed();
    }

    @Override
    public void setCollapsed(boolean collapsed) {
        if (this.isCollapsed() == collapsed) {
            return;
        }
        this.getContentFigure().setCollapsed(collapsed);
        IFigure figure = this.getContentPane();
        if (this.isCollapsed()) {
            this.refreshChildren();
            IFigure[] children = figure.getChildren().toArray(new IFigure[0]);
            int i = 0;
            while (i < children.length) {
                figure.remove(children[i]);
                ++i;
            }
            this.configureCollapsedFigure(figure);
        } else {
            IFigure[] children = figure.getChildren().toArray(new IFigure[0]);
            int i = 0;
            while (i < children.length) {
                figure.remove(children[i]);
                ++i;
            }
            this.configureExpandedFigure(figure);
            this.refreshChildren();
        }
        this.refreshVisuals();
    }

    protected void configureCollapsedFigure(IFigure figure) {
        figure.setLayoutManager((LayoutManager)new FlowLayout());
        figure.addMouseMotionListener(this.getMouseMotionListener());
        figure.add((IFigure)this.collapsedImageLabel);
        figure.add((IFigure)this.collapsedNameLabel);
    }

    @Override
    protected void configureExpandedFigure(IFigure figure) {
        FlowLayout layout = new FlowLayout();
        layout.setMajorAlignment(0);
        layout.setMinorAlignment(0);
        layout.setHorizontal(ModelHelper.isHorizontalLayout(this.getModel()));
        layout.setMajorSpacing(19);
        layout.setMinorSpacing(19);
        figure.setLayoutManager((LayoutManager)layout);
    }

    private ScopeBorder getScopeBorder() {
        return (ScopeBorder)this.getContentPane().getBorder();
    }

    public void setShowFaultHandler(boolean showFaultHandler) {
        this.showFH = showFaultHandler;
        this.refresh();
    }

    public void setShowCompensationHandler(boolean showCompensationHandler) {
        this.showCH = showCompensationHandler;
        this.refresh();
    }

    public void setShowTerminationHandler(boolean showTerminationHandler) {
        this.showTH = showTerminationHandler;
        this.refresh();
    }

    public void setShowEventHandler(boolean showEventHandler) {
        this.showEH = showEventHandler;
        this.refresh();
    }

    public boolean getShowFaultHandler() {
        return this.showFH;
    }

    public boolean getShowEventHandler() {
        return this.showEH;
    }

    public boolean getShowCompensationHandler() {
        return this.showCH;
    }

    public boolean getShowTerminationHandler() {
        return this.showTH;
    }

    public FaultHandler getFaultHandler() {
        IFaultHandlerHolder holder = BPELUtil.adapt((Object)this.getActivity(), IFaultHandlerHolder.class);
        if (holder != null) {
            return holder.getFaultHandler(this.getActivity());
        }
        return null;
    }

    public CompensationHandler getCompensationHandler() {
        ICompensationHandlerHolder holder = BPELUtil.adapt((Object)this.getActivity(), ICompensationHandlerHolder.class);
        if (holder != null) {
            return holder.getCompensationHandler(this.getActivity());
        }
        return null;
    }

    public TerminationHandler getTerminationHandler() {
        ITerminationHandlerHolder holder = BPELUtil.adapt((Object)this.getActivity(), ITerminationHandlerHolder.class);
        if (holder != null) {
            return holder.getTerminationHandler(this.getActivity());
        }
        return null;
    }

    public EventHandler getEventHandler() {
        IEventHandlerHolder holder = BPELUtil.adapt((Object)this.getActivity(), IEventHandlerHolder.class);
        if (holder != null) {
            return holder.getEventHandler(this.getActivity());
        }
        return null;
    }

    @Override
    public IFigure getMainActivityFigure() {
        return this.contentFigure;
    }

    @Override
    public void switchLayout(boolean horizontal) {
        ((FlowLayout)this.contentFigure.getLayoutManager()).setHorizontal(horizontal);
        ((AlignedFlowLayout)this.auxilaryFigure.getLayoutManager()).setHorizontal(!horizontal);
        this.removeEditPolicy("LayoutEditPolicy");
        if (horizontal) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ScopeOrderedHorizontalLayoutEditPolicy());
        } else {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ScopeOrderedLayoutEditPolicy());
        }
    }

    public void refresh() {
        super.refresh();
        this.getHandlerLinker().refreshHandlerLinks();
    }

    @Override
    protected void clearConnections() {
        super.clearConnections();
        this.getHandlerLinker().clearHandlerConnections();
    }

    private ScopeHandlerLinker getHandlerLinker() {
        if (this.handlerLinker == null) {
            this.handlerLinker = new ScopeHandlerLinker(this);
        }
        return this.handlerLinker;
    }

    @Override
    protected void handleModelChanged() {
        super.handleModelChanged();
        this.showCH = this.getCompensationHandler() != null;
        this.showFH = this.getFaultHandler() != null;
        this.showEH = this.getEventHandler() != null;
        this.showTH = this.getTerminationHandler() != null;
        this.refresh();
    }

    private class AuxiliaryFigure
    extends Figure
    implements FigureListener {
        private AuxiliaryFigure() {
        }

        public void figureMoved(IFigure source) {
            this.refreshMargin();
        }

        private void refreshMargin() {
            if (ModelHelper.isHorizontalLayout(ScopeEditPart.this.getModel())) {
                this.setBorder((Border)new MarginBorder(((ScopeEditPart)ScopeEditPart.this).contentFigure.getPreferredSize().height + 10, 0, 0, 0));
            } else {
                this.setBorder(null);
            }
        }
    }

    private class ScopeOrderedHorizontalLayoutEditPolicy
    extends ScopeOrderedLayoutEditPolicy {
        private ScopeOrderedHorizontalLayoutEditPolicy() {
        }

        @Override
        protected ArrayList<PolylineConnection> createHorizontalConnections(BPELEditPart parent) {
            ArrayList<PolylineConnection> connections = new ArrayList<PolylineConnection>();
            List children = this.getConnectionChildren(parent);
            ConnectionAnchor sourceAnchor = null;
            ConnectionAnchor targetAnchor = null;
            BPELEditPart sourcePart = parent;
            sourceAnchor = sourcePart.getConnectionAnchor(2);
            if (children != null) {
                int i = 0;
                while (i < children.size()) {
                    BPELEditPart targetPart;
                    if (i == 0) {
                        targetPart = (BPELEditPart)children.get(i);
                        targetAnchor = targetPart.getConnectionAnchor(2);
                        if (sourceAnchor != null && targetAnchor != null) {
                            connections.add(this.createConnection(sourceAnchor, targetAnchor, this.arrowColor));
                        }
                    }
                    if (i < children.size() - 1) {
                        if (i > 0) {
                            sourcePart = (BPELEditPart)children.get(i);
                            sourceAnchor = sourcePart.getConnectionAnchor(3);
                        }
                        targetPart = (BPELEditPart)children.get(i + 1);
                        targetAnchor = targetPart.getConnectionAnchor(2);
                    } else {
                        sourcePart = (BPELEditPart)children.get(i);
                        sourceAnchor = sourcePart.getConnectionAnchor(3);
                        targetAnchor = parent.getConnectionAnchor(3);
                    }
                    if (sourceAnchor != null && targetAnchor != null) {
                        connections.add(this.createConnection(sourceAnchor, targetAnchor, this.arrowColor));
                    }
                    ++i;
                }
            }
            return connections;
        }
    }

    public class ScopeOrderedLayoutEditPolicy
    extends BPELOrderedLayoutEditPolicy {
        protected List getConnectionChildren(BPELEditPart editPart) {
            List originalChildren = ScopeEditPart.this.getChildren();
            ArrayList newChildren = new ArrayList();
            for (Object next : originalChildren) {
                if (next instanceof FaultHandlerEditPart) continue;
                newChildren.add(next);
            }
            return newChildren;
        }
    }
}

