/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.internal.docker.launcher.BaseDatabindingModel;
import org.eclipse.cdt.internal.docker.launcher.DataVolumeModel;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;

public class ContainerPropertyVolumesModel
extends BaseDatabindingModel {
    public static final String DATA_VOLUMES = "dataVolumes";
    public static final String SELECTED_DATA_VOLUMES = "selectedDataVolumes";
    private IDockerConnection connection;
    private IDockerImageInfo imageInfo = null;
    private Set<DataVolumeModel> selectedDataVolumes = new HashSet<DataVolumeModel>();
    private WritableList<DataVolumeModel> dataVolumes = new WritableList();
    private List<DataVolumeModel> previousVolumes = new ArrayList<DataVolumeModel>();
    private IDockerImage selectedImage;

    public ContainerPropertyVolumesModel(IDockerConnection connection) {
        this.connection = connection;
    }

    public ContainerPropertyVolumesModel(IDockerImage selectedImage) throws DockerException {
        this(selectedImage.getConnection());
        this.selectedImage = selectedImage;
    }

    public void setConnection(IDockerConnection connection) {
        this.connection = connection;
        this.setSelectedImage(null);
    }

    public IDockerConnection getConnection() {
        return this.connection;
    }

    public void setSelectedImage(IDockerImage selectedImage) {
        if (this.selectedImage == null || !this.selectedImage.equals(selectedImage)) {
            this.selectedImage = selectedImage;
            if (selectedImage != null) {
                this.imageInfo = selectedImage.getConnection().getImageInfo(selectedImage.id());
                if (this.imageInfo.config() != null && this.imageInfo.config().volumes() != null) {
                    for (DataVolumeModel dvm : this.previousVolumes) {
                        this.removeDataVolume(dvm);
                        this.selectedDataVolumes.remove(dvm);
                    }
                    ArrayList<DataVolumeModel> volumes = new ArrayList<DataVolumeModel>();
                    for (String volume : this.imageInfo.config().volumes().keySet()) {
                        volumes.add(new DataVolumeModel(volume));
                    }
                    this.setDataVolumes(volumes);
                    this.previousVolumes = volumes;
                }
            } else {
                this.setDataVolumes(Collections.emptyList());
            }
        }
    }

    public IDockerImage getSelectedImage() {
        return this.selectedImage;
    }

    public IDockerImageInfo getSelectedImageInfo() {
        return this.imageInfo;
    }

    public WritableList<DataVolumeModel> getDataVolumes() {
        return this.dataVolumes;
    }

    public void setDataVolumes(Collection<DataVolumeModel> volumes) {
        if (volumes != null) {
            this.dataVolumes.addAll(volumes);
        }
    }

    public void clearDataVolumes() {
        this.dataVolumes.clear();
    }

    public void removeDataVolume(DataVolumeModel dataVolume) {
        this.dataVolumes.remove((Object)dataVolume);
    }

    public Set<DataVolumeModel> getSelectedDataVolumes() {
        return this.selectedDataVolumes;
    }

    public void setSelectedDataVolumes(Set<DataVolumeModel> selectedDataVolumes) {
        Assert.isNotNull(selectedDataVolumes);
        this.selectedDataVolumes = selectedDataVolumes;
        this.firePropertyChange(SELECTED_DATA_VOLUMES, this.selectedDataVolumes, this.selectedDataVolumes);
    }

    public static enum MountType {
        NONE,
        HOST_FILE_SYSTEM,
        CONTAINER;

    }
}

