/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;

public class CompareResourceFilter {
    private static final char[][] NO_CHAR_CHAR = new char[0][];
    private char[][] fExtraResourceFileFilters;
    private String[] fExtraResourceFolderFilters;

    public boolean filter(String path0, boolean folder, boolean isArchive) {
        int n;
        if (!folder && this.fExtraResourceFileFilters != null) {
            char[] name = path0.toCharArray();
            char[][] cArray = this.fExtraResourceFileFilters;
            int n2 = this.fExtraResourceFileFilters.length;
            n = 0;
            while (n < n2) {
                char[] filter = cArray[n];
                if (this.match(filter, name, true)) {
                    return true;
                }
                ++n;
            }
        }
        if (folder && this.fExtraResourceFolderFilters != null) {
            String[] stringArray = this.fExtraResourceFolderFilters;
            n = this.fExtraResourceFolderFilters.length;
            int n3 = 0;
            while (n3 < n) {
                String filter = stringArray[n3];
                if (filter.equals(path0)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public static String validateResourceFilters(String text) {
        String[] filters;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String[] stringArray = filters = CompareResourceFilter.getTokens(text, ",");
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status;
            String filter = stringArray[n2];
            String fileName = filter.replace('*', 'x');
            int resourceType = 1;
            int lastCharacter = fileName.length() - 1;
            if (lastCharacter >= 0 && fileName.charAt(lastCharacter) == '/') {
                fileName = fileName.substring(0, lastCharacter);
                resourceType = 2;
            }
            if ((status = workspace.validateName(fileName, resourceType)).matches(4)) {
                String format = Utilities.getString("ComparePreferencePage.filter.invalidsegment.error");
                return MessageFormat.format(format, status.getMessage());
            }
            ++n2;
        }
        return null;
    }

    public void setFilters(String filterSequence) {
        char[][] filters;
        char[][] cArray = filters = filterSequence != null && filterSequence.length() > 0 ? this.splitAndTrimOn(',', filterSequence.toCharArray()) : null;
        if (filters == null) {
            this.fExtraResourceFileFilters = null;
            this.fExtraResourceFolderFilters = null;
        } else {
            char[] filter;
            int fileCount = 0;
            int folderCount = 0;
            char[][] cArray2 = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                filter = cArray2[n2];
                if (filter.length != 0) {
                    if (filter[filter.length - 1] == '/') {
                        ++folderCount;
                    } else {
                        ++fileCount;
                    }
                }
                ++n2;
            }
            this.fExtraResourceFileFilters = new char[fileCount][];
            this.fExtraResourceFolderFilters = new String[folderCount];
            cArray2 = filters;
            n = filters.length;
            n2 = 0;
            while (n2 < n) {
                filter = cArray2[n2];
                if (filter.length != 0) {
                    if (filter[filter.length - 1] == '/') {
                        this.fExtraResourceFolderFilters[--folderCount] = new String(this.subarray(filter, 0, filter.length - 1));
                    } else {
                        this.fExtraResourceFileFilters[--fileCount] = filter;
                    }
                }
                ++n2;
            }
        }
    }

    private static String[] getTokens(String text, String separator) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }

    private boolean match(char[] pattern, char[] name, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        return this.match(pattern, 0, pattern.length, name, 0, name.length, isCaseSensitive);
    }

    private boolean match(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        if (patternEnd < 0) {
            patternEnd = pattern.length;
        }
        if (nameEnd < 0) {
            nameEnd = name.length;
        }
        char patternChar = '\u0000';
        while (iPattern < patternEnd && (patternChar = pattern[iPattern]) != '*') {
            if (iName == nameEnd) {
                return false;
            }
            if (patternChar != (isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) && patternChar != '?') {
                return false;
            }
            ++iName;
            ++iPattern;
        }
        int segmentStart = patternChar == '*' ? ++iPattern : 0;
        int prefixStart = iName;
        while (iName < nameEnd) {
            if (iPattern == patternEnd) {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            patternChar = pattern[iPattern];
            if (patternChar == '*') {
                if ((segmentStart = ++iPattern) == patternEnd) {
                    return true;
                }
                prefixStart = iName;
                continue;
            }
            if ((isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) != patternChar && patternChar != '?') {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            ++iName;
            ++iPattern;
        }
        return segmentStart == patternEnd || iName == nameEnd && iPattern == patternEnd || iPattern == patternEnd - 1 && pattern[iPattern] == '*';
    }

    private char[][] splitAndTrimOn(char divider, char[] array) {
        int length;
        int n = length = array == null ? 0 : array.length;
        if (length == 0) {
            return NO_CHAR_CHAR;
        }
        int wordCount = 1;
        int i = 0;
        while (i < length) {
            if (array[i] == divider) {
                ++wordCount;
            }
            ++i;
        }
        char[][] split = new char[wordCount][];
        int last = 0;
        int currentWord = 0;
        int i2 = 0;
        while (i2 < length) {
            if (array[i2] == divider) {
                int start = last;
                int end = i2 - 1;
                while (start < i2 && array[start] == ' ') {
                    ++start;
                }
                while (end > start && array[end] == ' ') {
                    --end;
                }
                split[currentWord] = new char[end - start + 1];
                System.arraycopy(array, start, split[currentWord++], 0, end - start + 1);
                last = i2 + 1;
            }
            ++i2;
        }
        int start = last;
        int end = length - 1;
        while (start < length && array[start] == ' ') {
            ++start;
        }
        while (end > start && array[end] == ' ') {
            --end;
        }
        split[currentWord] = new char[end - start + 1];
        System.arraycopy(array, start, split[currentWord++], 0, end - start + 1);
        return split;
    }

    private char[] subarray(char[] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[] result = new char[end - start];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }
}

