/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.connection;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectionProfileConstants;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IOfflineConnection;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.IServerVersionProvider;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.VersionProviderConnection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.ResourceUtil;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionAdapter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionSharingListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.CatalogUtil;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.DatabaseProviderHelper;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class ConnectionInfoImpl
extends VersionProviderConnection
implements ConnectionInfo,
IOfflineConnection {
    private static final String PASSWORD = "password";
    private static final String USER = "user";
    private DatabaseDefinition definition;
    private String loadingPath = "";
    private String driverClassName = "";
    private String url = "";
    private Properties properties = new Properties();
    private String name;
    private String databaseName = null;
    private String identifierQuoteString = null;
    private String databaseProductVersion = null;
    private Connection sharedConnection = null;
    private Database sharedDatabase = null;
    private Collection listeners = new LinkedList();
    private Hashtable filters = null;
    private Collection filterListeners = new LinkedList();
    private Collection projects = null;
    private boolean detectDefinition = false;
    private IConnection jdbcConnection;
    private Throwable connectException;
    private IPropertySetListener profilePropertyListener = new IPropertySetListener(){

        public void propertySetChanged(IPropertySetChangeEvent event) {
            if ("org.eclipse.datatools.connectivity.sqm.filterSettings".equals(event.getPropertySetType())) {
                ConnectionInfoImpl.this.processFilterChanges(event);
            }
        }
    };
    public static final String TECHNOLOGY_ROOT_KEY = "jdbc";

    static IPath getConnectionDirectory(String name) {
        IPath path = RDBCorePlugin.getDefaultStateLocation();
        path = path.append("connection/");
        if (name != null) {
            path = path.append(String.valueOf(name) + "/");
        }
        return path;
    }

    static File getConnectionFile(String name) {
        IPath connectionPath = ConnectionInfoImpl.getConnectionDirectory(name);
        return connectionPath.append("cache.xmi").toFile();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.name == null) {
            throw new IllegalStateException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    @Override
    public DatabaseDefinition getDatabaseDefinition() {
        return this.definition;
    }

    public String getLoadingPath() {
        return this.loadingPath;
    }

    @Override
    public void setLoadingPath(String path) {
        this.loadingPath = path;
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Override
    public void setDriverClassName(String className) {
        this.driverClassName = className;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String url) {
        this.url = url;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getUserName() {
        return (String)this.properties.get(USER);
    }

    @Override
    public void setUserName(String id) {
        this.properties.put(USER, id);
    }

    @Override
    public String getPassword() {
        return (String)this.properties.get(PASSWORD);
    }

    @Override
    public void setPassword(String password) {
        this.properties.put(PASSWORD, password);
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDatabaseName(String databasename) {
        this.databaseName = databasename;
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public void setIdentifierQuoteString(String quote) {
        this.identifierQuoteString = quote;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String prodVersion) {
        this.databaseProductVersion = prodVersion;
    }

    @Override
    public void setSharedConnection(Connection connection) {
        if (connection == null) {
            this.removeSharedConnection();
        } else {
            try {
                if (connection.isClosed()) {
                    throw new IllegalStateException();
                }
            }
            catch (Throwable throwable) {
                throw new IllegalStateException();
            }
            if (this.sharedConnection == null) {
                this.sharedConnection = connection;
                LinkedList c = new LinkedList();
                c.addAll(this.listeners);
                for (ConnectionSharingListener l : c) {
                    try {
                        l.sharedConnectionAdded(this, connection);
                    }
                    catch (Throwable throwable) {
                        this.removeConnectionSharingListener(l);
                    }
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }

    public IConnection getJDBCConnectionWrapper() {
        return this.jdbcConnection;
    }

    public void replaceSharedConnection(Connection connection) {
        Connection existingSharedConnection = this.sharedConnection;
        LinkedList c = new LinkedList();
        c.addAll(this.listeners);
        for (ConnectionSharingListener l : c) {
            try {
                l.sharedConnectionRemove(this, existingSharedConnection);
            }
            catch (Throwable throwable) {
                this.removeConnectionSharingListener(l);
            }
        }
        this.sharedConnection = connection;
        for (ConnectionSharingListener l : c) {
            try {
                l.sharedConnectionAdded(this, connection);
            }
            catch (Throwable throwable) {
                this.removeConnectionSharingListener(l);
            }
        }
    }

    @Override
    public Connection getSharedConnection() {
        return this.sharedConnection;
    }

    @Override
    public void removeSharedConnection() {
        if (this.sharedConnection == null) {
            throw new IllegalStateException();
        }
        Connection connection = this.sharedConnection;
        this.sharedConnection = null;
        LinkedList c = new LinkedList();
        c.addAll(this.listeners);
        for (ConnectionSharingListener l : c) {
            try {
                l.sharedConnectionRemove(this, connection);
            }
            catch (Throwable throwable) {
                this.removeConnectionSharingListener(l);
            }
        }
    }

    @Override
    public void setSharedDatabase(Database database) {
        if (database == null) {
            this.removeSharedDatabase();
        } else if (this.sharedDatabase == null) {
            this.sharedDatabase = database;
            DatabaseConnectionRegistry.getInstance().registerConnectionForDatabase(this, database);
            LinkedList c = new LinkedList();
            c.addAll(this.listeners);
            for (ConnectionSharingListener l : c) {
                try {
                    l.sharedDatabaseAdded(this, database);
                }
                catch (Throwable throwable) {
                    this.removeConnectionSharingListener(l);
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public Database getSharedDatabase() {
        return this.sharedDatabase;
    }

    @Override
    public void removeSharedDatabase() {
        if (this.sharedDatabase == null) {
            throw new IllegalStateException();
        }
        Database database = this.sharedDatabase;
        DatabaseConnectionRegistry.getInstance().unregisterConnectionForDatabase(database);
        this.sharedDatabase = null;
        LinkedList c = new LinkedList();
        c.addAll(this.listeners);
        for (ConnectionSharingListener l : c) {
            try {
                l.sharedDatabaseRemove(this, database);
            }
            catch (Throwable throwable) {
                this.removeConnectionSharingListener(l);
            }
        }
    }

    @Override
    public boolean addConnectionSharingListener(ConnectionSharingListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            if (listener != it.next()) continue;
            return false;
        }
        this.listeners.add(listener);
        return true;
    }

    @Override
    public boolean removeConnectionSharingListener(ConnectionSharingListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            if (listener != it.next()) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public void cacheDatabase(Database database) throws IOException {
        if (this.name == null) {
            throw new IllegalStateException();
        }
        this.initConnectionDirectory();
        FileOutputStream out = new FileOutputStream(ConnectionInfoImpl.getConnectionFile(this.name));
        XMIResourceImpl r = new XMIResourceImpl();
        r.getContents().add((Object)database);
        ResourceUtil.resolveDanglingReferences((Resource)r);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        r.save((OutputStream)out, options);
        r.getContents().clear();
    }

    @Override
    public Database getCachedDatabase() {
        if (this.name == null) {
            throw new IllegalStateException();
        }
        this.initConnectionDirectory();
        File file = ConnectionInfoImpl.getConnectionFile(this.name);
        if (file.exists()) {
            XMIResourceImpl r = new XMIResourceImpl();
            try {
                FileInputStream in = new FileInputStream(file);
                r.load((InputStream)in, null);
                EList l = r.getContents();
                Database database = (Database)l.get(0);
                l.clear();
                return database;
            }
            catch (Throwable o) {
                o.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public long getCachedDatabaseTimestamp() {
        if (this.name == null) {
            throw new IllegalStateException();
        }
        IPath path = this.initConnectionDirectory();
        File file = (path = path.append("cache.xmi")).toFile();
        if (file.exists()) {
            return file.lastModified();
        }
        return 0L;
    }

    void setDatabaseDefinition(DatabaseDefinition def) {
        this.definition = def;
    }

    private IPath initConnectionDirectory() {
        IPath path = ConnectionInfoImpl.getConnectionDirectory(this.name);
        File dir = path.toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return path;
    }

    @Override
    public void addFilter(String key, ConnectionFilter filter) {
        if (this.filters == null) {
            this.loadFilterInfo();
        }
        if (this.filters.containsKey(key)) {
            this.filters.remove(key);
        }
        this.filters.put(key, filter);
        try {
            this.saveFilterInfo();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.fireFilterAdded(key);
    }

    @Override
    public void removeFilter(String key) {
        if (this.filters == null) {
            this.loadFilterInfo();
        }
        if (this.filters.containsKey(key)) {
            this.filters.remove(key);
            try {
                this.saveFilterInfo();
            }
            catch (Exception exception) {}
            this.fireFilterRemoved(key);
        }
    }

    @Override
    public ConnectionFilter getFilter(String key) {
        if (this.filters == null) {
            this.loadFilterInfo();
        }
        if (key != null && this.filters.containsKey(key)) {
            return (ConnectionFilter)this.filters.get(key);
        }
        return null;
    }

    @Override
    public Iterator getFilters() {
        LinkedList filters = new LinkedList();
        Enumeration e = this.filters.elements();
        while (e.hasMoreElements()) {
            filters.add(e.nextElement());
        }
        return filters.iterator();
    }

    public IProject[] getDependentProjects() {
        if (this.projects == null) {
            this.loadDependentProjects();
        }
        IProject[] p = new IProject[this.projects.size()];
        this.projects.toArray(p);
        return p;
    }

    @Override
    public void addDependentProject(IProject proj) {
        if (this.projects == null) {
            this.loadDependentProjects();
        }
        this.projects.add(proj);
        this.saveDependentProjects();
    }

    @Override
    public void removeDependentProject(IProject proj) {
        if (this.projects == null) {
            this.loadDependentProjects();
        }
        this.projects.remove(proj);
        this.saveDependentProjects();
    }

    void onSQLException(Connection connection, SQLException exception) {
        LinkedList c = new LinkedList();
        c.addAll(this.listeners);
        for (ConnectionSharingListener l : c) {
            try {
                l.onSQLException(this, connection, exception);
            }
            catch (Throwable throwable) {
                this.removeConnectionSharingListener(l);
            }
        }
    }

    private void loadDependentProjects() {
        this.projects = new HashSet();
        IPath path = this.initConnectionDirectory();
        File file = (path = path.append("projects")).toFile();
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fileInput = new FileInputStream(file);
            ObjectInputStream objectInput = new ObjectInputStream(fileInput);
            LinkedList l = (LinkedList)objectInput.readObject();
            objectInput.close();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            for (String name : l) {
                IProject p = root.getProject(name);
                if (p == null) continue;
                this.projects.add(p);
            }
        }
        catch (Exception exception) {}
    }

    private void saveDependentProjects() {
        IPath path = this.initConnectionDirectory();
        path = path.append("projects");
        File file = path.toFile();
        LinkedList<String> l = new LinkedList<String>();
        Iterator i = this.projects.iterator();
        while (i.hasNext()) {
            l.add(((IProject)i.next()).getName());
        }
        try {
            FileOutputStream fileOutput = new FileOutputStream(file);
            ObjectOutputStream objectOutput = new ObjectOutputStream(fileOutput);
            objectOutput.writeObject(l);
            objectOutput.close();
        }
        catch (IOException iOException) {}
    }

    private void saveFilterInfo() throws IOException, FileNotFoundException {
        if (this.name == null || this.name.equals("")) {
            return;
        }
        IPath path = this.initConnectionDirectory();
        String filename = "filter.info";
        path = path.append(filename);
        File file = path.toFile();
        FileOutputStream fileOutput = new FileOutputStream(file);
        ObjectOutputStream objectOutput = new ObjectOutputStream(fileOutput);
        objectOutput.writeObject(this.filters);
        objectOutput.close();
    }

    private void loadFilterInfo() {
        Properties props = this.getConnectionProfile().getProperties("org.eclipse.datatools.connectivity.sqm.filterSettings");
        this.filters = new Hashtable();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String predicate;
            String filterID = (String)entry.getKey();
            if (filterID == null || (predicate = (String)entry.getValue()) == null || predicate.length() <= 0) continue;
            ConnectionFilterImpl filter = new ConnectionFilterImpl(predicate);
            this.filters.put(filterID, filter);
        }
    }

    @Override
    public boolean addFilterListener(ConnectionFilterListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator it = this.filterListeners.iterator();
        while (it.hasNext()) {
            if (listener != it.next()) continue;
            return false;
        }
        this.filterListeners.add(listener);
        return true;
    }

    @Override
    public boolean removeFilterListener(ConnectionFilterListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator it = this.filterListeners.iterator();
        while (it.hasNext()) {
            if (listener != it.next()) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public void discoverDatabaseDefinitionWhenConnect() {
        this.detectDefinition = true;
    }

    public boolean isDiscoverDatabaseDefinitionWhenConnectEnabled() {
        return this.detectDefinition;
    }

    public ConnectionInfoImpl(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
        DatabaseDefinitionRegistry defRegistry;
        DatabaseDefinition dbDef;
        String vendor = null;
        String version = null;
        String databaseName = null;
        try {
            vendor = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.vendor");
            version = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.version");
            databaseName = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName");
            if (databaseName == null || databaseName.trim().length() == 0) {
                databaseName = profile.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((dbDef = (defRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry()).getDefinition(vendor, version)) == null) {
            dbDef = defRegistry.getDefinition("Generic JDBC", "1.0");
        }
        this.setDatabaseDefinition(dbDef);
        this.setDatabaseName(databaseName);
        this.name = profile.getName();
    }

    public ConnectionInfoImpl(IConnectionProfile profile, Class factoryClass, boolean createConnection) {
        this(profile, factoryClass);
        if (createConnection) {
            this.initializeJDBCConnection();
        } else {
            this.jdbcConnection = null;
            Database database = this.getCachedDatabase();
            if (database != null) {
                this.setSharedDatabase(database);
            }
        }
        profile.addPropertySetListener(this.profilePropertyListener);
    }

    private void initializeJDBCConnection() {
        IConnectionProfile profile = this.getConnectionProfile();
        this.jdbcConnection = profile.createConnection(Connection.class.getName());
        this.connectException = this.jdbcConnection.getConnectException();
        Connection connection = (Connection)this.jdbcConnection.getRawConnection();
        if (connection != null) {
            DatabaseDefinition detectedDBDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().recognize(connection);
            if (detectedDBDefinition != null) {
                Properties props = this.copyProperties(profile.getProperties(this.getConnectionProfile().getProviderId()));
                props.setProperty("org.eclipse.datatools.connectivity.db.vendor", detectedDBDefinition.getProduct());
                props.setProperty("org.eclipse.datatools.connectivity.db.version", detectedDBDefinition.getVersion());
                profile.setProperties(this.getConnectionProfile().getProviderId(), props);
                this.setDatabaseDefinition(detectedDBDefinition);
            }
            this.setSharedConnection(connection);
            new DatabaseProviderHelper().setDatabase(new ConnectionAdapter(this, connection), this, this.getDatabaseName());
        }
    }

    private Properties copyProperties(Properties properties) {
        Properties copy = new Properties();
        Enumeration<Object> propertyKeys = properties.keys();
        while (propertyKeys.hasMoreElements()) {
            Object key = propertyKeys.nextElement();
            copy.put(key, properties.get(key));
        }
        return copy;
    }

    private void processFilterChanges(IPropertySetChangeEvent event) {
        if (this.filters == null) {
            this.loadFilterInfo();
        }
        for (IPropertySetChangeEvent.IChangedProperty changedProperty : event.getChangedProperties().values()) {
            if (changedProperty.getNewValue() == null) {
                this.filters.remove(changedProperty.getID());
                this.fireFilterRemoved(changedProperty.getID());
                continue;
            }
            if (changedProperty.getOldValue() == null) {
                this.filters.put(changedProperty.getID(), new ConnectionFilterImpl(changedProperty.getNewValue()));
                this.fireFilterAdded(changedProperty.getID());
                continue;
            }
            this.filters.put(changedProperty.getID(), new ConnectionFilterImpl(changedProperty.getNewValue()));
            this.fireFilterChanged(changedProperty.getID());
        }
    }

    private void fireFilterRemoved(String filterID) {
        LinkedList cachedListener = new LinkedList();
        cachedListener.addAll(this.filterListeners);
        for (ConnectionFilterListener l : cachedListener) {
            try {
                l.connectionFilterRemoved(filterID);
            }
            catch (Throwable e) {
                RDBCorePlugin.getDefault().getLog().log((IStatus)new Status(4, RDBCorePlugin.getSymbolicName(), -1, e.getLocalizedMessage() == null ? new String() : e.getLocalizedMessage(), e));
            }
        }
    }

    private void fireFilterAdded(String filterID) {
        LinkedList cachedListener = new LinkedList();
        cachedListener.addAll(this.filterListeners);
        for (ConnectionFilterListener l : cachedListener) {
            try {
                l.connectionFilterAdded(filterID);
            }
            catch (Throwable e) {
                RDBCorePlugin.getDefault().getLog().log((IStatus)new Status(4, RDBCorePlugin.getSymbolicName(), -1, e.getLocalizedMessage() == null ? new String() : e.getLocalizedMessage(), e));
            }
        }
    }

    private void fireFilterChanged(String filterID) {
        LinkedList cachedListener = new LinkedList();
        cachedListener.addAll(this.filterListeners);
        for (ConnectionFilterListener l : cachedListener) {
            try {
                l.connectionFilterAdded(filterID);
            }
            catch (Throwable e) {
                RDBCorePlugin.getDefault().getLog().log((IStatus)new Status(4, RDBCorePlugin.getSymbolicName(), -1, e.getLocalizedMessage() == null ? new String() : e.getLocalizedMessage(), e));
            }
        }
    }

    private void test() {
        Database db = this.getSharedDatabase();
        for (Schema schema : db.getSchemas()) {
            System.out.println("Schema " + schema.getName() + " has tables:");
            EList tables = schema.getTables();
            Iterator tableIter = tables.iterator();
            while (tableIter.hasNext()) {
                System.out.println(((Table)tableIter.next()).getName());
            }
        }
    }

    public void close() {
        this.getConnectionProfile().removePropertySetListener(this.profilePropertyListener);
        if (this.getSharedDatabase() != null) {
            this.setSharedDatabase(null);
        }
        if (this.getSharedConnection() != null) {
            this.setSharedConnection(null);
        }
        if (this.jdbcConnection != null) {
            this.jdbcConnection.close();
            this.jdbcConnection = null;
        }
    }

    public Throwable getConnectException() {
        return this.connectException;
    }

    public String getProviderName() {
        return this.jdbcConnection == null ? this.getConnectionProfile().getProperties("org.eclipse.datatools.connectivity.versionInfo").getProperty("server.name") : ((IServerVersionProvider)this.jdbcConnection).getProviderName();
    }

    public Version getProviderVersion() {
        return this.jdbcConnection == null ? Version.valueOf((String)this.getConnectionProfile().getProperties("org.eclipse.datatools.connectivity.versionInfo").getProperty("server.version")) : ((IServerVersionProvider)this.jdbcConnection).getProviderVersion();
    }

    protected String getTechnologyRootKey() {
        return TECHNOLOGY_ROOT_KEY;
    }

    public String getTechnologyName() {
        return this.jdbcConnection == null ? this.getConnectionProfile().getProperties("org.eclipse.datatools.connectivity.versionInfo").getProperty(ConnectionProfileConstants.createTechnologyNameKey((String)this.getTechnologyRootKey())) : ((IServerVersionProvider)this.jdbcConnection).getTechnologyName();
    }

    public Version getTechnologyVersion() {
        return this.jdbcConnection == null ? Version.valueOf((String)this.getConnectionProfile().getProperties("org.eclipse.datatools.connectivity.versionInfo").getProperty(ConnectionProfileConstants.createTechnologyVersionKey((String)this.getTechnologyRootKey()))) : ((IServerVersionProvider)this.jdbcConnection).getTechnologyVersion();
    }

    public Object getRawConnection() {
        return this;
    }

    public void attach(IProgressMonitor monitor) throws CoreException {
        this.initializeJDBCConnection();
        monitor.done();
    }

    public void detach(IProgressMonitor monitor) throws CoreException {
        this.save(monitor);
        this.removeSharedConnection();
    }

    public boolean isWorkingOffline() {
        return this.connectException == null && this.sharedConnection == null && this.sharedDatabase != null;
    }

    public void save(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Save Offline SQL Model for " + this.getName(), 100);
        monitor.worked(5);
        new CatalogUtil().load((EObject)this.sharedDatabase, monitor, 90);
        if (!monitor.isCanceled()) {
            monitor.subTask("");
            try {
                this.cacheDatabase(this.sharedDatabase);
            }
            catch (IOException e) {
                Status status = new Status(4, RDBCorePlugin.getSymbolicName(), -1, "Error saving offline SQL Model for {0}.", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        } else {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }
}

