/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.liqp.tags;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.embedcdt.core.liqp.LValue;
import org.eclipse.embedcdt.core.liqp.TemplateContext;
import org.eclipse.embedcdt.core.liqp.nodes.LNode;
import org.eclipse.embedcdt.core.liqp.tags.Assign;
import org.eclipse.embedcdt.core.liqp.tags.Capture;
import org.eclipse.embedcdt.core.liqp.tags.Case;
import org.eclipse.embedcdt.core.liqp.tags.Comment;
import org.eclipse.embedcdt.core.liqp.tags.Cycle;
import org.eclipse.embedcdt.core.liqp.tags.For;
import org.eclipse.embedcdt.core.liqp.tags.If;
import org.eclipse.embedcdt.core.liqp.tags.Include;
import org.eclipse.embedcdt.core.liqp.tags.Raw;
import org.eclipse.embedcdt.core.liqp.tags.Tablerow;
import org.eclipse.embedcdt.core.liqp.tags.Unless;

public abstract class Tag
extends LValue {
    private static final Map<String, Tag> TAGS = new HashMap<String, Tag>();
    public final String name;

    static {
        Tag.registerTag(new Assign());
        Tag.registerTag(new Case());
        Tag.registerTag(new Capture());
        Tag.registerTag(new Comment());
        Tag.registerTag(new Cycle());
        Tag.registerTag(new For());
        Tag.registerTag(new If());
        Tag.registerTag(new Include());
        Tag.registerTag(new Raw());
        Tag.registerTag(new Tablerow());
        Tag.registerTag(new Unless());
    }

    protected Tag() {
        this.name = this.getClass().getSimpleName().toLowerCase();
    }

    public Tag(String name) {
        this.name = name;
    }

    public static Tag getTag(String name) {
        Tag tag = TAGS.get(name);
        if (tag == null) {
            throw new RuntimeException("unknown tag: " + name);
        }
        return tag;
    }

    public static Map<String, Tag> getTags() {
        return new HashMap<String, Tag>(TAGS);
    }

    public static void registerTag(Tag tag) {
        TAGS.put(tag.name, tag);
    }

    public abstract Object render(TemplateContext var1, LNode ... var2);

    public static enum Statement {
        BREAK,
        CONTINUE;


        public String toString() {
            return "";
        }
    }
}

