package org.eclipse.gef.dot.internal.language.parser.antlr.lexer;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class InternalDotStyleLexer extends Lexer {
    public static final int RULE_WS=7;
    public static final int RightParenthesis=5;
    public static final int RULE_NAME=8;
    public static final int Comma=6;
    public static final int LeftParenthesis=4;
    public static final int EOF=-1;

    // delegates
    // delegators

    public InternalDotStyleLexer() {;} 
    public InternalDotStyleLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public InternalDotStyleLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);

    }
    public String getGrammarFileName() { return "InternalDotStyleLexer.g"; }

    // $ANTLR start "LeftParenthesis"
    public final void mLeftParenthesis() throws RecognitionException {
        try {
            int _type = LeftParenthesis;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotStyleLexer.g:14:17: ( '(' )
            // InternalDotStyleLexer.g:14:19: '('
            {
            match('('); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LeftParenthesis"

    // $ANTLR start "RightParenthesis"
    public final void mRightParenthesis() throws RecognitionException {
        try {
            int _type = RightParenthesis;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotStyleLexer.g:16:18: ( ')' )
            // InternalDotStyleLexer.g:16:20: ')'
            {
            match(')'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RightParenthesis"

    // $ANTLR start "Comma"
    public final void mComma() throws RecognitionException {
        try {
            int _type = Comma;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotStyleLexer.g:18:7: ( ',' )
            // InternalDotStyleLexer.g:18:9: ','
            {
            match(','); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "Comma"

    // $ANTLR start "RULE_WS"
    public final void mRULE_WS() throws RecognitionException {
        try {
            int _type = RULE_WS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotStyleLexer.g:20:9: ( ( ' ' | '\\t' | '\\r' | '\\n' ) )
            // InternalDotStyleLexer.g:20:11: ( ' ' | '\\t' | '\\r' | '\\n' )
            {
            if ( (input.LA(1)>='\t' && input.LA(1)<='\n')||input.LA(1)=='\r'||input.LA(1)==' ' ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_WS"

    // $ANTLR start "RULE_NAME"
    public final void mRULE_NAME() throws RecognitionException {
        try {
            int _type = RULE_NAME;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotStyleLexer.g:22:11: ( (~ ( ( RULE_WS | '(' | ')' | ',' ) ) )* )
            // InternalDotStyleLexer.g:22:13: (~ ( ( RULE_WS | '(' | ')' | ',' ) ) )*
            {
            // InternalDotStyleLexer.g:22:13: (~ ( ( RULE_WS | '(' | ')' | ',' ) ) )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( ((LA1_0>='\u0000' && LA1_0<='\b')||(LA1_0>='\u000B' && LA1_0<='\f')||(LA1_0>='\u000E' && LA1_0<='\u001F')||(LA1_0>='!' && LA1_0<='\'')||(LA1_0>='*' && LA1_0<='+')||(LA1_0>='-' && LA1_0<='\uFFFF')) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // InternalDotStyleLexer.g:22:13: ~ ( ( RULE_WS | '(' | ')' | ',' ) )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\b')||(input.LA(1)>='\u000B' && input.LA(1)<='\f')||(input.LA(1)>='\u000E' && input.LA(1)<='\u001F')||(input.LA(1)>='!' && input.LA(1)<='\'')||(input.LA(1)>='*' && input.LA(1)<='+')||(input.LA(1)>='-' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_NAME"

    public void mTokens() throws RecognitionException {
        // InternalDotStyleLexer.g:1:8: ( LeftParenthesis | RightParenthesis | Comma | RULE_WS | RULE_NAME )
        int alt2=5;
        switch ( input.LA(1) ) {
        case '(':
            {
            alt2=1;
            }
            break;
        case ')':
            {
            alt2=2;
            }
            break;
        case ',':
            {
            alt2=3;
            }
            break;
        case '\t':
        case '\n':
        case '\r':
        case ' ':
            {
            alt2=4;
            }
            break;
        default:
            alt2=5;}

        switch (alt2) {
            case 1 :
                // InternalDotStyleLexer.g:1:10: LeftParenthesis
                {
                mLeftParenthesis(); 

                }
                break;
            case 2 :
                // InternalDotStyleLexer.g:1:26: RightParenthesis
                {
                mRightParenthesis(); 

                }
                break;
            case 3 :
                // InternalDotStyleLexer.g:1:43: Comma
                {
                mComma(); 

                }
                break;
            case 4 :
                // InternalDotStyleLexer.g:1:49: RULE_WS
                {
                mRULE_WS(); 

                }
                break;
            case 5 :
                // InternalDotStyleLexer.g:1:57: RULE_NAME
                {
                mRULE_NAME(); 

                }
                break;

        }

    }


 

}