/*********************************************************************
* Copyright (c) 2005, 2019 SAP SE
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which is available at https://www.eclipse.org/legal/epl-2.0/
*
* Contributors:
*    SAP SE - initial API, implementation and documentation
*
* SPDX-License-Identifier: EPL-2.0
**********************************************************************/
package org.eclipse.graphiti.ui.internal.command;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.graphiti.features.IProgress;

/**
 * @noinstantiate This class is not intended to be instantiated by clients.
 * @noextend This class is not intended to be subclassed by clients.
 */
public class EclipseProgress implements IProgress {
	private IProgressMonitor eclipseProgressMonitor;

	public EclipseProgress(IProgressMonitor eclipseProgressMonitor, int total) {
		super();

		setEclipseProgressMonitor(eclipseProgressMonitor);

		eclipseProgressMonitor.beginTask(getClass().getName(), total);
	}

	public void addProgress(int work) {
		getEclipseProgressMonitor().worked(work);
	}

	private IProgressMonitor getEclipseProgressMonitor() {
		return eclipseProgressMonitor;
	}

	private void setEclipseProgressMonitor(IProgressMonitor eclipseProgressMonitor) {
		this.eclipseProgressMonitor = eclipseProgressMonitor;
	}
}
