/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import org.apache.maven.model.Model;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.wizards.WidthGroup;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MavenArtifactComponent
extends Composite {
    public static final String JAR = "jar";
    public static final String WAR = "war";
    public static final String EAR = "ear";
    public static final String RAR = "rar";
    public static final String POM = "pom";
    public static final String EJB = "ejb";
    public static final String[] PACKAGING_OPTIONS = new String[]{"jar", "pom", "war"};
    public static final String DEFAULT_PACKAGING = "jar";
    public static final String DEFAULT_VERSION = "0.0.1-SNAPSHOT";
    protected Combo groupIdCombo;
    protected Combo artifactIdCombo;
    protected Combo versionCombo;
    protected Combo packagingCombo;
    protected Combo nameCombo;
    protected Text descriptionText;
    private ModifyListener modifyingListener;
    private final Label groupIdlabel;
    private final Label artifactIdLabel;
    private final Label versionLabel;
    private final Label packagingLabel;
    private final Label nameLabel;
    private final Label descriptionLabel;

    public MavenArtifactComponent(Composite parent, int styles) {
        super(parent, styles);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        Group artifactGroup = new Group((Composite)this, 0);
        artifactGroup.setText(Messages.artifactComponentArtifact);
        GridData gd_artifactGroup = new GridData(4, 4, true, true, 3, 1);
        artifactGroup.setLayoutData((Object)gd_artifactGroup);
        artifactGroup.setLayout((Layout)new GridLayout(2, false));
        this.groupIdlabel = new Label((Composite)artifactGroup, 0);
        this.groupIdlabel.setText(Messages.artifactComponentGroupId);
        this.groupIdCombo = new Combo((Composite)artifactGroup, 2048);
        this.groupIdCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.groupIdCombo.setData("name", (Object)"groupIdCombo");
        this.artifactIdLabel = new Label((Composite)artifactGroup, 0);
        this.artifactIdLabel.setText(Messages.artifactComponentArtifactId);
        this.artifactIdCombo = new Combo((Composite)artifactGroup, 2048);
        this.artifactIdCombo.setLayoutData((Object)new GridData(4, 2, false, false));
        this.artifactIdCombo.setData("name", (Object)"artifactIdCombo");
        this.versionLabel = new Label((Composite)artifactGroup, 0);
        this.versionLabel.setText(Messages.artifactComponentVersion);
        this.versionCombo = new Combo((Composite)artifactGroup, 2048);
        this.versionCombo.setLayoutData((Object)new GridData(150, -1));
        this.versionCombo.setText(DEFAULT_VERSION);
        this.versionCombo.setData("name", (Object)"versionCombo");
        this.packagingLabel = new Label((Composite)artifactGroup, 0);
        this.packagingLabel.setText(Messages.artifactComponentPackaging);
        this.packagingCombo = new Combo((Composite)artifactGroup, 0);
        this.packagingCombo.setItems(PACKAGING_OPTIONS);
        this.packagingCombo.setText("jar");
        this.packagingCombo.setLayoutData((Object)new GridData(150, -1));
        this.packagingCombo.setData("name", (Object)"packagingCombo");
        this.nameLabel = new Label((Composite)artifactGroup, 0);
        this.nameLabel.setLayoutData((Object)new GridData());
        this.nameLabel.setText(Messages.artifactComponentName);
        this.nameCombo = new Combo((Composite)artifactGroup, 2048);
        this.nameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameCombo.setData("name", (Object)"nameCombo");
        this.descriptionLabel = new Label((Composite)artifactGroup, 0);
        this.descriptionLabel.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.descriptionLabel.setText(Messages.artifactComponentDescription);
        this.descriptionText = new Text((Composite)artifactGroup, 2624);
        GridData gd_descriptionText = new GridData(4, 4, false, true);
        gd_descriptionText.minimumHeight = 20;
        this.descriptionText.setLayoutData((Object)gd_descriptionText);
        this.descriptionText.setData("name", (Object)"descriptionText");
    }

    public void setModifyingListener(ModifyListener modifyingListener) {
        this.modifyingListener = modifyingListener;
        this.groupIdCombo.addModifyListener(modifyingListener);
        this.artifactIdCombo.addModifyListener(modifyingListener);
        this.versionCombo.addModifyListener(modifyingListener);
        this.packagingCombo.addModifyListener(modifyingListener);
    }

    public void dispose() {
        super.dispose();
        if (this.modifyingListener != null) {
            this.groupIdCombo.removeModifyListener(this.modifyingListener);
            this.artifactIdCombo.removeModifyListener(this.modifyingListener);
            this.versionCombo.removeModifyListener(this.modifyingListener);
            this.packagingCombo.removeModifyListener(this.modifyingListener);
        }
    }

    public boolean setFocus() {
        if (this.groupIdCombo != null) {
            return this.groupIdCombo.setFocus();
        }
        return super.setFocus();
    }

    public String getModelName() {
        return this.nameCombo.getText();
    }

    public String getArtifactId() {
        return this.artifactIdCombo.getText();
    }

    public String getGroupId() {
        return this.groupIdCombo.getText();
    }

    public String getVersion() {
        return this.versionCombo.getText();
    }

    public String getPackaging() {
        return this.packagingCombo.getText();
    }

    public String getDescription() {
        return this.descriptionText.getText();
    }

    public void setModelName(String name) {
        this.nameCombo.setText(name);
    }

    public void setGroupId(String groupId) {
        this.groupIdCombo.setText(groupId);
    }

    public void setArtifactId(String artifact) {
        this.artifactIdCombo.setText(artifact);
    }

    public void setVersion(String version) {
        this.versionCombo.setText(version);
    }

    public void setPackagingTypes(String[] packagingTypes) {
        if (this.packagingCombo != null) {
            this.packagingCombo.setItems(packagingTypes);
        }
    }

    public void setPackaging(String packaging) {
        if (this.packagingCombo != null) {
            this.packagingCombo.setText(packaging);
        }
    }

    public void setDescription(String description) {
        if (this.descriptionText != null) {
            this.descriptionText.setText(description);
        }
    }

    public Model getModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.getGroupId());
        model.setArtifactId(this.getArtifactId());
        model.setVersion(this.getVersion());
        model.setPackaging(this.getPackaging());
        if (this.getModelName().length() > 0) {
            model.setName(this.getModelName());
        }
        if (this.getDescription().length() > 0) {
            model.setDescription(this.getDescription());
        }
        return model;
    }

    public void setArtifactIdEditable(boolean b) {
        this.artifactIdCombo.setEnabled(b);
    }

    public Combo getGroupIdCombo() {
        return this.groupIdCombo;
    }

    public Combo getArtifactIdCombo() {
        return this.artifactIdCombo;
    }

    public Combo getVersionCombo() {
        return this.versionCombo;
    }

    public Combo getNameCombo() {
        return this.nameCombo;
    }

    public void setWidthGroup(WidthGroup widthGroup) {
        widthGroup.addControl((Control)this.groupIdlabel);
        widthGroup.addControl((Control)this.artifactIdLabel);
        widthGroup.addControl((Control)this.versionLabel);
        widthGroup.addControl((Control)this.packagingLabel);
        widthGroup.addControl((Control)this.nameLabel);
        widthGroup.addControl((Control)this.descriptionLabel);
    }
}

