/*
 * Decompiled with CFR 0.152.
 */
package io.nayuki.deflate;

import io.nayuki.deflate.DataFormatException;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;

public final class InflaterInputStream
extends FilterInputStream {
    private byte[] inputBuffer;
    private int inputBufferLength;
    private int inputBufferIndex;
    private long inputBitBuffer;
    private int inputBitBufferLength;
    private int outputBufferLength;
    private int outputBufferIndex;
    private byte[] dictionary;
    private int dictionaryIndex;
    private final boolean isDetachable;
    private int state;
    private IOException exception;
    private boolean isLastBlock;
    private short[] literalLengthCodeTree;
    private short[] literalLengthCodeTable;
    private short[] distanceCodeTree;
    private short[] distanceCodeTable;
    private int markPos = -1;
    private static final int[] CODE_LENGTH_CODE_ORDER;
    private static final short[] FIXED_LITERAL_LENGTH_CODE_TREE;
    private static final short[] FIXED_LITERAL_LENGTH_CODE_TABLE;
    private static final short[] FIXED_DISTANCE_CODE_TREE;
    private static final short[] FIXED_DISTANCE_CODE_TABLE;
    private static final short CODE_TREE_UNUSED_SLOT = 28672;
    private static final short CODE_TREE_OPEN_SLOT = 28674;
    private static final int CODE_TABLE_BITS = 9;
    private static final int CODE_TABLE_MASK = 511;
    private static final int DICTIONARY_LENGTH = 32768;
    private static final int DICTIONARY_MASK = Short.MAX_VALUE;
    private static final int OUTPUT_BUFFER_LENGTH = 257;
    private static final short[] RUN_LENGTH_TABLE;
    private static final int[] DISTANCE_TABLE;

    static {
        int[] nArray = new int[19];
        nArray[0] = 16;
        nArray[1] = 17;
        nArray[2] = 18;
        nArray[4] = 8;
        nArray[5] = 7;
        nArray[6] = 9;
        nArray[7] = 6;
        nArray[8] = 10;
        nArray[9] = 5;
        nArray[10] = 11;
        nArray[11] = 4;
        nArray[12] = 12;
        nArray[13] = 3;
        nArray[14] = 13;
        nArray[15] = 2;
        nArray[16] = 14;
        nArray[17] = 1;
        nArray[18] = 15;
        CODE_LENGTH_CODE_ORDER = nArray;
        byte[] llcodelens = new byte[288];
        Arrays.fill(llcodelens, 0, 144, (byte)8);
        Arrays.fill(llcodelens, 144, 256, (byte)9);
        Arrays.fill(llcodelens, 256, 280, (byte)7);
        Arrays.fill(llcodelens, 280, 288, (byte)8);
        byte[] distcodelens = new byte[32];
        Arrays.fill(distcodelens, (byte)5);
        try {
            FIXED_LITERAL_LENGTH_CODE_TREE = InflaterInputStream.codeLengthsToCodeTree(llcodelens);
            FIXED_DISTANCE_CODE_TREE = InflaterInputStream.codeLengthsToCodeTree(distcodelens);
        }
        catch (DataFormatException e) {
            throw new AssertionError((Object)e);
        }
        FIXED_LITERAL_LENGTH_CODE_TABLE = InflaterInputStream.codeTreeToCodeTable(FIXED_LITERAL_LENGTH_CODE_TREE);
        FIXED_DISTANCE_CODE_TABLE = InflaterInputStream.codeTreeToCodeTable(FIXED_DISTANCE_CODE_TREE);
        RUN_LENGTH_TABLE = new short[]{24, 32, 40, 48, 56, 64, 72, 80, 89, 105, 121, 137, 154, 186, 218, 250, 283, 347, 411, 475, 540, 668, 796, 924, 1053, 1309, 1565, 1821, 2064};
        DISTANCE_TABLE = new int[]{16, 32, 48, 64, 81, 113, 146, 210, 275, 403, 532, 788, 1045, 1557, 2070, 3094, 4119, 6167, 8216, 12312, 16409, 24601, 32794, 49178, 65563, 98331, 131100, 196636, 262173, 393245};
    }

    public InflaterInputStream(InputStream in, boolean detachable) {
        this(in, detachable, 16384);
    }

    public InflaterInputStream(InputStream in, boolean detachable, int inBufLen) {
        super(in);
        if (inBufLen <= 0) {
            throw new IllegalArgumentException("Input buffer size must be positive");
        }
        this.isDetachable = detachable;
        if (detachable) {
            if (in.markSupported()) {
                in.mark(0);
            } else {
                throw new IllegalArgumentException("Input stream not markable, cannot support detachment");
            }
        }
        this.inputBuffer = new byte[inBufLen];
        this.inputBufferLength = 0;
        this.inputBufferIndex = 0;
        this.inputBitBuffer = 0L;
        this.inputBitBufferLength = 0;
        this.outputBufferLength = 0;
        this.outputBufferIndex = 0;
        this.dictionary = new byte[32768];
        this.dictionaryIndex = 0;
        this.state = 0;
        this.exception = null;
        this.isLastBlock = false;
        this.literalLengthCodeTree = null;
        this.literalLengthCodeTable = null;
        this.distanceCodeTree = null;
        this.distanceCodeTable = null;
    }

    public InflaterInputStream(InflaterInputStream copy) {
        this(copy.in, copy.isDetachable);
        if (copy.inputBuffer != null) {
            this.inputBuffer = Arrays.copyOf(copy.inputBuffer, copy.inputBuffer.length);
        }
        this.inputBufferLength = copy.inputBufferLength;
        this.inputBufferIndex = copy.inputBufferIndex;
        this.inputBitBuffer = copy.inputBitBuffer;
        this.inputBitBufferLength = copy.inputBitBufferLength;
        this.outputBufferLength = copy.outputBufferLength;
        this.outputBufferIndex = copy.outputBufferIndex;
        this.dictionary = (byte[])(copy.dictionary != null ? Arrays.copyOf(copy.dictionary, copy.dictionary.length) : null);
        this.dictionaryIndex = copy.dictionaryIndex;
        this.markPos = copy.markPos;
        this.state = copy.state;
        if (copy.exception != null) {
            this.exception = new IOException(copy.exception.toString());
        }
        this.isLastBlock = copy.isLastBlock;
        if (copy.literalLengthCodeTree != null) {
            this.literalLengthCodeTree = Arrays.copyOf(copy.literalLengthCodeTree, copy.literalLengthCodeTree.length);
        }
        if (copy.literalLengthCodeTable != null) {
            this.literalLengthCodeTable = Arrays.copyOf(copy.literalLengthCodeTable, copy.literalLengthCodeTable.length);
        }
        if (copy.distanceCodeTree != null) {
            this.distanceCodeTree = Arrays.copyOf(copy.distanceCodeTree, copy.distanceCodeTree.length);
        }
        if (copy.distanceCodeTable != null) {
            this.distanceCodeTable = Arrays.copyOf(copy.distanceCodeTable, copy.distanceCodeTable.length);
        }
    }

    @Override
    public int read() throws IOException {
        block5: while (true) {
            byte[] b = new byte[1];
            switch (this.read(b)) {
                case 1: {
                    return b[0] & 0xFF;
                }
                case 0: {
                    continue block5;
                }
                case -1: {
                    return -1;
                }
            }
            break;
        }
        throw new AssertionError();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Objects.requireNonNull(b);
        if (off < 0 || off > b.length || len < 0 || b.length - off < len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.in == null) {
            throw new IllegalStateException("Stream already closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (len == 0) {
            return this.outputBufferLength > 0 || this.state != 0 || this.isLastBlock == false ? 0 : -1;
        }
        if (!InflaterInputStream.$assertionsDisabled && len <= 0) {
            throw new AssertionError();
        }
        result = 0;
        if (this.outputBufferLength > 0) {
            if (this.markPos == -2) {
                this.markPos = this.dictionaryIndex - (this.outputBufferLength - this.outputBufferIndex) & 32767;
            }
            n = Math.min(this.outputBufferLength - this.outputBufferIndex, len);
            i = this.dictionaryIndex - (this.outputBufferLength - this.outputBufferIndex) & 32767;
            n1 = Math.min(n, 32768 - i);
            System.arraycopy(this.dictionary, i, b, off + result, n1);
            result = n1;
            this.outputBufferIndex += n1;
            if (n1 < n) {
                n1 = n - n1;
                System.arraycopy(this.dictionary, 0, b, off + result, n1);
                result += n1;
                this.outputBufferIndex += n1;
            }
            if (this.outputBufferIndex == this.outputBufferLength) {
                this.outputBufferLength = 0;
                this.outputBufferIndex = 0;
            }
            if (result == len) {
                return result;
            }
        }
        if (InflaterInputStream.$assertionsDisabled || this.outputBufferLength == 0 && this.outputBufferIndex == 0 && result < len) ** GOTO lbl61
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if (this.isLastBlock) {
                return result != 0 ? result : -1;
            }
            this.isLastBlock = this.readBits(1) == 1;
            switch (this.readBits(2)) {
                case 0: {
                    this.alignInputToByte();
                    this.state = this.readBits(16);
                    if (this.state == (this.readBits(16) ^ 65535)) continue block6;
                    this.destroyAndThrow(new DataFormatException("len/nlen mismatch in uncompressed block"));
                    break;
                }
                case 1: {
                    this.state = -1;
                    this.literalLengthCodeTree = InflaterInputStream.FIXED_LITERAL_LENGTH_CODE_TREE;
                    this.literalLengthCodeTable = InflaterInputStream.FIXED_LITERAL_LENGTH_CODE_TABLE;
                    this.distanceCodeTree = InflaterInputStream.FIXED_DISTANCE_CODE_TREE;
                    this.distanceCodeTable = InflaterInputStream.FIXED_DISTANCE_CODE_TABLE;
                    break;
                }
                case 2: {
                    this.state = -1;
                    this.decodeHuffmanCodes();
                    break;
                }
                case 3: {
                    this.destroyAndThrow(new DataFormatException("Reserved block type"));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
lbl61:
            // 6 sources

            ** while (this.state == 0)
        }
lbl62:
        // 1 sources

        if (1 <= this.state && this.state <= 65535) {
            toRead = Math.min(this.state, len - result);
            this.readBytes(b, off + result, toRead);
            this.updateMark(this.dictionaryIndex, toRead);
            i = 0;
            while (i < toRead) {
                this.dictionary[this.dictionaryIndex] = b[off + result];
                this.dictionaryIndex = this.dictionaryIndex + 1 & 32767;
                ++result;
                ++i;
            }
            this.state -= toRead;
            return result;
        }
        if (this.state == -1) {
            return result + this.readInsideHuffmanBlock(b, off + result, len - result);
        }
        if (this.state == -4) {
            n = Math.min(this.inputBufferLength - this.inputBufferIndex + (this.inputBitBufferLength >> 3), len - result);
            if (n > 0) {
                this.readBytes(b, off + result, n);
                result += n;
            } else if (result < len) {
                n = len - result;
                r = this.in.read(b, off + result, n);
                if (r >= 0) {
                    result += r;
                } else if (result == 0) {
                    result = r;
                }
            }
            return result;
        }
        throw new AssertionError((Object)"Impossible state");
    }

    @Override
    public void mark(int limit) {
        if (limit > 32511) {
            throw new IllegalArgumentException(String.valueOf(limit));
        }
        if (this.state == -4) {
            throw new IllegalStateException(String.valueOf(this.state));
        }
        this.markPos = -2;
    }

    @Override
    public void reset() throws IOException {
        if (this.state == -4) {
            throw new IllegalStateException(String.valueOf(this.state));
        }
        if (this.markPos >= 0) {
            int toread = this.dictionaryIndex > this.markPos ? this.dictionaryIndex - this.markPos : 32768 - this.markPos + this.dictionaryIndex;
            if (this.outputBufferLength > toread) {
                assert (this.outputBufferIndex >= this.outputBufferLength - toread);
                this.outputBufferIndex = this.outputBufferLength - toread;
            } else {
                this.outputBufferLength = toread;
                this.outputBufferIndex = 0;
            }
        } else {
            if (this.markPos == -3) {
                throw new IOException("too far");
            }
            if (this.markPos != -2) {
                if (this.markPos == -1) {
                    throw new IOException("no mark");
                }
                throw new IllegalStateException(String.valueOf(this.markPos));
            }
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int available() throws IOException {
        long input;
        int actual = this.outputBufferLength - this.outputBufferIndex;
        if (this.state == -4) {
            input = this.inputBufferLength - this.inputBufferIndex + (this.inputBitBufferLength >> 3);
        } else {
            input = this.inputBufferLength - this.inputBufferIndex + (this.inputBitBufferLength >> 3);
            if (this.state > 0) {
                if (input > (long)this.state) {
                    input = this.state;
                }
            } else {
                input = this.state == -1 && input >= 3L ? 0L : 0L;
            }
        }
        return (int)Math.min((long)actual + input, Integer.MAX_VALUE);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long skipped = 0L;
        if (this.outputBufferLength >= 0) {
            if (this.markPos == -2) {
                this.markPos = this.dictionaryIndex - (this.outputBufferLength - this.outputBufferIndex) & Short.MAX_VALUE;
            }
            if (n >= (long)(this.outputBufferLength - this.outputBufferIndex)) {
                skipped = this.outputBufferLength - this.outputBufferIndex;
                this.outputBufferLength = 0;
                this.outputBufferIndex = 0;
                n -= skipped;
            } else {
                this.outputBufferIndex = (int)((long)this.outputBufferIndex + n);
                return n;
            }
        }
        byte[] buf = null;
        while (n > 0L) {
            long r;
            int toskip = (int)Math.min(n, 16384L);
            if (buf == null) {
                buf = new byte[toskip];
            }
            if ((r = (long)this.read(buf, 0, toskip)) == -1L) break;
            skipped += r;
            n -= r;
        }
        return skipped;
    }

    private void updateMark(int dictionaryIndex, int count) {
        if (this.markPos == -1) {
            return;
        }
        if (this.markPos == -2) {
            this.markPos = count <= 32768 ? dictionaryIndex : -3;
        } else if (count >= 32768) {
            this.markPos = -3;
        } else if (this.markPos >= dictionaryIndex) {
            if (dictionaryIndex + count >= this.markPos) {
                this.markPos = -3;
            } else if ((dictionaryIndex + count & Short.MAX_VALUE) >= this.markPos) {
                this.markPos = -3;
            }
        }
    }

    private void endofblock() {
        if (this.isLastBlock && this.markPos < 0 && this.outputBufferLength <= 0) {
            this.dictionary = null;
            this.dictionaryIndex = -1;
        }
    }

    private int readInsideHuffmanBlock(byte[] b, int off, int len) throws IOException {
        int result = 0;
        while (result < len) {
            byte bb;
            int i;
            int dictReadIndex;
            int dist;
            int distSym;
            int run;
            int sym;
            if (this.inputBitBufferLength < 48) {
                byte[] c = this.inputBuffer;
                int i2 = this.inputBufferIndex;
                int numBytes = Math.min(64 - this.inputBitBufferLength >>> 3, this.inputBufferLength - i2);
                assert (numBytes >= 0 && numBytes <= 8);
                if (numBytes == 2) {
                    this.inputBitBuffer |= (long)(c[i2] & 0xFF | (c[i2 + 1] & 0xFF) << 8) << this.inputBitBufferLength;
                    this.inputBitBufferLength += 16;
                    this.inputBufferIndex += 2;
                } else if (numBytes == 3) {
                    this.inputBitBuffer |= (long)(c[i2] & 0xFF | (c[i2 + 1] & 0xFF) << 8 | (c[i2 + 2] & 0xFF) << 16) << this.inputBitBufferLength;
                    this.inputBitBufferLength += 24;
                    this.inputBufferIndex += 3;
                } else if (numBytes == 4) {
                    this.inputBitBuffer |= ((long)(c[i2] & 0xFF | (c[i2 + 1] & 0xFF) << 8 | (c[i2 + 2] & 0xFF) << 16 | c[i2 + 3] << 24) & 0xFFFFFFFFL) << this.inputBitBufferLength;
                    this.inputBitBufferLength += 32;
                    this.inputBufferIndex += 4;
                } else {
                    int j = 0;
                    while (j < numBytes) {
                        this.inputBitBuffer |= ((long)c[this.inputBufferIndex] & 0xFFL) << this.inputBitBufferLength;
                        ++j;
                        this.inputBitBufferLength += 8;
                        ++this.inputBufferIndex;
                    }
                }
            }
            if (this.inputBitBufferLength >= 48) {
                short temp = this.literalLengthCodeTable[(int)this.inputBitBuffer & 0x1FF];
                assert (temp >= 0);
                int consumed = temp >>> 11;
                this.inputBitBuffer >>>= consumed;
                this.inputBitBufferLength -= consumed;
                int node = temp << 21 >> 21;
                while (node >= 0) {
                    node = this.literalLengthCodeTree[node + ((int)this.inputBitBuffer & 1)];
                    this.inputBitBuffer >>>= 1;
                    --this.inputBitBufferLength;
                }
                sym = ~node;
                assert (sym >= 0 && sym <= 287);
                if (sym < 256) {
                    b[off + result] = (byte)sym;
                    this.updateMark(this.dictionaryIndex, 1);
                    this.dictionary[this.dictionaryIndex] = (byte)sym;
                    this.dictionaryIndex = this.dictionaryIndex + 1 & Short.MAX_VALUE;
                    ++result;
                    continue;
                }
                if (sym > 256) {
                    assert (257 <= sym && sym <= 287);
                    if (sym > 285) {
                        this.destroyAndThrow(new DataFormatException("Reserved run length symbol: " + sym));
                    }
                    short temp2 = RUN_LENGTH_TABLE[sym - 257];
                    run = temp2 >>> 3;
                    int numExtraBits = temp2 & 7;
                    this.inputBitBuffer >>>= numExtraBits;
                    this.inputBitBufferLength -= numExtraBits;
                    assert (3 <= (run += (int)this.inputBitBuffer & (1 << numExtraBits) - 1) && run <= 258);
                    if (this.distanceCodeTree == null) {
                        this.destroyAndThrow(new DataFormatException("Length symbol encountered with empty distance code"));
                    }
                    short temp3 = this.distanceCodeTable[(int)this.inputBitBuffer & 0x1FF];
                    assert (temp3 >= 0);
                    int consumed2 = temp3 >>> 11;
                    this.inputBitBuffer >>>= consumed2;
                    this.inputBitBufferLength -= consumed2;
                    int node2 = temp3 << 21 >> 21;
                    while (node2 >= 0) {
                        node2 = this.distanceCodeTree[node2 + ((int)this.inputBitBuffer & 1)];
                        this.inputBitBuffer >>>= 1;
                        --this.inputBitBufferLength;
                    }
                    distSym = ~node2;
                    assert (distSym >= 0 && distSym <= 31);
                    if (distSym > 29) {
                        this.destroyAndThrow(new DataFormatException("Reserved distance symbol: " + distSym));
                    }
                    int temp4 = DISTANCE_TABLE[distSym];
                    dist = temp4 >>> 4;
                    int numExtraBits2 = temp4 & 0xF;
                    this.inputBitBuffer >>>= numExtraBits2;
                    this.inputBitBufferLength -= numExtraBits2;
                    assert (1 <= (dist += (int)this.inputBitBuffer & (1 << numExtraBits2) - 1) && dist <= 32768);
                    assert (this.inputBitBufferLength >= 0);
                    dictReadIndex = this.dictionaryIndex - dist & Short.MAX_VALUE;
                    if (len - result >= run) {
                        this.updateMark(this.dictionaryIndex, run);
                        i = 0;
                        while (i < run) {
                            this.dictionary[this.dictionaryIndex] = bb = this.dictionary[dictReadIndex];
                            b[off + result] = bb;
                            dictReadIndex = dictReadIndex + 1 & Short.MAX_VALUE;
                            this.dictionaryIndex = this.dictionaryIndex + 1 & Short.MAX_VALUE;
                            ++result;
                            ++i;
                        }
                        continue;
                    }
                    assert (this.outputBufferLength == 0);
                    this.updateMark(this.dictionaryIndex, run);
                    i = 0;
                    while (i < run) {
                        this.dictionary[this.dictionaryIndex] = bb = this.dictionary[dictReadIndex];
                        dictReadIndex = dictReadIndex + 1 & Short.MAX_VALUE;
                        this.dictionaryIndex = this.dictionaryIndex + 1 & Short.MAX_VALUE;
                        if (result < len) {
                            b[off + result] = bb;
                            ++result;
                        } else {
                            assert (this.outputBufferLength < 32768);
                            assert (this.outputBufferLength < 257);
                            ++this.outputBufferLength;
                        }
                        ++i;
                    }
                    continue;
                }
                this.literalLengthCodeTree = null;
                this.literalLengthCodeTable = null;
                this.distanceCodeTree = null;
                this.distanceCodeTable = null;
                this.state = 0;
                this.endofblock();
                break;
            }
            sym = this.decodeSymbol(this.literalLengthCodeTree);
            assert (sym >= 0 && sym <= 287);
            if (sym < 256) {
                b[off + result] = (byte)sym;
                this.updateMark(this.dictionaryIndex, 1);
                this.dictionary[this.dictionaryIndex] = (byte)sym;
                this.dictionaryIndex = this.dictionaryIndex + 1 & Short.MAX_VALUE;
                ++result;
                continue;
            }
            if (sym > 256) {
                run = this.decodeRunLength(sym);
                assert (3 <= run && run <= 258);
                if (this.distanceCodeTree == null) {
                    this.destroyAndThrow(new DataFormatException("Length symbol encountered with empty distance code"));
                }
                distSym = this.decodeSymbol(this.distanceCodeTree);
                assert (distSym >= 0 && distSym <= 31);
                dist = this.decodeDistance(distSym);
                assert (1 <= dist && dist <= 32768);
                assert (this.outputBufferLength == 0);
                dictReadIndex = this.dictionaryIndex - dist & Short.MAX_VALUE;
                this.updateMark(this.dictionaryIndex, run);
                i = 0;
                while (i < run) {
                    bb = this.dictionary[dictReadIndex];
                    dictReadIndex = dictReadIndex + 1 & Short.MAX_VALUE;
                    this.dictionary[this.dictionaryIndex] = bb;
                    this.dictionaryIndex = this.dictionaryIndex + 1 & Short.MAX_VALUE;
                    if (result < len) {
                        b[off + result] = bb;
                        ++result;
                    } else {
                        assert (this.outputBufferLength < 32768);
                        assert (this.outputBufferLength < 257);
                        ++this.outputBufferLength;
                    }
                    ++i;
                }
                continue;
            }
            this.literalLengthCodeTree = null;
            this.literalLengthCodeTable = null;
            this.distanceCodeTree = null;
            this.distanceCodeTable = null;
            this.state = 0;
            this.endofblock();
            break;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public void detach() throws IOException {
        if (this.in == null) {
            throw new IllegalStateException("Input stream already detached/closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (!this.isDetachable) {
            if (this.state == -4) {
                throw new IllegalStateException("Input stream already detached");
            }
            this.endofblock();
            this.state = -4;
            return;
        }
        this.in.reset();
        skip = this.inputBufferIndex - this.inputBitBufferLength / 8;
        if (InflaterInputStream.$assertionsDisabled || skip >= 0) ** GOTO lbl19
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            n = this.in.skip(skip);
            if (n <= 0L) {
                throw new EOFException();
            }
            skip = (int)((long)skip - n);
lbl19:
            // 2 sources

            ** while (skip > 0)
        }
lbl20:
        // 1 sources

        this.in = null;
        this.state = -3;
        this.destroyState();
    }

    public void attach() {
        if (this.state != -4) {
            throw new IllegalStateException("Not detached");
        }
        if (this.dictionary == null) {
            this.dictionary = new byte[32768];
            this.dictionaryIndex = 0;
        }
        this.isLastBlock = false;
        this.state = 0;
    }

    public String toString() {
        return this.getClass() + " " + this.state + " " + (this.dictionary == null ? "no buf" : (Object)this.dictionary);
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        super.close();
        this.in = null;
        this.state = -3;
        this.exception = null;
        this.destroyState();
    }

    private void decodeHuffmanCodes() throws IOException {
        short[] codeLenCodeTree;
        int numLitLenCodes = this.readBits(5) + 257;
        int numDistCodes = this.readBits(5) + 1;
        int numCodeLenCodes = this.readBits(4) + 4;
        byte[] codeLenCodeLen = new byte[19];
        int i = 0;
        while (i < numCodeLenCodes) {
            codeLenCodeLen[InflaterInputStream.CODE_LENGTH_CODE_ORDER[i]] = (byte)this.readBits(3);
            ++i;
        }
        try {
            codeLenCodeTree = InflaterInputStream.codeLengthsToCodeTree(codeLenCodeLen);
        }
        catch (DataFormatException e) {
            this.destroyAndThrow(e);
            throw new AssertionError((Object)"Unreachable");
        }
        byte[] codeLens = new byte[numLitLenCodes + numDistCodes];
        int runVal = -1;
        int runLen = 0;
        int i2 = 0;
        while (i2 < codeLens.length) {
            if (runLen > 0) {
                assert (runVal != -1);
                codeLens[i2] = runVal;
                --runLen;
                ++i2;
                continue;
            }
            int sym = this.decodeSymbol(codeLenCodeTree);
            assert (sym >= 0 && sym <= 18);
            if (sym < 16) {
                codeLens[i2] = (byte)sym;
                runVal = codeLens[i2];
                ++i2;
                continue;
            }
            if (sym == 16) {
                if (runVal == -1) {
                    this.destroyAndThrow(new DataFormatException("No code length value to copy"));
                }
                runLen = this.readBits(2) + 3;
                continue;
            }
            if (sym == 17) {
                runVal = 0;
                runLen = this.readBits(3) + 3;
                continue;
            }
            runVal = 0;
            runLen = this.readBits(7) + 11;
        }
        if (runLen > 0) {
            this.destroyAndThrow(new DataFormatException("Run exceeds number of codes"));
        }
        byte[] litLenCodeLen = Arrays.copyOf(codeLens, numLitLenCodes);
        try {
            this.literalLengthCodeTree = InflaterInputStream.codeLengthsToCodeTree(litLenCodeLen);
        }
        catch (DataFormatException e) {
            this.destroyAndThrow(e);
            throw new AssertionError((Object)"Unreachable");
        }
        this.literalLengthCodeTable = InflaterInputStream.codeTreeToCodeTable(this.literalLengthCodeTree);
        byte[] distCodeLen = Arrays.copyOfRange(codeLens, numLitLenCodes, codeLens.length);
        if (distCodeLen.length == 1 && distCodeLen[0] == 0) {
            this.distanceCodeTree = null;
        } else {
            int oneCount = 0;
            int otherPositiveCount = 0;
            byte[] byArray = distCodeLen;
            int n = distCodeLen.length;
            int n2 = 0;
            while (n2 < n) {
                byte x = byArray[n2];
                if (x == 1) {
                    ++oneCount;
                } else if (x > 1) {
                    ++otherPositiveCount;
                }
                ++n2;
            }
            if (oneCount == 1 && otherPositiveCount == 0) {
                distCodeLen = Arrays.copyOf(distCodeLen, 32);
                distCodeLen[31] = 1;
            }
            try {
                this.distanceCodeTree = InflaterInputStream.codeLengthsToCodeTree(distCodeLen);
            }
            catch (DataFormatException e) {
                this.destroyAndThrow(e);
                throw new AssertionError((Object)"Unreachable");
            }
            this.distanceCodeTable = InflaterInputStream.codeTreeToCodeTable(this.distanceCodeTree);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static short[] codeLengthsToCodeTree(byte[] codeLengths) throws DataFormatException {
        result = new short[(codeLengths.length - 1) * 2];
        Arrays.fill(result, (short)28672);
        result[0] = 28674;
        result[1] = 28674;
        allocated = 2;
        maxCodeLen = 0;
        var7_4 = codeLengths;
        var6_5 = codeLengths.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            cl = var7_4[var5_6];
            if (!(InflaterInputStream.$assertionsDisabled || cl >= 0 && cl <= 15)) {
                throw new AssertionError();
            }
            maxCodeLen = Math.max(cl, maxCodeLen);
            ++var5_6;
        }
        if (maxCodeLen > 15) {
            throw new AssertionError((Object)"Maximum code length exceeds DEFLATE specification");
        }
        curCodeLen = 1;
        while (curCodeLen <= maxCodeLen) {
            resultIndex = 0;
            symbol = 0;
            while (true) {
                if (symbol < codeLengths.length && codeLengths[symbol] != curCodeLen) {
                    ++symbol;
                    continue;
                }
                if (symbol != codeLengths.length) ** GOTO lbl30
                break;
lbl-1000:
                // 1 sources

                {
                    ++resultIndex;
lbl30:
                    // 2 sources

                    ** while (resultIndex < allocated && result[resultIndex] != 28674)
                }
lbl31:
                // 1 sources

                if (resultIndex == allocated) {
                    throw new DataFormatException("Canonical code fails to produce full Huffman code tree");
                }
                result[resultIndex] = (short)(~symbol);
                ++resultIndex;
                ++symbol;
            }
            end = allocated;
            while (resultIndex < end) {
                if (result[resultIndex] == 28674) {
                    if (!InflaterInputStream.$assertionsDisabled && allocated + 2 > result.length) {
                        throw new AssertionError();
                    }
                    result[resultIndex] = (short)allocated;
                    result[allocated + 0] = 28674;
                    result[allocated + 1] = 28674;
                    allocated += 2;
                }
                ++resultIndex;
            }
            ++curCodeLen;
        }
        i = 0;
        while (i < allocated) {
            if (result[i] == 28674) {
                throw new DataFormatException("Canonical code fails to produce full Huffman code tree");
            }
            ++i;
        }
        return result;
    }

    private static short[] codeTreeToCodeTable(short[] codeTree) {
        short[] result = new short[512];
        int i = 0;
        while (i < result.length) {
            int node = 0;
            int consumed = 0;
            while ((node = codeTree[node + (i >>> consumed & 1)]) >= 0 && ++consumed < 9) {
            }
            assert (1 <= consumed && consumed <= 15);
            assert (-1024 <= node && node <= 1023);
            result[i] = (short)(consumed << 11 | node & 0x7FF);
            assert (result[i] >= 0);
            ++i;
        }
        return result;
    }

    private int decodeSymbol(short[] codeTree) throws IOException {
        int node = 0;
        while (node >= 0) {
            if (this.inputBitBufferLength > 0) {
                node = codeTree[node + ((int)this.inputBitBuffer & 1)];
                this.inputBitBuffer >>>= 1;
                --this.inputBitBufferLength;
                continue;
            }
            node = codeTree[node + this.readBits(1)];
        }
        return ~node;
    }

    private int decodeRunLength(int sym) throws IOException {
        assert (257 <= sym && sym <= 287);
        if (sym <= 264) {
            return sym - 254;
        }
        if (sym <= 284) {
            int numExtraBits = sym - 261 >>> 2;
            return ((sym - 1 & 3 | 4) << numExtraBits) + 3 + this.readBits(numExtraBits);
        }
        if (sym == 285) {
            return 258;
        }
        this.destroyAndThrow(new DataFormatException("Reserved run length symbol: " + sym));
        throw new AssertionError((Object)"Unreachable");
    }

    private int decodeDistance(int sym) throws IOException {
        assert (sym >= 0 && sym <= 31);
        if (sym <= 3) {
            return sym + 1;
        }
        if (sym <= 29) {
            int numExtraBits = (sym >>> 1) - 1;
            return ((sym & 1 | 2) << numExtraBits) + 1 + this.readBits(numExtraBits);
        }
        this.destroyAndThrow(new DataFormatException("Reserved distance symbol: " + sym));
        throw new AssertionError((Object)"Unreachable");
    }

    /*
     * Unable to fully structure code
     */
    private int readBits(int numBits) throws IOException {
        if (!(InflaterInputStream.$assertionsDisabled || 1 <= numBits && numBits <= 16)) {
            throw new AssertionError();
        }
        if (!(InflaterInputStream.$assertionsDisabled || this.inputBitBufferLength >= 0 && this.inputBitBufferLength <= 63)) {
            throw new AssertionError();
        }
        if (InflaterInputStream.$assertionsDisabled || this.inputBitBuffer >>> this.inputBitBufferLength == 0L) ** GOTO lbl22
        throw new AssertionError();
        {
            this.fillInputBuffer();
            do {
                if (this.inputBufferIndex >= this.inputBufferLength) continue block0;
                numBytes = Math.min(64 - this.inputBitBufferLength >>> 3, this.inputBufferLength - this.inputBufferIndex);
                if (numBytes <= 0) {
                    throw new AssertionError((Object)"Impossible state");
                }
                i = 0;
                while (i < numBytes) {
                    this.inputBitBuffer |= ((long)this.inputBuffer[this.inputBufferIndex] & 255L) << this.inputBitBufferLength;
                    ++i;
                    this.inputBitBufferLength += 8;
                    ++this.inputBufferIndex;
                }
                if (!InflaterInputStream.$assertionsDisabled && this.inputBitBufferLength > 64) {
                    throw new AssertionError();
                }
lbl22:
                // 3 sources

            } while (this.inputBitBufferLength < numBits);
        }
        result = (int)this.inputBitBuffer & (1 << numBits) - 1;
        this.inputBitBuffer >>>= numBits;
        this.inputBitBufferLength -= numBits;
        if (!InflaterInputStream.$assertionsDisabled && result >>> numBits != 0) {
            throw new AssertionError();
        }
        if (!(InflaterInputStream.$assertionsDisabled || this.inputBitBufferLength >= 0 && this.inputBitBufferLength <= 63)) {
            throw new AssertionError();
        }
        if (!InflaterInputStream.$assertionsDisabled && this.inputBitBuffer >>> this.inputBitBufferLength != 0L) {
            throw new AssertionError();
        }
        return result;
    }

    private void readBytes(byte[] b, int off, int len) throws IOException {
        if (this.inputBitBufferLength < 0 || this.inputBitBufferLength > 63 || this.inputBitBuffer >>> this.inputBitBufferLength != 0L) {
            throw new AssertionError((Object)"Invalid input bit buffer state");
        }
        this.alignInputToByte();
        while (len > 0 && this.inputBitBufferLength >= 8) {
            b[off] = (byte)this.inputBitBuffer;
            this.inputBitBuffer >>>= 8;
            this.inputBitBufferLength -= 8;
            ++off;
            --len;
        }
        int n = Math.min(len, this.inputBufferLength - this.inputBufferIndex);
        assert (this.inputBitBufferLength == 0 || n == 0);
        System.arraycopy(this.inputBuffer, this.inputBufferIndex, b, off, n);
        this.inputBufferIndex += n;
        off += n;
        len -= n;
        while (len > 0) {
            assert (this.inputBufferIndex == this.inputBufferLength);
            n = this.in.read(b, off, len);
            if (n == -1) {
                this.destroyAndThrow(new EOFException("Unexpected end of stream"));
            }
            off += n;
            len -= n;
        }
    }

    private void fillInputBuffer() throws IOException {
        if (this.state < -1) {
            throw new AssertionError((Object)"Must not read in this state");
        }
        if (this.inputBufferIndex < this.inputBufferLength) {
            throw new AssertionError((Object)"Input buffer not fully consumed yet");
        }
        if (this.isDetachable) {
            this.in.mark(this.inputBuffer.length);
        }
        this.inputBufferLength = this.in.read(this.inputBuffer);
        this.inputBufferIndex = 0;
        if (this.inputBufferLength == -1) {
            this.destroyAndThrow(new EOFException("Unexpected end of stream"));
        }
        if (this.inputBufferLength < -1 || this.inputBufferLength > this.inputBuffer.length) {
            throw new AssertionError();
        }
    }

    private void alignInputToByte() {
        int discard = this.inputBitBufferLength & 7;
        this.inputBitBuffer >>>= discard;
        this.inputBitBufferLength -= discard;
        assert (this.inputBitBufferLength % 8 == 0);
    }

    private void destroyAndThrow(IOException e) throws IOException {
        this.state = -2;
        this.exception = e;
        this.destroyState();
        throw e;
    }

    private void destroyState() {
        this.isLastBlock = true;
        this.literalLengthCodeTree = null;
        this.literalLengthCodeTable = null;
        this.distanceCodeTree = null;
        this.distanceCodeTable = null;
        this.inputBuffer = null;
        this.inputBufferLength = 0;
        this.inputBufferIndex = 0;
        this.inputBitBuffer = 0L;
        this.inputBitBufferLength = 0;
        this.outputBufferLength = 0;
        this.outputBufferIndex = 0;
        this.dictionary = null;
        this.dictionaryIndex = 0;
    }
}

