/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.labels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.labels.BooleanLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.ClassLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.DynamicEObjectImplLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.EAnnotationLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.EGenericTypeLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.ENamedElementLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.EObjectLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.EcoreURILabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.ElementIdLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.ExpressionInOCLLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.FileLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.ModelLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.NameableLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.NumberLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.ResourceLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.StringLabelGenerator;
import org.eclipse.ocl.pivot.internal.labels.ValueLabelGenerator;
import org.eclipse.ocl.pivot.internal.plugin.LabelGeneratorRegistryReader;
import org.eclipse.ocl.pivot.labels.DefaultLabelGeneratorBuilder;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;

public class LabelGeneratorRegistry
implements ILabelGenerator.Registry {
    protected final @Nullable ILabelGenerator.Registry delegate;
    private final @NonNull Map<Class<?>, Object> map = new HashMap();

    public static @NonNull String debugLabelFor(@NonNull Object object) {
        HashMap options = new HashMap();
        options.put(ILabelGenerator.Builder.SHOW_CLASS_SIMPLE_NAME, Boolean.TRUE);
        DefaultLabelGeneratorBuilder result = new DefaultLabelGeneratorBuilder(INSTANCE, object, options);
        result.buildLabelFor(object);
        return result.toString();
    }

    public static @NonNull LabelGeneratorRegistry init() {
        return new Global();
    }

    public static void initialize(@NonNull ILabelGenerator.Registry registry) {
        BooleanLabelGenerator.initialize(registry);
        ClassLabelGenerator.initialize(registry);
        DynamicEObjectImplLabelGenerator.initialize(registry);
        EAnnotationLabelGenerator.initialize(registry);
        EGenericTypeLabelGenerator.initialize(registry);
        ENamedElementLabelGenerator.initialize(registry);
        EObjectLabelGenerator.initialize(registry);
        EcoreURILabelGenerator.initialize(registry);
        ElementIdLabelGenerator.initialize(registry);
        ExpressionInOCLLabelGenerator.initialize(registry);
        FileLabelGenerator.initialize(registry);
        ModelLabelGenerator.initialize(registry);
        NameableLabelGenerator.initialize(registry);
        NumberLabelGenerator.initialize(registry);
        ResourceLabelGenerator.initialize(registry);
        StringLabelGenerator.initialize(registry);
        ValueLabelGenerator.initialize(registry);
    }

    private LabelGeneratorRegistry() {
        this.delegate = null;
    }

    public LabelGeneratorRegistry(@Nullable ILabelGenerator.Registry delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> void buildLabelFor(@NonNull ILabelGenerator.Builder s, @Nullable T labelledObject) {
        String showQualifier;
        EObject eContainer;
        if (labelledObject == null) {
            s.appendString("<null-Object>");
            return;
        }
        Boolean showClassName = s.getOption(ILabelGenerator.Builder.SHOW_CLASS_NAME);
        if (showClassName != null && showClassName == Boolean.TRUE) {
            s.appendString(labelledObject.getClass().getName());
            s.appendString(" ");
        } else {
            Boolean showClassSimpleName = s.getOption(ILabelGenerator.Builder.SHOW_CLASS_SIMPLE_NAME);
            if (showClassSimpleName != null && showClassSimpleName == Boolean.TRUE) {
                s.appendString(labelledObject.getClass().getSimpleName());
                s.appendString(" ");
            }
        }
        if (labelledObject instanceof EObject && (eContainer = ((EObject)labelledObject).eContainer()) != null && (showQualifier = s.getOption(ILabelGenerator.Builder.SHOW_QUALIFIER)) != null) {
            this.buildLabelFor(s, eContainer);
            if (s.toString().length() > 0) {
                s.appendString(showQualifier);
            }
        }
        if (labelledObject instanceof ILabelGenerator.Self) {
            ((ILabelGenerator.Self)labelledObject).buildLabel(s);
            return;
        }
        this.buildSubLabelFor(s, labelledObject);
    }

    @Override
    public <T> void buildSubLabelFor(@NonNull ILabelGenerator.Builder labelBuilder, @Nullable T labelledObject) {
        if (labelledObject == null) {
            labelBuilder.appendString("<null-Object>");
            return;
        }
        Class<?> labelledObjectClass = labelledObject.getClass();
        ILabelGenerator<?> labelGenerator = this.get(labelledObjectClass);
        if (labelGenerator == null && (labelGenerator = this.getLabelGenerator(labelledObjectClass)) != null) {
            this.install(labelledObjectClass, labelGenerator);
        }
        if (labelGenerator != null) {
            ILabelGenerator<?> castLabelGenerator = labelGenerator;
            castLabelGenerator.buildLabelFor(labelBuilder, labelledObject);
            return;
        }
        this.getLabelGenerator(labelledObjectClass);
        labelBuilder.appendString("<unknown-");
        labelBuilder.appendString(labelledObjectClass.getSimpleName());
        labelBuilder.appendString(" ");
        labelBuilder.appendString(labelledObject.toString());
        labelBuilder.appendString(">");
    }

    public @NonNull ILabelGenerator.Builder createDefaultLabelBuilder(@Nullable Object labelledObject, @Nullable Map<ILabelGenerator.Option<?>, Object> options) {
        return new DefaultLabelGeneratorBuilder(this, labelledObject, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable ILabelGenerator<?> get(@NonNull Class<?> labelledClass) {
        ILabelGenerator<?> object;
        Map<Class<?>, Object> map = this.map;
        synchronized (map) {
            object = this.map.get(labelledClass);
            if (object instanceof ILabelGenerator.Descriptor) {
                object = ((ILabelGenerator.Descriptor)((Object)object)).getLabelGenerator();
                this.map.put(labelledClass, object);
            }
        }
        if (object != null) {
            return object;
        }
        if (this.delegate != null) {
            return this.delegate.get(labelledClass);
        }
        return null;
    }

    protected @Nullable ILabelGenerator<?> getLabelGenerator(@NonNull Class<?> cls) {
        ILabelGenerator<?> labelGenerator;
        Class<?> iCls;
        Class<?> sCls = cls;
        while (sCls != null) {
            ILabelGenerator<?> labelGenerator2 = this.get(sCls);
            if (labelGenerator2 != null) {
                return labelGenerator2;
            }
            sCls = sCls.getSuperclass();
        }
        Class<?>[] classArray = cls.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            iCls = classArray[n2];
            labelGenerator = this.get(iCls);
            if (labelGenerator != null) {
                return labelGenerator;
            }
            ++n2;
        }
        classArray = cls.getInterfaces();
        n = classArray.length;
        n2 = 0;
        while (n2 < n) {
            iCls = classArray[n2];
            labelGenerator = this.getLabelGenerator(iCls);
            if (labelGenerator != null) {
                return labelGenerator;
            }
            ++n2;
        }
        sCls = cls.getSuperclass();
        if (sCls != null) {
            return this.getLabelGenerator(sCls);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Object install(@NonNull Class<?> labelledClass, @NonNull ILabelGenerator.Descriptor labelDescriptor) {
        Map<Class<?>, Object> map = this.map;
        synchronized (map) {
            return this.map.put(labelledClass, labelDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Object install(@NonNull Class<?> labelledClass, @NonNull ILabelGenerator<?> labelGenerator) {
        Map<Class<?>, Object> map = this.map;
        synchronized (map) {
            return this.map.put(labelledClass, labelGenerator);
        }
    }

    @Override
    public @NonNull String labelFor(@Nullable Object labelledObject) {
        ILabelGenerator.Builder labelBuilder = this.createDefaultLabelBuilder(labelledObject, null);
        labelBuilder.buildLabelFor(labelledObject);
        return labelBuilder.toString();
    }

    @Override
    public @NonNull String labelFor(@Nullable Object labelledObject, @Nullable Map<ILabelGenerator.Option<?>, Object> options) {
        ILabelGenerator.Builder labelBuilder = this.createDefaultLabelBuilder(labelledObject, options);
        labelBuilder.buildLabelFor(labelledObject);
        return labelBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall(@NonNull Class<?> labelledClass) {
        Map<Class<?>, Object> map = this.map;
        synchronized (map) {
            for (Class<?> aClass : new ArrayList(this.map.keySet())) {
                if (!labelledClass.isAssignableFrom(aClass)) continue;
                this.map.remove(aClass);
            }
        }
    }

    /* synthetic */ LabelGeneratorRegistry(LabelGeneratorRegistry labelGeneratorRegistry) {
        this();
    }

    public static class Global
    extends LabelGeneratorRegistry {
        private boolean initialized = false;

        public Global() {
            super(null);
        }

        public void initialize() {
            this.initialized = true;
            if (EcorePlugin.IS_ECLIPSE_RUNNING) {
                new LabelGeneratorRegistryReader(this).readRegistry();
            } else {
                Global.initialize(this);
            }
        }

        @Override
        public @Nullable ILabelGenerator<?> get(@NonNull Class<?> labelledClass) {
            if (!this.initialized) {
                this.initialize();
            }
            return super.get(labelledClass);
        }

        @Override
        public @Nullable Object install(@NonNull Class<?> labelledClass, @NonNull ILabelGenerator.Descriptor labelDescriptor) {
            if (!this.initialized) {
                this.initialize();
            }
            return super.install(labelledClass, labelDescriptor);
        }

        @Override
        public @Nullable Object install(@NonNull Class<?> labelledClass, @NonNull ILabelGenerator<?> labelGenerator) {
            if (!this.initialized) {
                this.initialize();
            }
            return super.install(labelledClass, labelGenerator);
        }

        @Override
        public void uninstall(@NonNull Class<?> labelledClass) {
            if (!this.initialized) {
                this.initialize();
            }
            super.uninstall(labelledClass);
        }
    }
}

