/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.impl;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.oomph.setup.ResourceCreationTask;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.Messages;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.osgi.util.NLS;

public class ResourceCreationTaskImpl
extends SetupTaskImpl
implements ResourceCreationTask {
    protected static final boolean FORCE_EDEFAULT = false;
    protected boolean force = false;
    protected static final String CONTENT_EDEFAULT = null;
    protected String content = CONTENT_EDEFAULT;
    protected static final String TARGET_URL_EDEFAULT = null;
    protected String targetURL = TARGET_URL_EDEFAULT;
    protected static final String ENCODING_EDEFAULT = null;
    protected String encoding = ENCODING_EDEFAULT;

    protected ResourceCreationTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupPackage.Literals.RESOURCE_CREATION_TASK;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean newForce) {
        boolean oldForce = this.force;
        this.force = newForce;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldForce, this.force));
        }
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String newContent) {
        String oldContent = this.content;
        this.content = newContent;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldContent, (Object)this.content));
        }
    }

    public String getTargetURL() {
        return this.targetURL;
    }

    public void setTargetURL(String newTargetURL) {
        String oldTargetURL = this.targetURL;
        this.targetURL = newTargetURL;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldTargetURL, (Object)this.targetURL));
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String newEncoding) {
        String oldEncoding = this.encoding;
        this.encoding = newEncoding;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldEncoding, (Object)this.encoding));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.isForce();
            }
            case 11: {
                return this.getContent();
            }
            case 12: {
                return this.getTargetURL();
            }
            case 13: {
                return this.getEncoding();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setForce((Boolean)newValue);
                return;
            }
            case 11: {
                this.setContent((String)newValue);
                return;
            }
            case 12: {
                this.setTargetURL((String)newValue);
                return;
            }
            case 13: {
                this.setEncoding((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setForce(false);
                return;
            }
            case 11: {
                this.setContent(CONTENT_EDEFAULT);
                return;
            }
            case 12: {
                this.setTargetURL(TARGET_URL_EDEFAULT);
                return;
            }
            case 13: {
                this.setEncoding(ENCODING_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.force;
            }
            case 11: {
                return CONTENT_EDEFAULT == null ? this.content != null : !CONTENT_EDEFAULT.equals(this.content);
            }
            case 12: {
                return TARGET_URL_EDEFAULT == null ? this.targetURL != null : !TARGET_URL_EDEFAULT.equals(this.targetURL);
            }
            case 13: {
                return ENCODING_EDEFAULT == null ? this.encoding != null : !ENCODING_EDEFAULT.equals(this.encoding);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        String line = this.content;
        if (line != null) {
            int pos;
            int newLine = line.indexOf(10);
            int lineFeed = line.indexOf(13);
            int n = newLine != -1 && lineFeed != -1 ? Math.min(newLine, lineFeed) : (pos = newLine != -1 ? newLine : lineFeed);
            if (pos != -1) {
                line = line.substring(0, pos);
            }
            if (line.length() > 100) {
                line = line.substring(0, 100);
            }
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (content: ");
        result.append(line);
        result.append(", targetURL: ");
        result.append(this.targetURL);
        result.append(", encoding: ");
        result.append(this.encoding);
        result.append(')');
        return result.toString();
    }

    public int getProgressMonitorWork() {
        return 2;
    }

    public Object getOverrideToken() {
        return this.createToken(this.getTargetURL());
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        URI targetURI = this.createResolvedURI(this.getTargetURL());
        return targetURI != null && (this.isForce() || !context.getURIConverter().exists(targetURI, null));
    }

    public void perform(SetupTaskContext context) throws Exception {
        URI targetURI = this.createResolvedURI(this.getTargetURL());
        URIConverter uriConverter = context.getURIConverter();
        context.log(NLS.bind((String)Messages.ResourceCreationTaskImpl_Creating_message, (Object)uriConverter.normalize(targetURI)));
        String content = this.getContent();
        OutputStream outputStream = uriConverter.createOutputStream(targetURI);
        String encoding = this.getEncoding();
        if ("base64".equals(encoding)) {
            content = content.replaceAll("\\s", "");
            byte[] bytes = XMLTypeFactory.eINSTANCE.createBase64Binary(content);
            outputStream.write(bytes);
        } else {
            OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, encoding);
            writer.write(content);
            ((Writer)writer).close();
        }
        outputStream.close();
    }
}

