/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public interface IExecutorPolicy {
    public static final IExecutorPolicy NULL = new IExecutorPolicy(){

        @Override
        public Ranking rank(Runnable task, Executor executor) {
            return Ranking.ACCEPTABLE;
        }
    };

    public Ranking rank(Runnable var1, Executor var2);

    public static enum Ranking {
        DEPRECATED,
        DISCOURAGED,
        ACCEPTABLE,
        PREFERRED,
        REQUIRED;


        public static Executor select(IExecutorPolicy policy, Runnable task, Executor executor1, Executor executor2) throws RejectedExecutionException {
            Ranking rank1 = policy.rank(task, executor1);
            Ranking rank2 = policy.rank(task, executor2);
            if (rank1 == DEPRECATED && rank2 == DEPRECATED) {
                throw new RejectedExecutionException("All available executors rejected by policy");
            }
            return rank1.ordinal() < rank2.ordinal() ? executor2 : executor1;
        }

        public static Executor select(IExecutorPolicy policy, Runnable task, Executor executor1, Executor executor2, Executor executor3, Executor ... more) throws RejectedExecutionException {
            return Ranking.select(policy, task, Iterables.concat(Arrays.asList(executor1, executor2, executor3), Arrays.asList(more)));
        }

        public static Executor select(IExecutorPolicy policy, Runnable task, Iterable<? extends Executor> executors) throws RejectedExecutionException {
            Iterator<? extends Executor> iter = executors.iterator();
            if (!iter.hasNext()) {
                throw new IllegalArgumentException("no executors to select");
            }
            Executor result = iter.next();
            Ranking currentRank = policy.rank(task, result);
            while (currentRank != REQUIRED && iter.hasNext()) {
                Executor next = iter.next();
                Ranking nextRank = policy.rank(task, next);
                if (nextRank.ordinal() <= currentRank.ordinal()) continue;
                result = next;
                currentRank = nextRank;
            }
            if (currentRank == DEPRECATED) {
                throw new RejectedExecutionException("All available executors rejected by policy");
            }
            return result;
        }
    }
}

