/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lang.linescanner;

import org.eclipse.photran.internal.core.lang.linescanner.CharArraySequence;
import org.eclipse.photran.internal.core.lang.linescanner.ILookaheadLineReader;

public final class CharSeqLookaheadLineReader
implements ILookaheadLineReader<Error> {
    private final CharSequence string;
    private int start;
    private int index;

    public CharSeqLookaheadLineReader(CharSequence string) {
        this.string = string;
        this.start = 0;
        this.index = 0;
    }

    public CharSeqLookaheadLineReader(char[] chars) {
        this.string = new CharArraySequence(chars);
        this.start = 0;
        this.index = 0;
    }

    @Override
    public CharSequence readNextLine() {
        if (this.index >= this.string.length()) {
            return null;
        }
        int nextLF = this.indexOf('\n', this.string, this.index) + 1;
        if (nextLF <= 0) {
            nextLF = this.string.length();
        }
        CharSequence result = this.string.subSequence(this.index, nextLF);
        this.index = nextLF;
        return result;
    }

    private int indexOf(char c, CharSequence seq, int start) {
        int i = start;
        int len = seq.length();
        while (i < len) {
            if (seq.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public CharSequence advanceAndRestart(int numChars) {
        CharSequence result = this.string.subSequence(this.start, this.start + numChars);
        this.start += numChars;
        this.index = this.start;
        return result;
    }

    @Override
    public void close() {
    }
}

