/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XSDCardinality implements Enumerator
{
    FINITE_LITERAL(0, "finite", "finite"),
    COUNTABLY_INFINITE_LITERAL(1, "countablyInfinite", "countablyInfinite");

    public static final int FINITE = 0;
    public static final int COUNTABLY_INFINITE = 1;
    private static final XSDCardinality[] VALUES_ARRAY;
    public static final List<XSDCardinality> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XSDCardinality[]{FINITE_LITERAL, COUNTABLY_INFINITE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XSDCardinality get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDCardinality result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDCardinality getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDCardinality result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDCardinality get(int value) {
        switch (value) {
            case 0: {
                return FINITE_LITERAL;
            }
            case 1: {
                return COUNTABLY_INFINITE_LITERAL;
            }
        }
        return null;
    }

    private XSDCardinality(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

