/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ContainerMount;
import org.mandas.docker.client.messages.ImmutableContainer;
import org.mandas.docker.client.messages.NetworkSettings;

@JsonDeserialize(builder=ImmutableContainer.Builder.class)
@Value.Immutable
@Value.Enclosing
public interface Container {
    @JsonProperty(value="Id")
    public String id();

    @JsonProperty(value="Names")
    @Nullable
    public List<String> names();

    @JsonProperty(value="Image")
    public String image();

    @JsonProperty(value="ImageID")
    @Nullable
    public String imageId();

    @JsonProperty(value="Command")
    public String command();

    @JsonProperty(value="Created")
    public Long created();

    @JsonProperty(value="State")
    @Nullable
    public String state();

    @JsonProperty(value="Status")
    public String status();

    @JsonProperty(value="Ports")
    @Nullable
    public List<PortMapping> ports();

    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels();

    @JsonProperty(value="SizeRw")
    @Nullable
    public Long sizeRw();

    @JsonProperty(value="SizeRootFs")
    @Nullable
    public Long sizeRootFs();

    @JsonProperty(value="NetworkSettings")
    @Nullable
    public NetworkSettings networkSettings();

    @JsonProperty(value="Mounts")
    @Nullable
    public List<ContainerMount> mounts();

    @JsonIgnore
    @Value.Derived
    default public String portsAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.ports() != null) {
            for (PortMapping port : this.ports()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if (port.ip() != null) {
                    sb.append(port.ip()).append(":");
                }
                if (port.publicPort() > 0) {
                    sb.append(port.privatePort()).append("->").append(port.publicPort());
                } else {
                    sb.append(port.privatePort());
                }
                sb.append("/").append(port.type());
            }
        }
        return sb.toString();
    }

    @JsonDeserialize(builder=ImmutableContainer.PortMapping.Builder.class)
    @Value.Immutable
    public static interface PortMapping {
        @JsonProperty(value="PrivatePort")
        @Value.Default
        default public int privatePort() {
            return 0;
        }

        @JsonProperty(value="PublicPort")
        @Value.Default
        default public int publicPort() {
            return 0;
        }

        @JsonProperty(value="Type")
        public String type();

        @JsonProperty(value="IP")
        @Nullable
        public String ip();
    }
}

