/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingContainerFactoryWithListener;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsContainer;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsContainerChangeInfo;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsManager;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class CfgExportSettingContainerFactory
extends CExternalSettingContainerFactoryWithListener
implements ICProjectDescriptionListener {
    static final String FACTORY_ID = "org.eclipse.cdt.core.cfg.export.settings.sipplier";
    private static final String ACTIVE_CONFIG_ID = "";
    private static final char DELIMITER = ';';
    private static final ConcurrentHashMap<String, CExternalSetting[]> cachedSettings = new ConcurrentHashMap();
    private static CfgExportSettingContainerFactory fInstance;

    private CfgExportSettingContainerFactory() {
    }

    public static CfgExportSettingContainerFactory getInstance() {
        if (fInstance == null) {
            fInstance = new CfgExportSettingContainerFactory();
        }
        return fInstance;
    }

    @Override
    public void startup() {
        CProjectDescriptionManager.getInstance().addCProjectDescriptionListener(this, 5);
    }

    @Override
    public void shutdown() {
        CProjectDescriptionManager.getInstance().removeCProjectDescriptionListener(this);
    }

    @Override
    public CExternalSettingsContainer createContainer(String id, IProject project, ICConfigurationDescription cfgDes, CExternalSetting[] previousSettings) throws CoreException {
        String[] r = CfgExportSettingContainerFactory.parseId(id);
        return new CfgRefContainer(id, r[0], r[1], previousSettings);
    }

    private static void createReference(ICConfigurationDescription cfg, String projName, String cfgId) {
        CExternalSettingsManager.CContainerRef cr = CfgExportSettingContainerFactory.createContainerRef(projName, cfgId);
        CExternalSettingsManager.getInstance().addContainer(cfg, cr);
    }

    private static void removeReference(ICConfigurationDescription cfg, String projName, String cfgId) {
        CExternalSettingsManager.CContainerRef cr = CfgExportSettingContainerFactory.createContainerRef(projName, cfgId);
        CExternalSettingsManager.getInstance().removeContainer(cfg, cr);
    }

    private static CExternalSettingsManager.CContainerRef createContainerRef(String projName, String cfgId) {
        return new CExternalSettingsManager.CContainerRef(FACTORY_ID, CfgExportSettingContainerFactory.createId(projName, cfgId));
    }

    public static Map<String, String> getReferenceMap(ICConfigurationDescription cfg) {
        CExternalSettingsManager.CContainerRef[] refs = CExternalSettingsManager.getInstance().getReferences(cfg, FACTORY_ID);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < refs.length) {
            try {
                String[] r = CfgExportSettingContainerFactory.parseId(refs[i].getContainerId());
                map.put(r[0], r[1]);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            ++i;
        }
        return map;
    }

    public static void setReferenceMap(ICConfigurationDescription cfg, Map<String, String> map) {
        Map<String, String> oldRefs = CfgExportSettingContainerFactory.getReferenceMap(cfg);
        LinkedHashMap<String, String> newRefs = new LinkedHashMap<String, String>(map);
        Iterator<Map.Entry<String, String>> oldIter = oldRefs.entrySet().iterator();
        Iterator newIter = newRefs.entrySet().iterator();
        while (oldIter.hasNext() && newIter.hasNext()) {
            Map.Entry newEntry;
            Map.Entry<String, String> entry = oldIter.next();
            if (!entry.equals(newEntry = newIter.next())) break;
            oldIter.remove();
            newIter.remove();
        }
        for (Map.Entry<String, String> entry : oldRefs.entrySet()) {
            CfgExportSettingContainerFactory.removeReference(cfg, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : newRefs.entrySet()) {
            CfgExportSettingContainerFactory.createReference(cfg, entry.getKey(), entry.getValue());
        }
    }

    private static String createId(String projName, String cfgId) {
        return String.valueOf(projName) + ';' + cfgId;
    }

    private static String[] parseId(String id) throws CoreException {
        String cfgId;
        String projName;
        if (id == null) {
            throw new NullPointerException();
        }
        int index = id.indexOf(59);
        if (index != -1) {
            projName = id.substring(0, index);
            cfgId = id.substring(index + 1);
        } else {
            projName = id;
            cfgId = ACTIVE_CONFIG_ID;
        }
        projName = projName.trim();
        if (projName.length() == 0) {
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CfgExportSettingContainerFactory.2"));
        }
        return new String[]{projName, cfgId};
    }

    @Override
    public void handleEvent(CProjectDescriptionEvent event) {
        switch (event.getEventType()) {
            case 1: {
                String projName = event.getProject().getName();
                ICConfigurationDescription[] descs = event.getNewCProjectDescription().getConfigurations();
                CExternalSettingsContainerChangeInfo[] changeInfos = new CExternalSettingsContainerChangeInfo[descs.length + 1];
                int i = 0;
                ICConfigurationDescription[] iCConfigurationDescriptionArray = event.getNewCProjectDescription().getConfigurations();
                int n = iCConfigurationDescriptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICConfigurationDescription desc = iCConfigurationDescriptionArray[n2];
                    changeInfos[i++] = new CExternalSettingsContainerChangeInfo(2, new CExternalSettingsManager.CContainerRef(FACTORY_ID, CfgExportSettingContainerFactory.createId(projName, desc.getId())), null);
                    ++n2;
                }
                changeInfos[i] = new CExternalSettingsContainerChangeInfo(2, new CExternalSettingsManager.CContainerRef(FACTORY_ID, CfgExportSettingContainerFactory.createId(projName, ACTIVE_CONFIG_ID)), null);
                this.notifySettingsChange(null, null, changeInfos);
                break;
            }
            case 4: {
                String[] ids = this.getContainerIds(event.getProjectDelta());
                if (ids.length == 0) break;
                CExternalSettingsContainerChangeInfo[] changeInfos = new CExternalSettingsContainerChangeInfo[ids.length];
                int i = 0;
                while (i < changeInfos.length) {
                    changeInfos[i] = new CExternalSettingsContainerChangeInfo(2, new CExternalSettingsManager.CContainerRef(FACTORY_ID, ids[i]), null);
                    ++i;
                }
                this.notifySettingsChange(null, null, changeInfos);
            }
        }
    }

    private String[] getContainerIds(ICDescriptionDelta delta) {
        if (delta == null) {
            return new String[0];
        }
        int deltaKind = delta.getDeltaKind();
        HashSet<String> cfgIds = new HashSet<String>();
        switch (deltaKind) {
            case 1: 
            case 2: {
                ICProjectDescription des = (ICProjectDescription)delta.getSetting();
                ICConfigurationDescription[] cfgs = des.getConfigurations();
                if (cfgs.length == 0) break;
                int i = 0;
                while (i < cfgs.length) {
                    cfgIds.add(cfgs[i].getId());
                    ++i;
                }
                cfgIds.add(ACTIVE_CONFIG_ID);
                break;
            }
            case 3: {
                ICDescriptionDelta[] children = delta.getChildren();
                this.collectCfgIds(children, cfgIds);
                if ((delta.getChangeFlags() & 1) == 0) break;
                cfgIds.add(ACTIVE_CONFIG_ID);
            }
        }
        String[] ids = new String[cfgIds.size()];
        if (ids.length != 0) {
            String projName = ((ICProjectDescription)delta.getSetting()).getProject().getName();
            int i = 0;
            for (String config : cfgIds) {
                ids[i++] = CfgExportSettingContainerFactory.createId(projName, config);
            }
        }
        return ids;
    }

    private Collection<String> collectCfgIds(ICDescriptionDelta[] deltas, Collection<String> c) {
        ICDescriptionDelta[] iCDescriptionDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            ICDescriptionDelta delta = iCDescriptionDeltaArray[n2];
            switch (delta.getDeltaKind()) {
                case 1: 
                case 2: {
                    c.add(delta.getSetting().getId());
                    break;
                }
                case 3: {
                    int changeFlags = delta.getChangeFlags();
                    if ((changeFlags & 0x18000) == 0) break;
                    c.add(delta.getSetting().getId());
                    if (!delta.getSetting().getConfiguration().isActive()) break;
                    c.add(ACTIVE_CONFIG_ID);
                }
            }
            ++n2;
        }
        return c;
    }

    private static class CfgRefContainer
    extends CExternalSettingsContainer {
        private final String fId;
        private final String fProjName;
        private final String fCfgId;
        private final CExternalSetting[] prevSettings;

        CfgRefContainer(String containerId, String projName, String cfgId, CExternalSetting[] previousSettings) {
            this.fId = containerId;
            this.fProjName = projName;
            this.fCfgId = cfgId;
            this.prevSettings = previousSettings;
        }

        @Override
        public CExternalSetting[] getExternalSettings() {
            ICProjectDescription des;
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProjName);
            if (project.isAccessible() && (des = CProjectDescriptionManager.getInstance().getProjectDescription(project, false)) != null) {
                ICConfigurationDescription cfg;
                ICConfigurationDescription iCConfigurationDescription = cfg = this.fCfgId.length() != 0 ? des.getConfigurationById(this.fCfgId) : des.getActiveConfiguration();
                if (cfg != null) {
                    CExternalSetting[] es;
                    ICExternalSetting[] ies = cfg.getExternalSettings();
                    if (ies instanceof CExternalSetting[]) {
                        es = (CExternalSetting[])ies;
                    } else {
                        es = new CExternalSetting[ies.length];
                        System.arraycopy(ies, 0, es, 0, es.length);
                    }
                    cachedSettings.put(this.fId, es);
                    return es;
                }
            }
            if (!cachedSettings.containsKey(this.fId) && this.prevSettings.length > 0) {
                cachedSettings.putIfAbsent(this.fId, this.prevSettings);
            }
            if (this.prevSettings.length == 0 && cachedSettings.containsKey(this.fId)) {
                return cachedSettings.get(this.fId);
            }
            return this.prevSettings;
        }
    }
}

