/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.internal.server.LockingManager;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.concurrent.RWOLockManager;

public class LockStateIndication
extends CDOServerReadIndication {
    private final LockingManager.LockStateCollector existingLockStates = new LockingManager.LockStateCollector();
    private InternalLockManager lockManager;
    private CDOBranch branch;
    private int prefetchDepth = 0;
    private CDORevisionProvider revisionProvider;

    public LockStateIndication(CDOServerProtocol protocol) {
        super(protocol, (short)52);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        InternalRepository repository = this.getRepository();
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        this.lockManager = repository.getLockingManager();
        int branchID = in.readXInt();
        this.branch = branchManager.getBranch(branchID);
        int idsLength = in.readXInt();
        if (idsLength < 0) {
            idsLength = -idsLength;
            this.prefetchDepth = in.readXInt();
            InternalCDORevisionManager revisionManager = repository.getRevisionManager();
            this.revisionProvider = new ManagedRevisionProvider((CDORevisionManager)revisionManager, this.branch.getHead());
        }
        if (idsLength == 0) {
            this.lockManager.getLockStates((Consumer)this.existingLockStates);
        } else {
            int depth = this.prefetchDepth >= 0 ? this.prefetchDepth : Integer.MAX_VALUE;
            int i = 0;
            while (i < idsLength) {
                CDOID id = in.readCDOID();
                this.prefetchLockStates(depth, id);
                ++i;
            }
        }
    }

    private void prefetchLockStates(int depth, CDOID id) {
        this.addLockState(id);
        if (depth > 0) {
            --depth;
            InternalCDORevision revision = (InternalCDORevision)this.revisionProvider.getRevision(id);
            if (revision == null) {
                return;
            }
            InternalCDOClassInfo classInfo = revision.getClassInfo();
            EStructuralFeature[] eStructuralFeatureArray = classInfo.getAllPersistentFeatures();
            int n = eStructuralFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                EReference reference;
                EStructuralFeature feature = eStructuralFeatureArray[n2];
                if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
                    Object value = revision.getValue((EStructuralFeature)reference);
                    if (value instanceof CDOID) {
                        this.prefetchLockStates(depth, (CDOID)value);
                    } else if (value instanceof Collection) {
                        Collection c = (Collection)value;
                        for (Object e : c) {
                            if (!(e instanceof CDOID)) continue;
                            this.prefetchLockStates(depth, (CDOID)e);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private void addLockState(CDOID id) {
        Object key = this.lockManager.getLockKey(id, this.branch);
        RWOLockManager.LockState lockState = this.lockManager.getLockState(key);
        if (lockState != null) {
            this.existingLockStates.add((Object)CDOLockUtil.convertLockState((RWOLockManager.LockState)lockState));
        }
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        out.writeCDOLockStates((List)this.existingLockStates, null);
    }
}

