/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.core.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.linuxtools.internal.rpm.core.utils.Messages;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.rpm.core.IProjectConfiguration;
import org.eclipse.linuxtools.rpm.core.utils.Utils;

public class RPMBuild {
    private List<String> macroDefines = new ArrayList<String>();
    private String rpmBuildCmd;
    private String mainFolder;

    public RPMBuild(IProjectConfiguration config) {
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.linuxtools.rpm.core");
        if (config.getBuildFolder().getLocation() == null) {
            this.mainFolder = config.getSourcesFolder().getLocationURI().toString();
        }
        this.rpmBuildCmd = node.get("RPMBUILD_CMD", "");
        String[] tmpMacroDefines = new String[]{this.rpmBuildCmd, "-v"};
        this.macroDefines.addAll(Arrays.asList(tmpMacroDefines));
        this.macroDefines.addAll(config.getConfigDefines());
    }

    public IStatus buildPrep(IResource specFile, OutputStream outStream) throws CoreException {
        return this.build(specFile, outStream, "-bp");
    }

    public IStatus buildBinary(IResource specFile, OutputStream outStream) throws CoreException {
        return this.build(specFile, outStream, "-bb");
    }

    public IStatus buildAll(IResource specFile, OutputStream outStream) throws CoreException {
        return this.build(specFile, outStream, "-ba");
    }

    public IStatus buildSource(IResource specFile, OutputStream outStream) throws CoreException {
        return this.build(specFile, outStream, "-bs");
    }

    public IStatus build(IResource specFile, OutputStream outStream, String buildParameter) throws CoreException {
        if (specFile == null) {
            throw new CoreException(Status.error((String)Messages.Specfile_not_found));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(this.macroDefines);
        command.add(buildParameter);
        try {
            if (specFile.getLocation() == null) {
                return this.remoteBuild(specFile, outStream, command);
            }
            command.add(specFile.getLocation().toString());
            return Utils.runCommand(outStream, specFile.getProject(), command.toArray(new String[command.size()]));
        }
        catch (IOException | URISyntaxException e) {
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
    }

    private IStatus remoteBuild(IResource specFile, OutputStream outStream, List<String> command) throws CoreException, URISyntaxException {
        command.remove(0);
        RemoteProxyManager rmtProxyMgr = RemoteProxyManager.getInstance();
        IRemoteCommandLauncher rmtCmdLauncher = null;
        rmtCmdLauncher = rmtProxyMgr.getLauncher(new URI(this.mainFolder));
        command.add(specFile.getLocationURI().getPath());
        String[] empty = new String[]{};
        Process pProxy = rmtCmdLauncher.execute(Path.fromOSString((String)this.rpmBuildCmd), command.toArray(new String[command.size()]), empty, null, (IProgressMonitor)new NullProgressMonitor());
        if (pProxy != null) {
            return Utils.watchProcess(outStream, pProxy);
        }
        return Status.OK_STATUS;
    }
}

