/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.DynamicRuleMatch;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMetaData;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationStep;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.ocl.examples.xtext.serializer.UserElementAnalysis;
import org.eclipse.ocl.examples.xtext.serializer.UserModelAnalysis;

public class UserElementMatcher {
    public static @NonNull Object NOT_AN_OBJECT = new Object();
    protected final @NonNull DynamicRuleMatch dynamicRuleMatch;
    protected final @NonNull SerializationRule serializationRule;
    protected final @NonNull UserModelAnalysis modelAnalysis;
    protected final @NonNull EObject element;
    private @NonNull MatcherContext matcherContext = new MatcherContext();

    public UserElementMatcher(@NonNull DynamicRuleMatch dynamicRuleMatch, @NonNull UserModelAnalysis modelAnalysis, @NonNull EObject element) {
        this.dynamicRuleMatch = dynamicRuleMatch;
        this.serializationRule = dynamicRuleMatch.getSerializationRule();
        this.modelAnalysis = modelAnalysis;
        this.element = element;
    }

    public void addFailedMatchTo(@NonNull DynamicRuleMatch dynamicRuleMatch) {
        this.matcherContext.addFailedMatchTo(dynamicRuleMatch);
    }

    public @Nullable Integer basicGetValue(int variableIndex) {
        assert (variableIndex >= 0);
        return this.dynamicRuleMatch.basicGetValue(variableIndex);
    }

    public Object consumeNext(@NonNull EStructuralFeature eStructuralFeature, int @Nullable [] grammarRuleIndexes) {
        SerializationRule.SerializationAttribute serializationAttribute;
        int index = this.getSize(eStructuralFeature);
        Object object = this.element.eGet(eStructuralFeature);
        if (eStructuralFeature.isMany()) {
            List eList = (List)object;
            if (eList.size() <= index) {
                return NOT_AN_OBJECT;
            }
            object = eList.get(index);
        } else if (index > 0) {
            return NOT_AN_OBJECT;
        }
        if (eStructuralFeature instanceof EReference) {
            assert (grammarRuleIndexes != null);
            EReference eReference = (EReference)eStructuralFeature;
            EObject eObject = (EObject)object;
            if (eReference.isContainment()) {
                if (eObject == null) {
                    return NOT_AN_OBJECT;
                }
                UserElementAnalysis elementAnalysis = this.modelAnalysis.getElementAnalysis(eObject);
                int[] nArray = grammarRuleIndexes;
                int n = grammarRuleIndexes.length;
                int n2 = 0;
                while (n2 < n) {
                    int grammarRuleIndex = nArray[n2];
                    DynamicRuleMatch dynamicRuleMatch = elementAnalysis.basicCreateDynamicRuleMatch(grammarRuleIndex);
                    if (dynamicRuleMatch != null) {
                        @NonNull Integer castInteger = index + 1;
                        this.matcherContext.put(eReference, castInteger);
                        return object;
                    }
                    ++n2;
                }
            } else if (eObject != null) {
                @NonNull Integer castInteger = index + 1;
                this.matcherContext.put(eReference, castInteger);
                return eObject;
            }
            return NOT_AN_OBJECT;
        }
        EAttribute eAttribute = (EAttribute)eStructuralFeature;
        if (!this.element.eIsSet((EStructuralFeature)eAttribute) && !(serializationAttribute = this.serializationRule.getSerializationAttribute(eAttribute)).needsDefault()) {
            return NOT_AN_OBJECT;
        }
        @NonNull Integer castInteger = index + 1;
        this.matcherContext.put(eAttribute, castInteger);
        return object;
    }

    public @NonNull DynamicRuleMatch getDynamicRuleMatch() {
        return this.dynamicRuleMatch;
    }

    public @NonNull EObject getElement() {
        return this.element;
    }

    public @NonNull UserModelAnalysis getModelAnalysis() {
        return this.modelAnalysis;
    }

    public @NonNull SerializationMetaData getSerializationMetaData() {
        return this.modelAnalysis.getSerializationMetaData();
    }

    public @NonNull SerializationRule getSerializationRule() {
        return this.serializationRule;
    }

    public int getSize(@NonNull EStructuralFeature eStructuralFeature) {
        Integer count = SerializationUtils.maybeNull((Integer)this.matcherContext.get(eStructuralFeature));
        return count == null ? 0 : count;
    }

    public int getValue(int variableIndex) {
        return SerializationUtils.nonNullState(this.dynamicRuleMatch.getValue(variableIndex));
    }

    public boolean hasFailed() {
        return this.matcherContext.hasFailed();
    }

    public boolean hasProgressed() {
        return this.matcherContext.hasProgressed();
    }

    public void pop(boolean acceptOrReject) {
        MatcherContext innerMatcherContext = this.matcherContext;
        if (acceptOrReject) {
            this.matcherContext.outerMatcherContext = innerMatcherContext.outerMatcherContext;
        } else {
            this.matcherContext = innerMatcherContext.outerMatcherContext;
        }
    }

    public void push() {
        this.matcherContext = new MatcherContext(this.matcherContext);
    }

    public void setFailureFeature(@NonNull EStructuralFeature eStructuralFeature) {
        this.matcherContext.setFailureFeature(eStructuralFeature);
    }

    public void setFailureStep(@NonNull SerializationStep serializationStep) {
        this.matcherContext.setFailureStep(serializationStep);
    }

    public void setValue(int variableIndex, int matchedCount) {
        this.dynamicRuleMatch.putValue(variableIndex, matchedCount);
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull K> features = new ArrayList(this.matcherContext.keySet());
        Collections.sort(features, SerializationUtils.ENAMED_ELEMENT_COMPARATOR);
        boolean isFirst = true;
        for (EStructuralFeature feature : features) {
            if (!isFirst) {
                s.append(",");
            }
            s.append(feature.getName());
            Integer consumed = SerializationUtils.maybeNull((Integer)this.matcherContext.get(feature));
            assert (consumed != null);
            s.append("[");
            s.append(consumed);
            s.append("]");
            isFirst = false;
        }
        @NonNull String castString = s.toString();
        return castString;
    }

    private static class MatcherContext
    extends HashMap<EStructuralFeature, Integer> {
        private static final long serialVersionUID = 1L;
        private @NonNull MatcherContext outerMatcherContext;
        private @Nullable EStructuralFeature failureFeature = null;
        private @Nullable SerializationStep failureStep = null;

        public MatcherContext() {
            this.outerMatcherContext = this;
        }

        public MatcherContext(@NonNull MatcherContext outerMatcherContext) {
            super(outerMatcherContext);
            this.outerMatcherContext = outerMatcherContext;
        }

        public void addFailedMatchTo(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            SerializationStep failureStep2;
            assert (this.hasFailed());
            EStructuralFeature failureFeature2 = this.failureFeature;
            if (failureFeature2 != null) {
                dynamicRuleMatch.setFailedMatch(failureFeature2);
            }
            if ((failureStep2 = this.failureStep) != null) {
                dynamicRuleMatch.setFailedMatch(failureStep2);
            }
        }

        public boolean hasFailed() {
            return this.failureFeature != null || this.failureStep != null;
        }

        public boolean hasProgressed() {
            if (this.outerMatcherContext == this) {
                return true;
            }
            if (this.size() > this.outerMatcherContext.size()) {
                return true;
            }
            for (EStructuralFeature key : this.keySet()) {
                int thatValue;
                int thisValue = (Integer)this.get(key);
                if (thisValue <= (thatValue = ((Integer)this.outerMatcherContext.get(key)).intValue())) continue;
                return true;
            }
            return false;
        }

        public void setFailureFeature(@NonNull EStructuralFeature failureFeature) {
            this.failureFeature = failureFeature;
        }

        public void setFailureStep(@NonNull SerializationStep failureStep) {
            this.failureStep = failureStep;
        }
    }
}

