/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.ClassOperations;
import org.eclipse.uml2.uml.internal.operations.ParameterOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BehaviorOperations
extends ClassOperations {
    protected BehaviorOperations() {
    }

    public static boolean validateMostOneBehavior(Behavior behavior, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateParametersMatch(Behavior behavior, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        BehavioralFeature specification = behavior.getSpecification();
        if (specification != null) {
            EList<Parameter> behaviorOwnedParameters = behavior.getOwnedParameters();
            EList<Parameter> specificationOwnedParameters = specification.getOwnedParameters();
            if (behaviorOwnedParameters.size() != specificationOwnedParameters.size()) {
                result = false;
            } else {
                Iterator bop = behaviorOwnedParameters.iterator();
                Iterator sop = specificationOwnedParameters.iterator();
                while (bop.hasNext() && sop.hasNext()) {
                    if (ParameterOperations.matches((Parameter)bop.next(), (Parameter)sop.next())) continue;
                    result = false;
                    break;
                }
            }
            if (!result && diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 4, UMLPlugin.INSTANCE.getString("_UI_Behavior_ParametersMatch_diagnostic", BehaviorOperations.getMessageSubstitutions(context, (Object)behavior)), new Object[]{behavior}));
            }
        }
        return result;
    }

    public static boolean validateFeatureOfContextClassifier(Behavior behavior, DiagnosticChain diagnostics, Map<Object, Object> context) {
        BehavioredClassifier contextClassifier;
        BehavioralFeature specification = behavior.getSpecification();
        if (!(specification == null || (contextClassifier = behavior.getContext()) != null && contextClassifier.allFeatures().contains((Object)specification))) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 5, UMLPlugin.INSTANCE.getString("_UI_Behavior_FeatureOfContextClassifier_diagnostic", BehaviorOperations.getMessageSubstitutions(context, (Object)behavior)), new Object[]{behavior}));
            }
            return false;
        }
        return true;
    }

    public static BehavioredClassifier getContext(Behavior behavior) {
        BehavioredClassifier b;
        BehavioredClassifier context = null;
        EReference containmentFeature = behavior.eContainmentFeature();
        if (containmentFeature != UMLPackage.Literals.CLASS__NESTED_CLASSIFIER && containmentFeature != UMLPackage.Literals.INTERFACE__NESTED_CLASSIFIER && (b = behavior.behavioredClassifier(behavior.getOwner())) != null) {
            if (b instanceof Behavior) {
                context = ((Behavior)b).getContext();
            }
            if (context == null) {
                context = b;
            }
        }
        return context;
    }

    public static BehavioredClassifier behavioredClassifier(Behavior behavior, Element from) {
        if (from instanceof BehavioredClassifier) {
            return (BehavioredClassifier)from;
        }
        Element owner = from == null ? null : from.getOwner();
        return owner == null ? null : behavior.behavioredClassifier(owner);
    }

    public static EList<Parameter> inputParameters(Behavior behavior) {
        UniqueEList.FastCompare inputParameters = new UniqueEList.FastCompare();
        for (Parameter ownedParameter : behavior.getOwnedParameters()) {
            ParameterDirectionKind direction = ownedParameter.getDirection();
            if (direction != ParameterDirectionKind.IN_LITERAL && direction != ParameterDirectionKind.INOUT_LITERAL) continue;
            inputParameters.add((Object)ownedParameter);
        }
        return ECollections.unmodifiableEList((EList)inputParameters);
    }

    public static EList<Parameter> outputParameters(Behavior behavior) {
        UniqueEList.FastCompare outputParameters = new UniqueEList.FastCompare();
        for (Parameter ownedParameter : behavior.getOwnedParameters()) {
            ParameterDirectionKind direction = ownedParameter.getDirection();
            if (direction != ParameterDirectionKind.OUT_LITERAL && direction != ParameterDirectionKind.INOUT_LITERAL && direction != ParameterDirectionKind.RETURN_LITERAL) continue;
            outputParameters.add((Object)ownedParameter);
        }
        return ECollections.unmodifiableEList((EList)outputParameters);
    }
}

